/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.utility.BodySourceWriter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.HashBag;
import org.eclipse.jpt.common.utility.internal.NotNullFilter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SubIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.common.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.common.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.GeneratorContainer;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.MappingFile;
import org.eclipse.jpt.jpa.core.context.MappingFilePersistenceUnitDefaults;
import org.eclipse.jpt.jpa.core.context.MappingFilePersistenceUnitMetadata;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.QueryContainer;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaGenerator;
import org.eclipse.jpt.jpa.core.context.java.JavaQuery;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmQuery;
import org.eclipse.jpt.jpa.core.context.orm.OrmXml;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.JarFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitTransactionType;
import org.eclipse.jpt.jpa.core.context.persistence.PersistentTypeContainer;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractPersistenceXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.jpa2.JpaFactory2_0;
import org.eclipse.jpt.jpa.core.jpa2.JpaProject2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.MappingFilePersistenceUnitDefaults2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.MetamodelSourceType;
import org.eclipse.jpt.jpa.core.jpa2.context.PersistentType2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.PersistenceUnit2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.options.SharedCacheMode;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.options.ValidationMode;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.JavaResourcePersistentType2_0;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlJarFileRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlProperties;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlProperty;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPersistenceUnit
extends AbstractPersistenceXmlContextNode
implements PersistenceUnit2_0 {
    protected final XmlPersistenceUnit xmlPersistenceUnit;
    protected String name;
    protected Boolean specifiedExcludeUnlistedClasses;
    protected PersistenceUnitTransactionType specifiedTransactionType;
    protected PersistenceUnitTransactionType defaultTransactionType;
    protected String description;
    protected String provider;
    protected String jtaDataSource;
    protected String nonJtaDataSource;
    protected final Vector<MappingFileRef> specifiedMappingFileRefs = new Vector();
    protected final SpecifiedMappingFileRefContainerAdapter specifiedMappingFileRefContainerAdapter = new SpecifiedMappingFileRefContainerAdapter();
    protected MappingFileRef impliedMappingFileRef;
    protected final Vector<JarFileRef> jarFileRefs = new Vector();
    protected final JarFileRefContainerAdapter jarFileRefContainerAdapter = new JarFileRefContainerAdapter();
    protected final Vector<ClassRef> specifiedClassRefs = new Vector();
    protected final SpecifiedClassRefContainerAdapter specifiedClassRefContainerAdapter = new SpecifiedClassRefContainerAdapter();
    protected final Set<ClassRef> impliedClassRefs = Collections.synchronizedSet(new HashSet());
    protected final ImpliedClassRefContainerAdapter impliedClassRefContainerAdapter = new ImpliedClassRefContainerAdapter();
    protected final Vector<PersistenceUnit.Property> properties = new Vector();
    protected final PropertyContainerAdapter propertyContainerAdapter = new PropertyContainerAdapter();
    protected final Vector<Generator> generators = new Vector();
    protected final Vector<Query> queries = new Vector();
    protected boolean xmlMappingMetadataComplete;
    protected AccessType defaultAccess;
    protected String defaultCatalog;
    protected String defaultSchema;
    protected boolean defaultCascadePersist;
    protected boolean defaultDelimitedIdentifiers;
    protected PersistenceUnitProperties connection;
    protected PersistenceUnitProperties options;
    protected SharedCacheMode specifiedSharedCacheMode;
    protected SharedCacheMode defaultSharedCacheMode;
    protected ValidationMode specifiedValidationMode;
    protected ValidationMode defaultValidationMode;
    protected final Set<IFile> metamodelFiles = Collections.synchronizedSet(new HashSet());

    protected AbstractPersistenceUnit(Persistence parent, XmlPersistenceUnit xmlPersistenceUnit) {
        super(parent);
        this.xmlPersistenceUnit = xmlPersistenceUnit;
        this.name = xmlPersistenceUnit.getName();
        this.specifiedExcludeUnlistedClasses = xmlPersistenceUnit.getExcludeUnlistedClasses();
        this.specifiedTransactionType = this.buildSpecifiedTransactionType();
        this.description = xmlPersistenceUnit.getDescription();
        this.provider = xmlPersistenceUnit.getProvider();
        this.jtaDataSource = xmlPersistenceUnit.getJtaDataSource();
        this.nonJtaDataSource = xmlPersistenceUnit.getNonJtaDataSource();
        this.initializeProperties();
        this.initializeSpecifiedMappingFileRefs();
        this.initializeJarFileRefs();
        this.initializeSpecifiedClassRefs();
        this.specifiedSharedCacheMode = this.buildSpecifiedSharedCacheMode();
        this.specifiedValidationMode = this.buildSpecifiedValidationMode();
        this.initializeMetamodelFiles();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.xmlPersistenceUnit.getName());
        this.setSpecifiedExcludeUnlistedClasses_(this.xmlPersistenceUnit.getExcludeUnlistedClasses());
        this.setSpecifiedTransactionType_(this.buildSpecifiedTransactionType());
        this.setDescription_(this.xmlPersistenceUnit.getDescription());
        this.setProvider_(this.xmlPersistenceUnit.getProvider());
        this.setJtaDataSource_(this.xmlPersistenceUnit.getJtaDataSource());
        this.setNonJtaDataSource_(this.xmlPersistenceUnit.getNonJtaDataSource());
        this.syncSpecifiedMappingFileRefs();
        this.syncImpliedMappingFileRef();
        this.syncJarFileRefs();
        this.syncSpecifiedClassRefs();
        this.synchronizeNodesWithResourceModel(this.getImpliedClassRefs());
        this.syncProperties();
        this.setSpecifiedSharedCacheMode_(this.buildSpecifiedSharedCacheMode());
        this.setSpecifiedValidationMode_(this.buildSpecifiedValidationMode());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultTransactionType(this.buildDefaultTransactionType());
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSpecifiedClassRefs());
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSpecifiedMappingFileRefs());
        this.updateImpliedMappingFileRef();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getJarFileRefs());
        this.updateImpliedClassRefs();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getProperties());
        this.updatePersistenceUnitMetadata();
        this.setGenerators(this.buildGenerators());
        this.setQueries(this.buildQueries());
        this.setDefaultSharedCacheMode(this.buildDefaultSharedCacheMode());
        this.setDefaultValidationMode(this.buildDefaultValidationMode());
    }

    @Override
    public Persistence getParent() {
        return (Persistence)super.getParent();
    }

    protected Persistence getPersistence() {
        return this.getParent();
    }

    @Override
    public PersistenceUnit getPersistenceUnit() {
        return this;
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.jpa.core.persistence.persistenceUnit";
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlPersistenceUnit.getSelectionTextRange();
    }

    @Override
    public void dispose() {
        for (ClassRef classRef : this.getClassRefs()) {
            classRef.dispose();
        }
        for (JarFileRef jarFileRef : this.getJarFileRefs()) {
            jarFileRef.dispose();
        }
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            mappingFileRef.dispose();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName_(name);
        this.xmlPersistenceUnit.setName(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public PersistenceUnitTransactionType getTransactionType() {
        return this.specifiedTransactionType != null ? this.specifiedTransactionType : this.defaultTransactionType;
    }

    @Override
    public PersistenceUnitTransactionType getSpecifiedTransactionType() {
        return this.specifiedTransactionType;
    }

    @Override
    public void setSpecifiedTransactionType(PersistenceUnitTransactionType transactionType) {
        this.setSpecifiedTransactionType_(transactionType);
        this.xmlPersistenceUnit.setTransactionType(PersistenceUnitTransactionType.toXmlResourceModel(transactionType));
    }

    protected void setSpecifiedTransactionType_(PersistenceUnitTransactionType transactionType) {
        PersistenceUnitTransactionType old = this.specifiedTransactionType;
        this.specifiedTransactionType = transactionType;
        this.firePropertyChanged("specifiedTransactionType", (Object)old, (Object)transactionType);
    }

    @Override
    public PersistenceUnitTransactionType getDefaultTransactionType() {
        return this.defaultTransactionType;
    }

    protected void setDefaultTransactionType(PersistenceUnitTransactionType transactionType) {
        PersistenceUnitTransactionType old = this.defaultTransactionType;
        this.defaultTransactionType = transactionType;
        this.firePropertyChanged("defaultTransactionType", (Object)old, (Object)transactionType);
    }

    protected PersistenceUnitTransactionType buildSpecifiedTransactionType() {
        return PersistenceUnitTransactionType.fromXmlResourceModel(this.xmlPersistenceUnit.getTransactionType());
    }

    protected PersistenceUnitTransactionType buildDefaultTransactionType() {
        return PersistenceUnitTransactionType.JTA;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.setDescription_(description);
        this.xmlPersistenceUnit.setDescription(description);
    }

    protected void setDescription_(String description) {
        String old = this.description;
        this.description = description;
        this.firePropertyChanged("description", old, description);
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(String provider) {
        this.setProvider_(provider);
        this.xmlPersistenceUnit.setProvider(provider);
    }

    protected void setProvider_(String provider) {
        String old = this.provider;
        this.provider = provider;
        this.firePropertyChanged("provider", old, provider);
    }

    @Override
    public String getJtaDataSource() {
        return this.jtaDataSource;
    }

    @Override
    public void setJtaDataSource(String jtaDataSource) {
        this.setJtaDataSource_(jtaDataSource);
        this.xmlPersistenceUnit.setJtaDataSource(jtaDataSource);
    }

    protected void setJtaDataSource_(String jtaDataSource) {
        String old = this.jtaDataSource;
        this.jtaDataSource = jtaDataSource;
        this.firePropertyChanged("jtaDataSource", old, jtaDataSource);
    }

    @Override
    public String getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    @Override
    public void setNonJtaDataSource(String nonJtaDataSource) {
        this.setNonJtaDataSource_(nonJtaDataSource);
        this.xmlPersistenceUnit.setNonJtaDataSource(nonJtaDataSource);
    }

    protected void setNonJtaDataSource_(String nonJtaDataSource) {
        String old = this.nonJtaDataSource;
        this.nonJtaDataSource = nonJtaDataSource;
        this.firePropertyChanged("nonJtaDataSource", old, nonJtaDataSource);
    }

    @Override
    public ListIterator<MappingFileRef> mappingFileRefs() {
        return this.getMappingFileRefs().iterator();
    }

    protected Iterator<String> mappingFileRefNames() {
        return new TransformationIterator<MappingFileRef, String>(this.mappingFileRefs()){

            protected String transform(MappingFileRef mappingFileRef) {
                return mappingFileRef.getFileName();
            }
        };
    }

    protected ListIterable<MappingFileRef> getMappingFileRefs() {
        return this.impliedMappingFileRef == null ? this.getSpecifiedMappingFileRefs() : this.getCombinedMappingFileRefs();
    }

    protected ListIterator<MappingFileRef> combinedMappingFileRefs() {
        return this.getCombinedMappingFileRefs().iterator();
    }

    protected ListIterable<MappingFileRef> getCombinedMappingFileRefs() {
        return new CompositeListIterable(this.getSpecifiedMappingFileRefs(), (Object)this.impliedMappingFileRef);
    }

    @Override
    public int mappingFileRefsSize() {
        return this.impliedMappingFileRef == null ? this.specifiedMappingFileRefsSize() : this.combinedMappingFileRefsSize();
    }

    protected int combinedMappingFileRefsSize() {
        return this.specifiedMappingFileRefsSize() + 1;
    }

    @Override
    public Iterator<MappingFileRef> mappingFileRefsContaining(final String typeName) {
        return new FilteringIterator<MappingFileRef>(this.mappingFileRefs()){

            protected boolean accept(MappingFileRef mappingFileRef) {
                return mappingFileRef.getPersistentType(typeName) != null;
            }
        };
    }

    @Override
    public ListIterator<MappingFileRef> specifiedMappingFileRefs() {
        return this.getSpecifiedMappingFileRefs().iterator();
    }

    protected ListIterable<MappingFileRef> getSpecifiedMappingFileRefs() {
        return new LiveCloneListIterable(this.specifiedMappingFileRefs);
    }

    @Override
    public int specifiedMappingFileRefsSize() {
        return this.specifiedMappingFileRefs.size();
    }

    @Override
    public MappingFileRef addSpecifiedMappingFileRef(String fileName) {
        return this.addSpecifiedMappingFileRef(this.specifiedMappingFileRefs.size(), fileName);
    }

    @Override
    public MappingFileRef addSpecifiedMappingFileRef(int index, String fileName) {
        XmlMappingFileRef xmlMappingFileRef = this.buildXmlMappingFileRef(fileName);
        MappingFileRef mappingFileRef = this.addSpecifiedMappingFileRef_(index, xmlMappingFileRef);
        this.xmlPersistenceUnit.getMappingFiles().add(index, (Object)xmlMappingFileRef);
        return mappingFileRef;
    }

    protected XmlMappingFileRef buildXmlMappingFileRef(String fileName) {
        XmlMappingFileRef ref = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        ref.setFileName(fileName);
        return ref;
    }

    protected MappingFileRef buildSpecifiedMappingFileRef(XmlMappingFileRef xmlMappingFileRef) {
        return this.getContextNodeFactory().buildMappingFileRef(this, xmlMappingFileRef);
    }

    @Override
    public void removeSpecifiedMappingFileRef(MappingFileRef mappingFileRef) {
        this.removeSpecifiedMappingFileRef(this.specifiedMappingFileRefs.indexOf(mappingFileRef));
    }

    @Override
    public void removeSpecifiedMappingFileRef(int index) {
        this.removeSpecifiedMappingFileRef_(index);
        this.xmlPersistenceUnit.getMappingFiles().remove(index);
    }

    protected void removeSpecifiedMappingFileRef_(int index) {
        ((MappingFileRef)this.removeItemFromList(index, this.specifiedMappingFileRefs, "specifiedMappingFileRefs")).dispose();
    }

    protected void initializeSpecifiedMappingFileRefs() {
        for (XmlMappingFileRef xmlMappingFileRef : this.getXmlMappingFileRefs()) {
            this.specifiedMappingFileRefs.add(this.buildSpecifiedMappingFileRef(xmlMappingFileRef));
        }
    }

    protected void syncSpecifiedMappingFileRefs() {
        ContextContainerTools.synchronizeWithResourceModel(this.specifiedMappingFileRefContainerAdapter);
    }

    protected Iterable<XmlMappingFileRef> getXmlMappingFileRefs() {
        return new LiveCloneIterable(this.xmlPersistenceUnit.getMappingFiles());
    }

    protected void moveSpecifiedMappingFileRef_(int index, MappingFileRef mappingFileRef) {
        this.moveItemInList(index, mappingFileRef, this.specifiedMappingFileRefs, "specifiedMappingFileRefs");
    }

    protected MappingFileRef addSpecifiedMappingFileRef_(int index, XmlMappingFileRef xmlMappingFileRef) {
        MappingFileRef mappingFileRef = this.buildSpecifiedMappingFileRef(xmlMappingFileRef);
        this.addItemToList(index, mappingFileRef, this.specifiedMappingFileRefs, "specifiedMappingFileRefs");
        return mappingFileRef;
    }

    protected void removeSpecifiedMappingFileRef_(MappingFileRef mappingFileRef) {
        this.removeSpecifiedMappingFileRef_(this.specifiedMappingFileRefs.indexOf(mappingFileRef));
    }

    @Override
    public MappingFileRef getImpliedMappingFileRef() {
        return this.impliedMappingFileRef;
    }

    protected MappingFileRef addImpliedMappingFileRef() {
        if (this.impliedMappingFileRef != null) {
            throw new IllegalStateException("The implied mapping file ref is already set: " + this.impliedMappingFileRef);
        }
        this.impliedMappingFileRef = this.buildImpliedMappingFileRef();
        this.firePropertyChanged("impliedMappingFileRef", null, this.impliedMappingFileRef);
        return this.impliedMappingFileRef;
    }

    protected MappingFileRef buildImpliedMappingFileRef() {
        return this.getContextNodeFactory().buildImpliedMappingFileRef(this);
    }

    protected void removeImpliedMappingFileRef() {
        if (this.impliedMappingFileRef == null) {
            throw new IllegalStateException("The implied mapping file ref is already unset.");
        }
        MappingFileRef old = this.impliedMappingFileRef;
        this.impliedMappingFileRef = null;
        old.dispose();
        this.firePropertyChanged("impliedMappingFileRef", old, null);
    }

    protected void syncImpliedMappingFileRef() {
        if (this.impliedMappingFileRef != null) {
            this.impliedMappingFileRef.synchronizeWithResourceModel();
        }
    }

    protected void updateImpliedMappingFileRef() {
        if (this.buildsImpliedMappingFile()) {
            if (this.impliedMappingFileRef == null) {
                this.addImpliedMappingFileRef();
            } else {
                this.impliedMappingFileRef.update();
            }
        } else if (this.impliedMappingFileRef != null) {
            this.removeImpliedMappingFileRef();
        }
    }

    protected boolean buildsImpliedMappingFile() {
        return this.impliedMappingFileIsNotSpecified() && this.impliedMappingFileExists();
    }

    protected boolean impliedMappingFileIsNotSpecified() {
        return !this.impliedMappingFileIsSpecified();
    }

    protected boolean impliedMappingFileIsSpecified() {
        return this.mappingFileIsSpecified(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
    }

    protected boolean mappingFileIsSpecified(String impliedMappingFileName) {
        for (MappingFileRef specifiedMappingFileRef : this.getSpecifiedMappingFileRefs()) {
            if (!Tools.valuesAreEqual((Object)specifiedMappingFileRef.getFileName(), (Object)impliedMappingFileName)) continue;
            return true;
        }
        return false;
    }

    protected boolean impliedMappingFileExists() {
        return this.getJpaProject().getDefaultOrmXmlResource() != null;
    }

    @Override
    public ListIterator<JarFileRef> jarFileRefs() {
        return this.getJarFileRefs().iterator();
    }

    protected ListIterable<JarFileRef> getJarFileRefs() {
        return new LiveCloneListIterable(this.jarFileRefs);
    }

    @Override
    public int jarFileRefsSize() {
        return this.jarFileRefs.size();
    }

    protected Iterable<String> getJarFileNames() {
        return new TransformationIterable<JarFileRef, String>(this.getJarFileRefs()){

            protected String transform(JarFileRef jarFileRef) {
                return jarFileRef.getFileName();
            }
        };
    }

    @Override
    public JarFileRef addJarFileRef(String fileName) {
        return this.addJarFileRef(this.jarFileRefs.size(), fileName);
    }

    @Override
    public JarFileRef addJarFileRef(int index, String fileName) {
        XmlJarFileRef xmlJarFileRef = this.buildXmlJarFileRef(fileName);
        JarFileRef jarFileRef = this.addJarFileRef_(index, xmlJarFileRef);
        this.xmlPersistenceUnit.getJarFiles().add(index, (Object)xmlJarFileRef);
        return jarFileRef;
    }

    protected XmlJarFileRef buildXmlJarFileRef(String fileName) {
        XmlJarFileRef ref = PersistenceFactory.eINSTANCE.createXmlJarFileRef();
        ref.setFileName(fileName);
        return ref;
    }

    protected JarFileRef buildJarFileRef(XmlJarFileRef xmlJarFileRef) {
        return this.getContextNodeFactory().buildJarFileRef(this, xmlJarFileRef);
    }

    @Override
    public void removeJarFileRef(JarFileRef jarFileRef) {
        this.removeJarFileRef(this.jarFileRefs.indexOf(jarFileRef));
    }

    @Override
    public void removeJarFileRef(int index) {
        this.removeJarFileRef_(index);
        this.xmlPersistenceUnit.getJarFiles().remove(index);
    }

    protected void removeJarFileRef_(int index) {
        ((JarFileRef)this.removeItemFromList(index, this.jarFileRefs, "jarFileRefs")).dispose();
    }

    protected void initializeJarFileRefs() {
        for (XmlJarFileRef xmlJarFileRef : this.getXmlJarFileRefs()) {
            this.jarFileRefs.add(this.buildJarFileRef(xmlJarFileRef));
        }
    }

    protected void syncJarFileRefs() {
        ContextContainerTools.synchronizeWithResourceModel(this.jarFileRefContainerAdapter);
    }

    protected Iterable<XmlJarFileRef> getXmlJarFileRefs() {
        return new LiveCloneIterable(this.xmlPersistenceUnit.getJarFiles());
    }

    protected void moveJarFileRef_(int index, JarFileRef jarFileRef) {
        this.moveItemInList(index, jarFileRef, this.jarFileRefs, "jarFileRefs");
    }

    protected JarFileRef addJarFileRef_(int index, XmlJarFileRef xmlJarFileRef) {
        JarFileRef jarFileRef = this.buildJarFileRef(xmlJarFileRef);
        this.addItemToList(index, jarFileRef, this.jarFileRefs, "jarFileRefs");
        return jarFileRef;
    }

    protected void removeJarFileRef_(JarFileRef jarFileRef) {
        this.removeJarFileRef_(this.jarFileRefs.indexOf(jarFileRef));
    }

    @Override
    public Iterator<ClassRef> classRefs() {
        return this.getClassRefs().iterator();
    }

    protected Iterable<ClassRef> getClassRefs() {
        return new CompositeIterable(new Iterable[]{this.getSpecifiedClassRefs(), this.getImpliedClassRefs()});
    }

    @Override
    public int classRefsSize() {
        return this.specifiedClassRefs.size() + this.impliedClassRefs.size();
    }

    protected Iterable<String> getClassRefNames() {
        return new TransformationIterable<ClassRef, String>(this.getClassRefs()){

            protected String transform(ClassRef classRef) {
                return classRef.getClassName();
            }
        };
    }

    @Override
    public ListIterator<ClassRef> specifiedClassRefs() {
        return this.getSpecifiedClassRefs().iterator();
    }

    protected ListIterable<ClassRef> getSpecifiedClassRefs() {
        return new LiveCloneListIterable(this.specifiedClassRefs);
    }

    @Override
    public int specifiedClassRefsSize() {
        return this.specifiedClassRefs.size();
    }

    @Override
    public ClassRef addSpecifiedClassRef(String className) {
        return this.addSpecifiedClassRef(this.specifiedClassRefs.size(), className);
    }

    @Override
    public ClassRef addSpecifiedClassRef(int index, String className) {
        XmlJavaClassRef xmlClassRef = this.buildXmlJavaClassRef(className);
        ClassRef classRef = this.addSpecifiedClassRef_(index, xmlClassRef);
        this.xmlPersistenceUnit.getClasses().add(index, (Object)xmlClassRef);
        return classRef;
    }

    protected XmlJavaClassRef buildXmlJavaClassRef(String className) {
        XmlJavaClassRef ref = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        ref.setJavaClass(className);
        return ref;
    }

    protected ClassRef buildClassRef(XmlJavaClassRef xmlClassRef) {
        return this.getContextNodeFactory().buildClassRef((PersistenceUnit)this, xmlClassRef);
    }

    @Override
    public void removeSpecifiedClassRef(ClassRef classRef) {
        this.removeSpecifiedClassRef(this.specifiedClassRefs.indexOf(classRef));
    }

    @Override
    public void removeSpecifiedClassRef(int index) {
        this.removeSpecifiedClassRef_(index);
        this.xmlPersistenceUnit.getClasses().remove(index);
    }

    protected void removeSpecifiedClassRef_(int index) {
        ((ClassRef)this.removeItemFromList(index, this.specifiedClassRefs, "specifiedClassRefs")).dispose();
    }

    protected void initializeSpecifiedClassRefs() {
        for (XmlJavaClassRef xmlJavaClassRef : this.getXmlClassRefs()) {
            this.specifiedClassRefs.add(this.buildClassRef(xmlJavaClassRef));
        }
    }

    protected void syncSpecifiedClassRefs() {
        ContextContainerTools.synchronizeWithResourceModel(this.specifiedClassRefContainerAdapter);
    }

    protected Iterable<XmlJavaClassRef> getXmlClassRefs() {
        return new LiveCloneIterable(this.xmlPersistenceUnit.getClasses());
    }

    protected void moveSpecifiedClassRef_(int index, ClassRef classRef) {
        this.moveItemInList(index, classRef, this.specifiedClassRefs, "specifiedClassRefs");
    }

    protected ClassRef addSpecifiedClassRef_(int index, XmlJavaClassRef xmlClassRef) {
        ClassRef classRef = this.buildClassRef(xmlClassRef);
        this.addItemToList(index, classRef, this.specifiedClassRefs, "specifiedClassRefs");
        return classRef;
    }

    protected void removeSpecifiedClassRef_(ClassRef classRef) {
        this.removeSpecifiedClassRef_(this.specifiedClassRefs.indexOf(classRef));
    }

    @Override
    public Iterator<ClassRef> impliedClassRefs() {
        return this.getImpliedClassRefs().iterator();
    }

    protected Iterable<ClassRef> getImpliedClassRefs() {
        return new LiveCloneIterable(this.impliedClassRefs);
    }

    @Override
    public int impliedClassRefsSize() {
        return this.impliedClassRefs.size();
    }

    protected ClassRef addImpliedClassRef(String className) {
        ClassRef classRef = this.buildClassRef(className);
        this.addItemToCollection(classRef, this.impliedClassRefs, "impliedClassRefs");
        return classRef;
    }

    protected ClassRef buildClassRef(String className) {
        return this.getContextNodeFactory().buildClassRef((PersistenceUnit)this, className);
    }

    protected void removeImpliedClassRef(ClassRef classRef) {
        this.impliedClassRefs.remove(classRef);
        classRef.dispose();
        this.fireItemRemoved("impliedClassRefs", classRef);
    }

    protected void updateImpliedClassRefs() {
        ContextContainerTools.update(this.impliedClassRefContainerAdapter);
    }

    protected Iterable<String> getImpliedClassNames() {
        return this.excludesUnlistedClasses() ? EmptyIterable.instance() : this.getImpliedClassNames_();
    }

    protected Iterable<String> getImpliedClassNames_() {
        return new FilteringIterable<String>(this.getJpaProject().getMappedJavaSourceClassNames()){

            protected boolean accept(String mappedClassName) {
                return !AbstractPersistenceUnit.this.specifiesPersistentType(mappedClassName);
            }
        };
    }

    @Override
    public boolean excludesUnlistedClasses() {
        return this.specifiedExcludeUnlistedClasses != null ? this.specifiedExcludeUnlistedClasses.booleanValue() : this.getDefaultExcludeUnlistedClasses();
    }

    @Override
    public Boolean getSpecifiedExcludeUnlistedClasses() {
        return this.specifiedExcludeUnlistedClasses;
    }

    @Override
    public void setSpecifiedExcludeUnlistedClasses(Boolean specifiedExcludeUnlistedClasses) {
        this.setSpecifiedExcludeUnlistedClasses_(specifiedExcludeUnlistedClasses);
        this.xmlPersistenceUnit.setExcludeUnlistedClasses(this.specifiedExcludeUnlistedClasses);
    }

    protected void setSpecifiedExcludeUnlistedClasses_(Boolean excludeUnlistedClasses) {
        Boolean old = this.specifiedExcludeUnlistedClasses;
        this.specifiedExcludeUnlistedClasses = excludeUnlistedClasses;
        this.firePropertyChanged("specifiedExcludeUnlistedClasses", old, excludeUnlistedClasses);
    }

    @Override
    public boolean getDefaultExcludeUnlistedClasses() {
        return false;
    }

    @Override
    public ListIterator<PersistenceUnit.Property> properties() {
        return this.getProperties().iterator();
    }

    protected ListIterable<PersistenceUnit.Property> getProperties() {
        return new LiveCloneListIterable(this.properties);
    }

    @Override
    public int propertiesSize() {
        return this.properties.size();
    }

    @Override
    public PersistenceUnit.Property getProperty(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException();
        }
        for (PersistenceUnit.Property property : this.getProperties()) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    @Override
    public Iterable<PersistenceUnit.Property> getPropertiesNamed(final String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException();
        }
        return new FilteringIterable<PersistenceUnit.Property>(this.getProperties()){

            protected boolean accept(PersistenceUnit.Property property) {
                return Tools.valuesAreEqual((Object)property.getName(), (Object)propertyName);
            }
        };
    }

    @Override
    public Iterator<PersistenceUnit.Property> propertiesWithNamePrefix(final String propertyNamePrefix) {
        if (propertyNamePrefix == null) {
            throw new NullPointerException();
        }
        return new FilteringIterator<PersistenceUnit.Property>(this.properties()){

            protected boolean accept(PersistenceUnit.Property property) {
                String pName = property.getName();
                return pName != null && pName.startsWith(propertyNamePrefix);
            }
        };
    }

    @Override
    public PersistenceUnit.Property addProperty() {
        return this.addProperty(this.properties.size());
    }

    @Override
    public PersistenceUnit.Property addProperty(int index) {
        XmlProperty xmlProperty = this.buildXmlProperty();
        PersistenceUnit.Property property = this.addProperty_(index, xmlProperty);
        XmlProperties xmlProperties = this.xmlPersistenceUnit.getProperties();
        if (xmlProperties == null) {
            xmlProperties = this.buildXmlProperties();
            this.xmlPersistenceUnit.setProperties(xmlProperties);
        }
        xmlProperties.getProperties().add(index, (Object)xmlProperty);
        if (property.getName() != null) {
            this.propertyAdded(property.getName(), property.getValue());
        }
        return property;
    }

    protected XmlProperty buildXmlProperty() {
        return PersistenceFactory.eINSTANCE.createXmlProperty();
    }

    protected PersistenceUnit.Property buildProperty(XmlProperty xmlProperty) {
        return this.getContextNodeFactory().buildProperty(this, xmlProperty);
    }

    protected XmlProperties buildXmlProperties() {
        return PersistenceFactory.eINSTANCE.createXmlProperties();
    }

    @Override
    public void setProperty(String propertyName, String value) {
        this.setProperty(propertyName, value, false);
    }

    @Override
    public void setProperty(String propertyName, String value, boolean duplicatePropertyNamesAllowed) {
        PersistenceUnit.Property prev = this.getProperty(propertyName);
        if (prev == null) {
            if (value != null) {
                this.addProperty(propertyName, value);
            }
        } else if (duplicatePropertyNamesAllowed) {
            if (value != null) {
                this.addProperty(propertyName, value);
            }
        } else if (value == null) {
            this.removeProperty(prev);
        } else {
            prev.setValue(value);
        }
    }

    protected void addProperty(String propertyName, String value) {
        PersistenceUnit.Property property = this.addProperty();
        property.setName(propertyName);
        property.setValue(value);
    }

    @Override
    public void removeProperty(PersistenceUnit.Property property) {
        this.removeProperty(this.properties.indexOf(property));
    }

    @Override
    public void removeProperty(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException();
        }
        ListIterator<PersistenceUnit.Property> stream = this.properties.listIterator();
        while (stream.hasNext()) {
            PersistenceUnit.Property property = stream.next();
            if (!propertyName.equals(property.getName())) continue;
            this.removeProperty(stream.previousIndex());
            return;
        }
        throw new IllegalArgumentException("invalid property name: " + propertyName);
    }

    @Override
    public void removeProperty(String propertyName, String value) {
        if (propertyName == null || value == null) {
            throw new NullPointerException();
        }
        ListIterator<PersistenceUnit.Property> stream = this.properties.listIterator();
        while (stream.hasNext()) {
            PersistenceUnit.Property property = stream.next();
            if (!propertyName.equals(property.getName()) || !value.equals(property.getValue())) continue;
            this.removeProperty(stream.previousIndex());
            return;
        }
        throw new IllegalArgumentException("invalid property name/value pair: " + propertyName + " = " + value);
    }

    protected void removeProperty(int index) {
        PersistenceUnit.Property removedProperty = this.properties.remove(index);
        this.xmlPersistenceUnit.getProperties().getProperties().remove(index);
        if (this.xmlPersistenceUnit.getProperties().getProperties().isEmpty()) {
            this.xmlPersistenceUnit.setProperties(null);
        }
        this.fireItemRemoved("properties", index, removedProperty);
        if (removedProperty.getName() != null) {
            this.propertyRemoved(removedProperty.getName());
        }
    }

    @Override
    public void propertyNameChanged(String oldPropertyName, String newPropertyName, String value) {
        if (oldPropertyName == null && value == null) {
            return;
        }
        if (oldPropertyName != null) {
            this.propertyRemoved(oldPropertyName);
        }
        if (newPropertyName != null) {
            this.propertyAdded(newPropertyName, value);
        }
    }

    @Override
    public void propertyValueChanged(String propertyName, String newValue) {
        this.connection.propertyValueChanged(propertyName, newValue);
        this.options.propertyValueChanged(propertyName, newValue);
    }

    protected void propertyAdded(String propertyName, String value) {
        this.propertyValueChanged(propertyName, value);
    }

    protected void propertyRemoved(String propertyName) {
        this.connection.propertyRemoved(propertyName);
        this.options.propertyRemoved(propertyName);
    }

    protected void initializeProperties() {
        for (XmlProperty xmlProperty : this.getXmlProperties()) {
            this.properties.add(this.buildProperty(xmlProperty));
        }
        this.connection = this.getContextNodeFactory().buildConnection(this);
        this.options = this.getContextNodeFactory().buildOptions(this);
    }

    protected void syncProperties() {
        ContextContainerTools.synchronizeWithResourceModel(this.propertyContainerAdapter);
    }

    protected Iterable<XmlProperty> getXmlProperties() {
        XmlProperties xmlProperties = this.xmlPersistenceUnit.getProperties();
        return xmlProperties == null ? EmptyIterable.instance() : new LiveCloneIterable(xmlProperties.getProperties());
    }

    protected void moveProperty_(int index, PersistenceUnit.Property property) {
        this.moveItemInList(index, this.properties.indexOf(property), this.properties, "properties");
    }

    protected PersistenceUnit.Property addProperty_(int index, XmlProperty xmlProperty) {
        PersistenceUnit.Property property = this.buildProperty(xmlProperty);
        this.addItemToList(index, property, this.properties, "properties");
        if (property.getName() != null) {
            this.propertyAdded(property.getName(), property.getValue());
        }
        return property;
    }

    protected void removeProperty_(PersistenceUnit.Property property) {
        this.removeItemFromList(property, this.properties, "properties");
        if (property.getName() != null) {
            this.propertyRemoved(property.getName());
        }
    }

    @Override
    public boolean isXmlMappingMetadataComplete() {
        return this.xmlMappingMetadataComplete;
    }

    protected void setXmlMappingMetadataComplete(boolean xmlMappingMetadataComplete) {
        boolean old = this.xmlMappingMetadataComplete;
        this.xmlMappingMetadataComplete = xmlMappingMetadataComplete;
        this.firePropertyChanged("xmlMappingMetadataComplete", old, xmlMappingMetadataComplete);
    }

    protected boolean buildXmlMappingMetadataComplete(MappingFilePersistenceUnitMetadata metadata) {
        return metadata == null ? false : metadata.isXmlMappingMetadataComplete();
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType access) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = access;
        this.firePropertyChanged("defaultAccess", (Object)old, (Object)access);
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    protected String buildDefaultCatalog(MappingFilePersistenceUnitDefaults defaults) {
        String catalog = defaults == null ? null : defaults.getCatalog();
        return catalog != null ? catalog : this.getJpaProject().getDefaultCatalog();
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    protected String buildDefaultSchema(MappingFilePersistenceUnitDefaults defaults) {
        String schema = defaults == null ? null : defaults.getSchema();
        return schema != null ? schema : this.getJpaProject().getDefaultSchema();
    }

    @Override
    public boolean getDefaultCascadePersist() {
        return this.defaultCascadePersist;
    }

    protected void setDefaultCascadePersist(boolean cascadePersist) {
        boolean old = this.defaultCascadePersist;
        this.defaultCascadePersist = cascadePersist;
        this.firePropertyChanged("defaultCascadePersist", old, cascadePersist);
    }

    protected boolean buildDefaultCascadePersist(MappingFilePersistenceUnitDefaults defaults) {
        return defaults == null ? false : defaults.isCascadePersist();
    }

    @Override
    public boolean getDefaultDelimitedIdentifiers() {
        return this.defaultDelimitedIdentifiers;
    }

    protected void setDefaultDelimitedIdentifiers(boolean delimitedIdentifiers) {
        boolean old = this.defaultDelimitedIdentifiers;
        this.defaultDelimitedIdentifiers = delimitedIdentifiers;
        this.firePropertyChanged("defaultDelimitedIdentifiers", old, delimitedIdentifiers);
    }

    protected boolean buildDefaultDelimitedIdentifiers(MappingFilePersistenceUnitDefaults defaults) {
        return !this.isJpa2_0Compatible() ? false : (defaults == null ? false : ((MappingFilePersistenceUnitDefaults2_0)defaults).isDelimitedIdentifiers());
    }

    protected void updatePersistenceUnitMetadata() {
        MappingFilePersistenceUnitMetadata metadata = this.getMetadata();
        this.setXmlMappingMetadataComplete(this.buildXmlMappingMetadataComplete(metadata));
        MappingFilePersistenceUnitDefaults defaults = metadata == null ? null : metadata.getPersistenceUnitDefaults();
        this.setDefaultAccess(defaults == null ? null : defaults.getAccess());
        this.setDefaultCatalog(this.buildDefaultCatalog(defaults));
        this.setDefaultSchema(this.buildDefaultSchema(defaults));
        this.setDefaultDelimitedIdentifiers(this.buildDefaultDelimitedIdentifiers(defaults));
    }

    protected MappingFilePersistenceUnitMetadata getMetadata() {
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            if (!mappingFileRef.persistenceUnitMetadataExists()) continue;
            return mappingFileRef.getPersistenceUnitMetadata();
        }
        return null;
    }

    @Override
    public PersistenceUnitProperties getConnection() {
        return this.connection;
    }

    @Override
    public PersistenceUnitProperties getOptions() {
        return this.options;
    }

    @Override
    public SharedCacheMode getSharedCacheMode() {
        return this.specifiedSharedCacheMode != null ? this.specifiedSharedCacheMode : this.defaultSharedCacheMode;
    }

    @Override
    public SharedCacheMode getSpecifiedSharedCacheMode() {
        return this.specifiedSharedCacheMode;
    }

    @Override
    public void setSpecifiedSharedCacheMode(SharedCacheMode specifiedSharedCacheMode) {
        this.setSpecifiedSharedCacheMode_(specifiedSharedCacheMode);
        this.xmlPersistenceUnit.setSharedCacheMode(SharedCacheMode.toXmlResourceModel(specifiedSharedCacheMode));
    }

    protected void setSpecifiedSharedCacheMode_(SharedCacheMode sharedCacheMode) {
        SharedCacheMode old = this.specifiedSharedCacheMode;
        this.specifiedSharedCacheMode = sharedCacheMode;
        this.firePropertyChanged("specifiedSharedCacheMode", (Object)old, (Object)sharedCacheMode);
    }

    @Override
    public SharedCacheMode getDefaultSharedCacheMode() {
        return this.defaultSharedCacheMode;
    }

    protected void setDefaultSharedCacheMode(SharedCacheMode defaultSharedCacheMode) {
        SharedCacheMode old = this.defaultSharedCacheMode;
        this.defaultSharedCacheMode = defaultSharedCacheMode;
        this.firePropertyChanged("defaultSharedCacheMode", (Object)old, (Object)defaultSharedCacheMode);
    }

    @Override
    public boolean calculateDefaultCacheable() {
        SharedCacheMode sharedCacheMode = this.getSharedCacheMode();
        if (sharedCacheMode == null) {
            return false;
        }
        switch (sharedCacheMode) {
            case NONE: 
            case ENABLE_SELECTIVE: 
            case UNSPECIFIED: {
                return false;
            }
            case ALL: 
            case DISABLE_SELECTIVE: {
                return true;
            }
        }
        throw new IllegalStateException("unknown mode: " + (Object)((Object)sharedCacheMode));
    }

    protected SharedCacheMode buildSpecifiedSharedCacheMode() {
        return SharedCacheMode.fromXmlResourceModel(this.xmlPersistenceUnit.getSharedCacheMode());
    }

    protected SharedCacheMode buildDefaultSharedCacheMode() {
        return SharedCacheMode.UNSPECIFIED;
    }

    @Override
    public ValidationMode getValidationMode() {
        return this.specifiedValidationMode != null ? this.specifiedValidationMode : this.defaultValidationMode;
    }

    @Override
    public ValidationMode getSpecifiedValidationMode() {
        return this.specifiedValidationMode;
    }

    @Override
    public void setSpecifiedValidationMode(ValidationMode specifiedValidationMode) {
        this.setSpecifiedValidationMode_(specifiedValidationMode);
        this.xmlPersistenceUnit.setValidationMode(ValidationMode.toXmlResourceModel(specifiedValidationMode));
    }

    protected void setSpecifiedValidationMode_(ValidationMode validationMode) {
        ValidationMode old = this.specifiedValidationMode;
        this.specifiedValidationMode = validationMode;
        this.firePropertyChanged("specifiedValidationMode", (Object)old, (Object)validationMode);
    }

    @Override
    public ValidationMode getDefaultValidationMode() {
        return this.defaultValidationMode;
    }

    protected void setDefaultValidationMode(ValidationMode defaultValidationMode) {
        ValidationMode old = this.defaultValidationMode;
        this.defaultValidationMode = defaultValidationMode;
        this.firePropertyChanged("defaultValidationMode", (Object)old, (Object)defaultValidationMode);
    }

    protected ValidationMode buildSpecifiedValidationMode() {
        return ValidationMode.fromXmlResourceModel(this.xmlPersistenceUnit.getValidationMode());
    }

    protected ValidationMode buildDefaultValidationMode() {
        return DEFAULT_VALIDATION_MODE;
    }

    @Override
    public Iterator<Generator> generators() {
        return this.getGenerators().iterator();
    }

    protected Iterable<Generator> getGenerators() {
        return new LiveCloneIterable(this.generators);
    }

    @Override
    public int generatorsSize() {
        return this.generators.size();
    }

    @Override
    public void addGenerator(Generator generator) {
        this.generators.add(generator);
    }

    @Override
    public Iterable<String> getUniqueGeneratorNames() {
        HashSet<String> names = new HashSet<String>(this.generators.size());
        this.addNonEmptyGeneratorNamesTo(names);
        return names;
    }

    protected void addNonEmptyGeneratorNamesTo(Set<String> names) {
        for (Generator generator : this.getGenerators()) {
            String generatorName = generator.getName();
            if (!StringTools.stringIsNotEmpty((String)generatorName)) continue;
            names.add(generatorName);
        }
    }

    protected void setGenerators(Iterable<Generator> generators) {
        this.synchronizeCollection(generators, this.generators, "generators");
    }

    protected Iterable<Generator> buildGenerators() {
        ArrayList<Generator> generatorList = new ArrayList<Generator>();
        this.addMappingFileGeneratorsTo(generatorList);
        HashMap<String, ArrayList<Generator>> mappingFileGenerators = this.mapGeneratorsByName(this.getMappingFileGenerators());
        HashMap<String, ArrayList<Generator>> javaGenerators = this.mapGeneratorsByName(this.getJavaGenerators());
        for (Map.Entry<String, ArrayList<Generator>> javaGeneratorEntry : javaGenerators.entrySet()) {
            if (mappingFileGenerators.get(javaGeneratorEntry.getKey()) != null) continue;
            generatorList.addAll((Collection<Generator>)javaGeneratorEntry.getValue());
        }
        return generatorList;
    }

    protected Iterable<Generator> getMappingFileGenerators() {
        ArrayList<Generator> generatorList = new ArrayList<Generator>();
        this.addMappingFileGeneratorsTo(generatorList);
        return generatorList;
    }

    protected void addMappingFileGeneratorsTo(ArrayList<Generator> generatorList) {
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            EntityMappings entityMappings;
            MappingFile mappingFile = mappingFileRef.getMappingFile();
            if (!(mappingFile instanceof OrmXml) || (entityMappings = ((OrmXml)mappingFile).getRoot()) == null) continue;
            CollectionTools.addAll(generatorList, entityMappings.getSequenceGenerators());
            CollectionTools.addAll(generatorList, entityMappings.getTableGenerators());
        }
        this.addGeneratorsTo(this.getMappingFilePersistentTypes(), generatorList);
    }

    protected Iterable<Generator> getJavaGenerators() {
        ArrayList<Generator> generatorList = new ArrayList<Generator>();
        this.addJavaGeneratorsTo(generatorList);
        return generatorList;
    }

    protected void addJavaGeneratorsTo(ArrayList<Generator> generatorList) {
        this.addGeneratorsTo(this.getAllJavaPersistentTypesUnique(), generatorList);
    }

    protected void addGeneratorsTo(Iterable<PersistentType> persistentTypes, ArrayList<Generator> generatorList) {
        for (PersistentType persistentType : persistentTypes) {
            TypeMapping typeMapping = persistentType.getMapping();
            if (typeMapping instanceof Entity) {
                this.addGeneratorsTo(((Entity)typeMapping).getGeneratorContainer(), generatorList);
            }
            for (ReadOnlyPersistentAttribute persistentAttribute : CollectionTools.iterable(persistentType.attributes())) {
                AttributeMapping attributeMapping = persistentAttribute.getMapping();
                if (!(attributeMapping instanceof IdMapping)) continue;
                this.addGeneratorsTo(((IdMapping)attributeMapping).getGeneratorContainer(), generatorList);
            }
        }
    }

    protected void addGeneratorsTo(GeneratorContainer generatorContainer, ArrayList<Generator> generatorList) {
        Generator generator = generatorContainer.getSequenceGenerator();
        if (generator != null) {
            generatorList.add(generator);
        }
        if ((generator = generatorContainer.getTableGenerator()) != null) {
            generatorList.add(generator);
        }
    }

    protected HashMap<String, ArrayList<Generator>> mapGeneratorsByName(Iterable<Generator> generatorList) {
        HashMap<String, ArrayList<Generator>> map = new HashMap<String, ArrayList<Generator>>();
        for (Generator generator : generatorList) {
            String generatorName = generator.getName();
            ArrayList<Generator> list = map.get(generatorName);
            if (list == null) {
                list = new ArrayList();
                map.put(generatorName, list);
            }
            list.add(generator);
        }
        return map;
    }

    @Override
    public Iterator<Query> queries() {
        return this.getQueries().iterator();
    }

    protected Iterable<Query> getQueries() {
        return new LiveCloneIterable(this.queries);
    }

    @Override
    public int queriesSize() {
        return this.queries.size();
    }

    @Override
    public void addQuery(Query query) {
        this.queries.add(query);
    }

    protected void setQueries(Iterable<Query> queries) {
        this.synchronizeCollection(queries, this.queries, "queries");
    }

    protected Iterable<Query> buildQueries() {
        ArrayList<Query> queryList = new ArrayList<Query>();
        this.addMappingFileQueriesTo(queryList);
        HashMap<String, ArrayList<Query>> mappingFileQueries = this.mapQueriesByName(this.getMappingFileQueries());
        HashMap<String, ArrayList<Query>> javaQueries = this.mapQueriesByName(this.getJavaQueries());
        for (Map.Entry<String, ArrayList<Query>> javaQueryEntry : javaQueries.entrySet()) {
            if (mappingFileQueries.get(javaQueryEntry.getKey()) != null) continue;
            queryList.addAll((Collection<Query>)javaQueryEntry.getValue());
        }
        return queryList;
    }

    protected Iterable<Query> getMappingFileQueries() {
        ArrayList<Query> queryList = new ArrayList<Query>();
        this.addMappingFileQueriesTo(queryList);
        return queryList;
    }

    protected void addMappingFileQueriesTo(ArrayList<Query> queryList) {
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            EntityMappings entityMappings;
            MappingFile mappingFile = mappingFileRef.getMappingFile();
            if (!(mappingFile instanceof OrmXml) || (entityMappings = ((OrmXml)mappingFile).getRoot()) == null) continue;
            this.addQueriesTo(entityMappings.getQueryContainer(), queryList);
        }
        this.addMappingFileQueriesTo(this.getMappingFilePersistentTypes(), queryList);
    }

    protected void addMappingFileQueriesTo(Iterable<PersistentType> persistentTypes, ArrayList<Query> queryList) {
        for (PersistentType persistentType : persistentTypes) {
            TypeMapping typeMapping = persistentType.getMapping();
            if (!(typeMapping instanceof Entity)) continue;
            this.addQueriesTo(((Entity)typeMapping).getQueryContainer(), queryList);
        }
    }

    protected Iterable<Query> getJavaQueries() {
        ArrayList<Query> queryList = new ArrayList<Query>();
        this.addJavaQueriesTo(queryList);
        return queryList;
    }

    protected void addJavaQueriesTo(ArrayList<Query> queryList) {
        this.addJavaQueriesTo(this.getAllJavaPersistentTypesUnique(), queryList);
    }

    protected void addJavaQueriesTo(Iterable<PersistentType> persistentTypes, ArrayList<Query> queryList) {
        for (PersistentType persistentType : persistentTypes) {
            TypeMapping typeMapping = persistentType.getMapping();
            if (!(typeMapping instanceof Entity)) continue;
            this.addQueriesTo(((Entity)typeMapping).getQueryContainer(), queryList);
        }
    }

    protected void addQueriesTo(QueryContainer queryContainer, ArrayList<Query> queryList) {
        CollectionTools.addAll(queryList, queryContainer.namedQueries());
        CollectionTools.addAll(queryList, queryContainer.namedNativeQueries());
    }

    protected HashMap<String, ArrayList<Query>> mapQueriesByName(Iterable<Query> queryList) {
        HashMap<String, ArrayList<Query>> map = new HashMap<String, ArrayList<Query>>();
        for (Query query : queryList) {
            String queryName = query.getName();
            ArrayList<Query> list = map.get(queryName);
            if (list == null) {
                list = new ArrayList();
                map.put(queryName, list);
            }
            list.add(query);
        }
        return map;
    }

    public Iterable<PersistentType> getPersistentTypes() {
        return new CompositeIterable(new Iterable[]{this.getMappingFilePersistentTypes(), this.getJavaPersistentTypes()});
    }

    protected Iterable<PersistentType> getMappingFilePersistentTypes() {
        return new CompositeIterable(this.getMappingFilePersistentTypeLists());
    }

    protected Iterable<Iterable<? extends PersistentType>> getMappingFilePersistentTypeLists() {
        return new TransformationIterable(this.getMappingFileRefs(), PersistentTypeContainer.TRANSFORMER);
    }

    protected Iterable<PersistentType> getMappingFileJavaPersistentTypes() {
        return new FilteringIterable(this.getMappingFileJavaPersistentTypes_(), NotNullFilter.instance());
    }

    protected Iterable<PersistentType> getMappingFileJavaPersistentTypes_() {
        return new TransformationIterable<PersistentType, PersistentType>(this.getMappingFilePersistentTypes()){

            protected PersistentType transform(PersistentType mappingFilePersistentType) {
                return mappingFilePersistentType instanceof OrmPersistentType ? this.transform((OrmPersistentType)mappingFilePersistentType) : null;
            }

            protected PersistentType transform(OrmPersistentType mappingFilePersistentType) {
                return mappingFilePersistentType.getMapping().isMetadataComplete() ? null : mappingFilePersistentType.getJavaPersistentType();
            }
        };
    }

    protected Iterable<PersistentType> getJavaPersistentTypes() {
        return new CompositeIterable(new Iterable[]{this.getClassRefPersistentTypes(), this.getJarFilePersistentTypes()});
    }

    protected Iterable<PersistentType> getClassRefPersistentTypes() {
        return new FilteringIterable(this.getClassRefPersistentTypes_(), NotNullFilter.instance());
    }

    protected Iterable<PersistentType> getClassRefPersistentTypes_() {
        return new TransformationIterable<ClassRef, PersistentType>(this.getClassRefs()){

            protected PersistentType transform(ClassRef classRef) {
                return classRef.getJavaPersistentType();
            }
        };
    }

    protected Iterable<PersistentType> getJarFilePersistentTypes() {
        return new CompositeIterable(this.getJarFilePersistentTypeLists());
    }

    protected Iterable<Iterable<? extends PersistentType>> getJarFilePersistentTypeLists() {
        return new TransformationIterable(this.getJarFileRefs(), PersistentTypeContainer.TRANSFORMER);
    }

    @Override
    public PersistentType getPersistentType(String typeName) {
        PersistentType persistentType;
        if (typeName == null) {
            return null;
        }
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            persistentType = mappingFileRef.getPersistentType(typeName);
            if (persistentType == null) continue;
            return persistentType;
        }
        for (ClassRef classRef : this.getClassRefs()) {
            if (!classRef.isFor(typeName)) continue;
            return classRef.getJavaPersistentType();
        }
        for (JarFileRef jarFileRef : this.getJarFileRefs()) {
            persistentType = jarFileRef.getPersistentType(typeName);
            if (persistentType == null) continue;
            return persistentType;
        }
        return null;
    }

    @Override
    public boolean specifiesPersistentType(String typeName) {
        for (ClassRef classRef : this.getSpecifiedClassRefs()) {
            if (!classRef.isFor(typeName)) continue;
            return true;
        }
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            if (mappingFileRef.getPersistentType(typeName) == null) continue;
            return true;
        }
        return false;
    }

    protected Iterable<PersistentType> getAllJavaPersistentTypesUnique() {
        HashMap<String, PersistentType> map = new HashMap<String, PersistentType>();
        this.addPersistentTypesTo(this.getJarFilePersistentTypes(), map);
        this.addPersistentTypesTo(this.getClassRefPersistentTypes(), map);
        this.addPersistentTypesTo(this.getMappingFileJavaPersistentTypes(), map);
        return map.values();
    }

    protected void addPersistentTypesTo(Iterable<? extends PersistentType> persistentTypes, HashMap<String, PersistentType> persistentTypeMap) {
        for (PersistentType persistentType : persistentTypes) {
            String ptName = persistentType.getName();
            if (ptName == null) continue;
            persistentTypeMap.put(ptName, persistentType);
        }
    }

    @Override
    public Entity getEntity(String typeName) {
        TypeMapping typeMapping = this.getTypeMapping(typeName);
        return typeMapping instanceof Entity ? (Entity)typeMapping : null;
    }

    @Override
    public Embeddable getEmbeddable(String typeName) {
        TypeMapping typeMapping = this.getTypeMapping(typeName);
        return typeMapping instanceof Embeddable ? (Embeddable)typeMapping : null;
    }

    protected TypeMapping getTypeMapping(String typeName) {
        PersistentType persistentType = this.getPersistentType(typeName);
        return persistentType == null ? null : persistentType.getMapping();
    }

    @Override
    public Iterable<Entity> getEntities() {
        return this.filterToEntities(this.getTypeMappings());
    }

    protected Iterable<Entity> filterToEntities(Iterable<TypeMapping> typeMappings) {
        return new SubIterableWrapper(this.filterToEntities_(typeMappings));
    }

    protected Iterable<TypeMapping> filterToEntities_(Iterable<TypeMapping> typeMappings) {
        return new FilteringIterable<TypeMapping>(typeMappings){

            protected boolean accept(TypeMapping typeMapping) {
                return typeMapping instanceof Entity;
            }
        };
    }

    protected Iterable<TypeMapping> getTypeMappings() {
        return new TransformationIterable<PersistentType, TypeMapping>(this.getPersistentTypes()){

            protected TypeMapping transform(PersistentType persistentType) {
                return persistentType.getMapping();
            }
        };
    }

    protected HashMap<String, ArrayList<Entity>> mapMappingFileEntitiesByName() {
        return this.mapTypeMappingsByName(this.getMappingFileEntities());
    }

    protected <M extends TypeMapping> HashMap<String, ArrayList<M>> mapTypeMappingsByName(Iterable<M> typeMappings) {
        HashMap<String, ArrayList<M>> map = new HashMap<String, ArrayList<M>>();
        for (TypeMapping typeMapping : typeMappings) {
            String typeMappingName = typeMapping.getName();
            ArrayList<Object> list = map.get(typeMappingName);
            if (list == null) {
                list = new ArrayList();
                map.put(typeMappingName, list);
            }
            list.add(typeMapping);
        }
        return map;
    }

    protected Iterable<Entity> getMappingFileEntities() {
        return this.filterToEntities(this.getMappingFileTypeMappings());
    }

    protected Iterable<TypeMapping> getMappingFileTypeMappings() {
        return new TransformationIterable<PersistentType, TypeMapping>(this.getMappingFilePersistentTypes()){

            protected TypeMapping transform(PersistentType persistentType) {
                return persistentType.getMapping();
            }
        };
    }

    @Override
    public Iterable<String> getOrmMappedClassNames() {
        return new TransformationIterable<PersistentType, String>(this.getMappingFilePersistentTypes()){

            protected String transform(PersistentType persistentType) {
                return persistentType.getName();
            }
        };
    }

    @Override
    public Map<String, Set<String>> mapEntityNameToClassNames() {
        HashMap<String, ArrayList<Entity>> mappingFileEntitiesByName = this.mapMappingFileEntitiesByName();
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(mappingFileEntitiesByName.size());
        for (Map.Entry<String, ArrayList<Entity>> entry : mappingFileEntitiesByName.entrySet()) {
            String entityName = entry.getKey();
            ArrayList<Entity> entities = entry.getValue();
            HashSet<String> entityClassNames = new HashSet<String>(entities.size());
            for (Entity entity : entities) {
                entityClassNames.add(entity.getPersistentType().getName());
            }
            map.put(entityName, entityClassNames);
        }
        return map;
    }

    @Override
    public Iterator<String> ormEntityNames() {
        return this.getMappingFileEntityNames().iterator();
    }

    protected Iterable<String> getMappingFileEntityNames() {
        return new TransformationIterable<Entity, String>(this.getMappingFileEntities()){

            protected String transform(Entity entity) {
                return entity.getName();
            }
        };
    }

    @Override
    public Iterable<Entity> getOrmEntities() {
        return this.getMappingFileEntities();
    }

    @Override
    public Iterable<Entity> getJavaEntities() {
        return this.filterToEntities(this.getJavaTypeMappings());
    }

    protected Iterable<TypeMapping> getJavaTypeMappings() {
        return new TransformationIterable<PersistentType, TypeMapping>(this.getJavaPersistentTypes()){

            protected TypeMapping transform(PersistentType persistentType) {
                return persistentType.getMapping();
            }
        };
    }

    protected Iterator<String> javaEntityClassNames() {
        return new TransformationIterator<Entity, String>(this.getJavaEntities()){

            protected String transform(Entity javaEntity) {
                return javaEntity.getPersistentType().getName();
            }
        };
    }

    @Override
    public Iterator<String> javaEntityNamesExclOverridden() {
        HashSet ormMappedClassNames = CollectionTools.set(this.getOrmMappedClassNames());
        ArrayList<String> javaEntityNamesExclOverridden = new ArrayList<String>();
        Iterator<String> javaEntityClassNames = this.javaEntityClassNames();
        while (javaEntityClassNames.hasNext()) {
            String javaEntityClassName = javaEntityClassNames.next();
            if (ormMappedClassNames.contains(javaEntityClassName)) continue;
            javaEntityNamesExclOverridden.add(this.getEntity(javaEntityClassName).getName());
        }
        return javaEntityNamesExclOverridden.iterator();
    }

    @Override
    public Iterator<String> javaEntityNames() {
        return new TransformationIterator<Entity, String>(this.getJavaEntities()){

            protected String transform(Entity javaEntity) {
                return javaEntity.getName();
            }
        };
    }

    @Override
    public XmlPersistenceUnit getXmlPersistenceUnit() {
        return this.xmlPersistenceUnit;
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (JarFileRef jarFileRef : this.getJarFileRefs()) {
            if (!jarFileRef.containsOffset(textOffset)) continue;
            return jarFileRef;
        }
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            if (!mappingFileRef.containsOffset(textOffset)) continue;
            return mappingFileRef;
        }
        for (ClassRef classRef : this.getClassRefs()) {
            if (!classRef.containsOffset(textOffset)) continue;
            return classRef;
        }
        return this;
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.xmlPersistenceUnit != null && this.xmlPersistenceUnit.containsOffset(textOffset);
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.name);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateMappingFiles(messages, reporter);
        this.validateClassRefs(messages, reporter);
        this.validateJarFileRefs(messages, reporter);
        this.validateProperties(messages, reporter);
        this.validateGenerators(messages, reporter);
        this.validateQueries(messages, reporter);
    }

    protected void validateMappingFiles(List<IMessage> messages, IReporter reporter) {
        this.checkForMultiplePersistenceUnitMetadata(messages);
        this.checkForDuplicateMappingFiles(messages);
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            mappingFileRef.validate(messages, reporter);
        }
    }

    protected void checkForMultiplePersistenceUnitMetadata(List<IMessage> messages) {
        boolean first = true;
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            if (!mappingFileRef.persistenceUnitMetadataExists()) continue;
            if (first) {
                first = false;
                continue;
            }
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "MAPPING_FILE_EXTRANEOUS_PERSISTENCE_UNIT_METADATA", new String[]{mappingFileRef.getFileName()}, mappingFileRef));
        }
    }

    protected void checkForDuplicateMappingFiles(List<IMessage> messages) {
        HashBag fileNames = CollectionTools.bag(this.mappingFileRefNames());
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            String fileName = mappingFileRef.getFileName();
            if (fileNames.count((Object)fileName) <= 1) continue;
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_DUPLICATE_MAPPING_FILE", new String[]{fileName}, mappingFileRef, mappingFileRef.getValidationTextRange()));
        }
    }

    protected void validateClassRefs(List<IMessage> messages, IReporter reporter) {
        this.checkForDuplicateClasses(messages);
        for (ClassRef classRef : this.getClassRefs()) {
            classRef.validate(messages, reporter);
        }
    }

    protected void checkForDuplicateClasses(List<IMessage> messages) {
        HashBag javaClassNames = CollectionTools.bag(this.getClassRefNames());
        for (ClassRef classRef : this.getClassRefs()) {
            String javaClassName = classRef.getClassName();
            if (javaClassName == null || javaClassNames.count((Object)javaClassName) <= 1) continue;
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_DUPLICATE_CLASS", new String[]{javaClassName}, classRef, classRef.getValidationTextRange()));
        }
    }

    protected void validateJarFileRefs(List<IMessage> messages, IReporter reporter) {
        this.checkForDuplicateJarFileRefs(messages);
        for (JarFileRef jarFileRef : this.getJarFileRefs()) {
            jarFileRef.validate(messages, reporter);
        }
    }

    protected void checkForDuplicateJarFileRefs(List<IMessage> messages) {
        HashBag jarFileNames = CollectionTools.bag(this.getJarFileNames());
        for (JarFileRef jarFileRef : this.getJarFileRefs()) {
            String jarFileName = jarFileRef.getFileName();
            if (jarFileName == null || jarFileNames.count((Object)jarFileName) <= 1) continue;
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_DUPLICATE_JAR_FILE", new String[]{jarFileName}, jarFileRef, jarFileRef.getValidationTextRange()));
        }
    }

    protected void validateProperties(List<IMessage> messages, IReporter reporter) {
    }

    protected void validateGenerators(List<IMessage> messages, IReporter reporter) {
        this.checkForDuplicateGenerators(messages);
        for (Generator generator : this.getGenerators()) {
            this.validate(generator, messages, reporter);
        }
    }

    protected void checkForDuplicateGenerators(List<IMessage> messages) {
        HashMap<String, ArrayList<Generator>> generatorsByName = this.mapGeneratorsByName(this.getGenerators());
        for (ArrayList<Generator> dups : generatorsByName.values()) {
            if (dups.size() <= 1) continue;
            for (Generator dup : dups) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "GENERATOR_DUPLICATE_NAME", new String[]{dup.getName()}, dup, this.extractNameTextRange(dup)));
            }
        }
    }

    protected TextRange extractNameTextRange(Generator generator) {
        return generator instanceof OrmGenerator ? ((OrmGenerator)generator).getNameTextRange() : ((JavaGenerator)generator).getNameTextRange(null);
    }

    protected void validate(Generator generator, List<IMessage> messages, IReporter reporter) {
        if (generator instanceof OrmGenerator) {
            ((OrmGenerator)generator).validate(messages, reporter);
        } else {
            ((JavaGenerator)generator).validate(messages, reporter, null);
        }
    }

    protected void validateQueries(List<IMessage> messages, IReporter reporter) {
        this.checkForDuplicateQueries(messages);
        for (Query query : this.getQueries()) {
            this.validate(query, messages, reporter);
        }
    }

    protected void checkForDuplicateQueries(List<IMessage> messages) {
        HashMap<String, ArrayList<Query>> queriesByName = this.mapQueriesByName(this.getQueries());
        for (ArrayList<Query> dups : queriesByName.values()) {
            if (dups.size() <= 1) continue;
            for (Query dup : dups) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "QUERY_DUPLICATE_NAME", new String[]{dup.getName()}, dup, this.extractNameTextRange(dup)));
            }
        }
    }

    protected TextRange extractNameTextRange(Query query) {
        return query instanceof OrmQuery ? ((OrmQuery)query).getNameTextRange() : ((JavaQuery)query).getNameTextRange(null);
    }

    protected void validate(Query query, List<IMessage> messages, IReporter reporter) {
        if (query instanceof OrmQuery) {
            ((OrmQuery)query).validate(messages, reporter);
        } else {
            ((JavaQuery)query).validate(messages, reporter, null);
        }
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.connectionProfileIsActive();
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlPersistenceUnit.getValidationTextRange();
        return textRange != null ? textRange : this.getPersistence().getValidationTextRange();
    }

    @Override
    public Iterable<DeleteEdit> createDeleteTypeEdits(final IType type) {
        return new CompositeIterable((Iterable)new TransformationIterable<ClassRef, Iterable<DeleteEdit>>(this.getSpecifiedClassRefs()){

            protected Iterable<DeleteEdit> transform(ClassRef classRef) {
                return classRef.createDeleteTypeEdits(type);
            }
        });
    }

    @Override
    public Iterable<DeleteEdit> createDeleteMappingFileEdits(final IFile file) {
        return new CompositeIterable((Iterable)new TransformationIterable<MappingFileRef, Iterable<DeleteEdit>>(this.getSpecifiedMappingFileRefs()){

            protected Iterable<DeleteEdit> transform(MappingFileRef mappingFileRef) {
                return mappingFileRef.createDeleteMappingFileEdits(file);
            }
        });
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return new CompositeIterable(new Iterable[]{this.createSpecifiedClassRefRenameTypeEdits(originalType, newName), this.createPersistenceUnitPropertiesRenameTypeEdits(originalType, newName)});
    }

    protected Iterable<ReplaceEdit> createSpecifiedClassRefRenameTypeEdits(final IType originalType, final String newName) {
        return new CompositeIterable((Iterable)new TransformationIterable<ClassRef, Iterable<ReplaceEdit>>(this.getSpecifiedClassRefs()){

            protected Iterable<ReplaceEdit> transform(ClassRef classRef) {
                return classRef.createRenameTypeEdits(originalType, newName);
            }
        });
    }

    protected Iterable<ReplaceEdit> createPersistenceUnitPropertiesRenameTypeEdits(IType originalType, String newName) {
        return this.options.createRenameTypeEdits(originalType, newName);
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return new CompositeIterable(new Iterable[]{this.createSpecifiedClassRefMoveTypeEdits(originalType, newPackage), this.createPersistenceUnitPropertiesMoveTypeEdits(originalType, newPackage)});
    }

    protected Iterable<ReplaceEdit> createSpecifiedClassRefMoveTypeEdits(final IType originalType, final IPackageFragment newPackage) {
        return new CompositeIterable((Iterable)new TransformationIterable<ClassRef, Iterable<ReplaceEdit>>(this.getSpecifiedClassRefs()){

            protected Iterable<ReplaceEdit> transform(ClassRef classRef) {
                return classRef.createMoveTypeEdits(originalType, newPackage);
            }
        });
    }

    protected Iterable<ReplaceEdit> createPersistenceUnitPropertiesMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.options.createMoveTypeEdits(originalType, newPackage);
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return new CompositeIterable(new Iterable[]{this.createSpecifiedClassRefRenamePackageEdits(originalPackage, newName), this.createPersistenceUnitPropertiesRenamePackageEdits(originalPackage, newName)});
    }

    protected Iterable<ReplaceEdit> createSpecifiedClassRefRenamePackageEdits(final IPackageFragment originalPackage, final String newName) {
        return new CompositeIterable((Iterable)new TransformationIterable<ClassRef, Iterable<ReplaceEdit>>(this.getSpecifiedClassRefs()){

            protected Iterable<ReplaceEdit> transform(ClassRef classRef) {
                return classRef.createRenamePackageEdits(originalPackage, newName);
            }
        });
    }

    protected Iterable<ReplaceEdit> createPersistenceUnitPropertiesRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.options.createRenamePackageEdits(originalPackage, newName);
    }

    @Override
    public Iterable<ReplaceEdit> createRenameFolderEdits(IFolder originalFolder, String newName) {
        return this.createMappingFileRefRenameFolderEdits(originalFolder, newName);
    }

    protected Iterable<ReplaceEdit> createMappingFileRefRenameFolderEdits(final IFolder originalFolder, final String newName) {
        return new CompositeIterable((Iterable)new TransformationIterable<MappingFileRef, Iterable<ReplaceEdit>>(this.getSpecifiedMappingFileRefs()){

            protected Iterable<ReplaceEdit> transform(MappingFileRef mappingFileRef) {
                return mappingFileRef.createRenameFolderEdits(originalFolder, newName);
            }
        });
    }

    @Override
    public Iterable<ReplaceEdit> createRenameMappingFileEdits(final IFile originalFile, final String newName) {
        return new CompositeIterable((Iterable)new TransformationIterable<MappingFileRef, Iterable<ReplaceEdit>>(this.getMappingFileRefs()){

            protected Iterable<ReplaceEdit> transform(MappingFileRef mappingFileRef) {
                return mappingFileRef.createRenameMappingFileEdits(originalFile, newName);
            }
        });
    }

    @Override
    public int findInsertLocationForMappingFileRef() {
        return this.xmlPersistenceUnit.getLocationToInsertMappingFileRef();
    }

    @Override
    public Iterable<ReplaceEdit> createMoveMappingFileEdits(final IFile originalFile, final IPath runtineDestination) {
        return new CompositeIterable((Iterable)new TransformationIterable<MappingFileRef, Iterable<ReplaceEdit>>(this.getMappingFileRefs()){

            protected Iterable<ReplaceEdit> transform(MappingFileRef mappingFileRef) {
                return mappingFileRef.createMoveMappingFileEdits(originalFile, runtineDestination);
            }
        });
    }

    @Override
    public Iterable<ReplaceEdit> createMoveFolderEdits(IFolder originalFolder, IPath runtimeDestination) {
        return this.createMappingFileRefMoveFolderReplaceEdits(originalFolder, runtimeDestination);
    }

    protected Iterable<ReplaceEdit> createMappingFileRefMoveFolderReplaceEdits(final IFolder originalFolder, final IPath runtimeDestination) {
        return new CompositeIterable((Iterable)new TransformationIterable<MappingFileRef, Iterable<ReplaceEdit>>(this.getSpecifiedMappingFileRefs()){

            protected Iterable<ReplaceEdit> transform(MappingFileRef mappingFileRef) {
                return mappingFileRef.createMoveFolderEdits(originalFolder, runtimeDestination);
            }
        });
    }

    @Override
    public void initializeMetamodel() {
        this.initializeMetamodelFiles_();
    }

    protected void initializeMetamodelFiles() {
        if (this.isJpa2_0Compatible()) {
            this.initializeMetamodelFiles_();
        }
    }

    protected void initializeMetamodelFiles_() {
        CollectionTools.addAll(this.metamodelFiles, this.getGeneratedMetamodelFiles());
    }

    protected Iterable<IFile> getGeneratedMetamodelFiles() {
        return new TransformationIterable<JavaResourcePersistentType2_0, IFile>(this.getGeneratedMetamodelTopLevelTypes()){

            protected IFile transform(JavaResourcePersistentType2_0 jrpt) {
                return jrpt.getFile();
            }
        };
    }

    protected Iterable<JavaResourcePersistentType2_0> getGeneratedMetamodelTopLevelTypes() {
        return ((JpaProject2_0)this.getJpaProject()).getGeneratedMetamodelTopLevelTypes();
    }

    @Override
    public void synchronizeMetamodel() {
        HashMap<String, PersistentType> allPersistentTypes = new HashMap<String, PersistentType>();
        this.addPersistentTypesTo(this.getJarFilePersistentTypes(), allPersistentTypes);
        this.addPersistentTypesTo(this.getClassRefPersistentTypes(), allPersistentTypes);
        this.addPersistentTypesTo(this.getMappingFilePersistentTypes(), allPersistentTypes);
        ArrayList<MetamodelSourceType> topLevelTypes = new ArrayList<MetamodelSourceType>(allPersistentTypes.size());
        HashMap<String, Collection<MetamodelSourceType>> memberTypeTree = new HashMap<String, Collection<MetamodelSourceType>>();
        block0: for (PersistentType type1_0 : allPersistentTypes.values()) {
            PersistentType2_0 type = (PersistentType2_0)type1_0;
            String declaringTypeName = type.getDeclaringTypeName();
            MetamodelSourceType memberType = type;
            while (true) {
                IType jdtDeclaringType;
                IType jdtType;
                JavaResourcePersistentType jrpt;
                if (declaringTypeName == null) {
                    topLevelTypes.add(memberType);
                    continue block0;
                }
                ArrayList<PersistentType2_0> memberTypes = (ArrayList<PersistentType2_0>)memberTypeTree.get(declaringTypeName);
                if (memberTypes == null) {
                    memberTypes = new ArrayList<PersistentType2_0>();
                    memberTypeTree.put(declaringTypeName, memberTypes);
                }
                memberTypes.add((PersistentType2_0)memberType);
                String memberTypeName = declaringTypeName;
                memberType = (PersistentType2_0)allPersistentTypes.get(memberTypeName);
                if (memberType != null || (memberType = (declaringTypeName = (jrpt = this.getJpaProject().getJavaResourcePersistentType(memberTypeName)) != null ? jrpt.getDeclaringTypeName() : ((jdtType = this.findJdtType(memberTypeName)) != null ? ((jdtDeclaringType = jdtType.getDeclaringType()) == null ? null : jdtDeclaringType.getFullyQualifiedName('.')) : null)) == null ? this.selectSourceType(topLevelTypes, memberTypeName) : this.selectSourceType((Iterable)memberTypeTree.get(declaringTypeName), memberTypeName)) != null) continue block0;
                memberType = this.buildNonPersistentMetamodelSourceType(memberTypeName);
            }
        }
        Collections.sort(topLevelTypes, MetamodelSourceType.COMPARATOR);
        HashSet<String> names = new HashSet<String>(topLevelTypes.size());
        Iterator stream = topLevelTypes.iterator();
        while (stream.hasNext()) {
            MetamodelSourceType topLevelType = (MetamodelSourceType)stream.next();
            if (names.add(topLevelType.getName().toLowerCase())) continue;
            stream.remove();
        }
        HashSet<IFile> deadMetamodelFiles = new HashSet<IFile>(this.metamodelFiles);
        this.metamodelFiles.clear();
        for (MetamodelSourceType topLevelType : topLevelTypes) {
            IFile metamodelFile = topLevelType.getMetamodelFile();
            deadMetamodelFiles.remove(metamodelFile);
            if (!this.fileIsGeneratedMetamodel(metamodelFile)) continue;
            this.metamodelFiles.add(metamodelFile);
        }
        for (IFile deadMetamodelFile : deadMetamodelFiles) {
            this.deleteMetamodelFile(deadMetamodelFile);
        }
        for (MetamodelSourceType topLevelType : topLevelTypes) {
            topLevelType.synchronizeMetamodel(memberTypeTree);
        }
    }

    protected MetamodelSourceType selectSourceType(Iterable<MetamodelSourceType> types, String typeName) {
        if (types != null) {
            for (MetamodelSourceType type : types) {
                if (!type.getName().equals(typeName)) continue;
                return type;
            }
        }
        return null;
    }

    protected MetamodelSourceType buildNonPersistentMetamodelSourceType(String nonPersistentTypeName) {
        return new NonPersistentMetamodelSourceType(nonPersistentTypeName, this.getJpaProject());
    }

    protected IType findJdtType(String typeName) {
        try {
            return this.getJpaProject().getJavaProject().findType(typeName);
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.log(ex);
            return null;
        }
    }

    protected void deleteMetamodelFile(IFile file) {
        try {
            this.deleteMetamodelFile_(file);
        }
        catch (CoreException ex) {
            JptJpaCorePlugin.log(ex);
        }
    }

    protected void deleteMetamodelFile_(IFile file) throws CoreException {
        if (this.fileIsGeneratedMetamodel(file)) {
            file.delete(true, null);
        }
    }

    protected boolean fileIsGeneratedMetamodel(IFile file) {
        return ((JpaProject2_0)this.getJpaProject()).getGeneratedMetamodelTopLevelType(file) != null;
    }

    @Override
    public void disposeMetamodel() {
        this.metamodelFiles.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ImpliedClassRefContainerAdapter
    implements ContextContainerTools.Adapter<ClassRef, String> {
        protected ImpliedClassRefContainerAdapter() {
        }

        @Override
        public Iterable<ClassRef> getContextElements() {
            return AbstractPersistenceUnit.this.getImpliedClassRefs();
        }

        @Override
        public Iterable<String> getResourceElements() {
            return AbstractPersistenceUnit.this.getImpliedClassNames();
        }

        @Override
        public String getResourceElement(ClassRef contextElement) {
            return contextElement.getClassName();
        }

        @Override
        public void moveContextElement(int index, ClassRef element) {
        }

        @Override
        public void addContextElement(int index, String resourceElement) {
            AbstractPersistenceUnit.this.addImpliedClassRef(resourceElement);
        }

        @Override
        public void removeContextElement(ClassRef element) {
            AbstractPersistenceUnit.this.removeImpliedClassRef(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JarFileRefContainerAdapter
    implements ContextContainerTools.Adapter<JarFileRef, XmlJarFileRef> {
        protected JarFileRefContainerAdapter() {
        }

        @Override
        public Iterable<JarFileRef> getContextElements() {
            return AbstractPersistenceUnit.this.getJarFileRefs();
        }

        @Override
        public Iterable<XmlJarFileRef> getResourceElements() {
            return AbstractPersistenceUnit.this.getXmlJarFileRefs();
        }

        @Override
        public XmlJarFileRef getResourceElement(JarFileRef contextElement) {
            return contextElement.getXmlJarFileRef();
        }

        @Override
        public void moveContextElement(int index, JarFileRef element) {
            AbstractPersistenceUnit.this.moveJarFileRef_(index, element);
        }

        @Override
        public void addContextElement(int index, XmlJarFileRef resourceElement) {
            AbstractPersistenceUnit.this.addJarFileRef_(index, resourceElement);
        }

        @Override
        public void removeContextElement(JarFileRef element) {
            AbstractPersistenceUnit.this.removeJarFileRef_(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NonPersistentMetamodelSourceType
    implements MetamodelSourceType {
        protected final String name;
        protected final JpaProject jpaProject;
        protected final MetamodelSourceType.Synchronizer metamodelSynchronizer;

        protected NonPersistentMetamodelSourceType(String name, JpaProject jpaProject) {
            this.name = name;
            this.jpaProject = jpaProject;
            this.metamodelSynchronizer = this.buildMetamodelSynchronizer();
        }

        protected MetamodelSourceType.Synchronizer buildMetamodelSynchronizer() {
            return this.getJpaFactory().buildMetamodelSynchronizer(this);
        }

        protected JpaFactory2_0 getJpaFactory() {
            return (JpaFactory2_0)this.getJpaProject().getJpaPlatform().getJpaFactory();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isManaged() {
            return false;
        }

        @Override
        public PersistentType getSuperPersistentType() {
            return null;
        }

        @Override
        public <T extends ReadOnlyPersistentAttribute> ListIterator<T> attributes() {
            return EmptyListIterator.instance();
        }

        @Override
        public IFile getMetamodelFile() {
            return this.metamodelSynchronizer.getFile();
        }

        @Override
        public JpaProject getJpaProject() {
            return this.jpaProject;
        }

        @Override
        public void synchronizeMetamodel(Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
            this.metamodelSynchronizer.synchronize(memberTypeTree);
        }

        @Override
        public void printBodySourceOn(BodySourceWriter pw, Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
            this.metamodelSynchronizer.printBodySourceOn(pw, memberTypeTree);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PropertyContainerAdapter
    implements ContextContainerTools.Adapter<PersistenceUnit.Property, XmlProperty> {
        protected PropertyContainerAdapter() {
        }

        @Override
        public Iterable<PersistenceUnit.Property> getContextElements() {
            return AbstractPersistenceUnit.this.getProperties();
        }

        @Override
        public Iterable<XmlProperty> getResourceElements() {
            return AbstractPersistenceUnit.this.getXmlProperties();
        }

        @Override
        public XmlProperty getResourceElement(PersistenceUnit.Property contextElement) {
            return contextElement.getXmlProperty();
        }

        @Override
        public void moveContextElement(int index, PersistenceUnit.Property element) {
            AbstractPersistenceUnit.this.moveProperty_(index, element);
        }

        @Override
        public void addContextElement(int index, XmlProperty resourceElement) {
            AbstractPersistenceUnit.this.addProperty_(index, resourceElement);
        }

        @Override
        public void removeContextElement(PersistenceUnit.Property element) {
            AbstractPersistenceUnit.this.removeProperty_(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedClassRefContainerAdapter
    implements ContextContainerTools.Adapter<ClassRef, XmlJavaClassRef> {
        protected SpecifiedClassRefContainerAdapter() {
        }

        @Override
        public Iterable<ClassRef> getContextElements() {
            return AbstractPersistenceUnit.this.getSpecifiedClassRefs();
        }

        @Override
        public Iterable<XmlJavaClassRef> getResourceElements() {
            return AbstractPersistenceUnit.this.getXmlClassRefs();
        }

        @Override
        public XmlJavaClassRef getResourceElement(ClassRef contextElement) {
            return contextElement.getXmlClassRef();
        }

        @Override
        public void moveContextElement(int index, ClassRef element) {
            AbstractPersistenceUnit.this.moveSpecifiedClassRef_(index, element);
        }

        @Override
        public void addContextElement(int index, XmlJavaClassRef resourceElement) {
            AbstractPersistenceUnit.this.addSpecifiedClassRef_(index, resourceElement);
        }

        @Override
        public void removeContextElement(ClassRef element) {
            AbstractPersistenceUnit.this.removeSpecifiedClassRef_(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedMappingFileRefContainerAdapter
    implements ContextContainerTools.Adapter<MappingFileRef, XmlMappingFileRef> {
        protected SpecifiedMappingFileRefContainerAdapter() {
        }

        @Override
        public Iterable<MappingFileRef> getContextElements() {
            return AbstractPersistenceUnit.this.getSpecifiedMappingFileRefs();
        }

        @Override
        public Iterable<XmlMappingFileRef> getResourceElements() {
            return AbstractPersistenceUnit.this.getXmlMappingFileRefs();
        }

        @Override
        public XmlMappingFileRef getResourceElement(MappingFileRef contextElement) {
            return contextElement.getXmlMappingFileRef();
        }

        @Override
        public void moveContextElement(int index, MappingFileRef element) {
            AbstractPersistenceUnit.this.moveSpecifiedMappingFileRef_(index, element);
        }

        @Override
        public void addContextElement(int index, XmlMappingFileRef resourceElement) {
            AbstractPersistenceUnit.this.addSpecifiedMappingFileRef_(index, resourceElement);
        }

        @Override
        public void removeContextElement(MappingFileRef element) {
            AbstractPersistenceUnit.this.removeSpecifiedMappingFileRef_(element);
        }
    }
}

