/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.ReadTransformer;
import org.eclipse.persistence.annotations.WriteTransformer;
import org.eclipse.persistence.annotations.WriteTransformers;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.transformers.ReadTransformerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.transformers.WriteTransformerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.TransformationMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationAccessor
extends BasicAccessor {
    private ReadTransformerMetadata m_readTransformer;
    private List<WriteTransformerMetadata> m_writeTransformers = new ArrayList<WriteTransformerMetadata>();

    public TransformationAccessor() {
        super("<transformation>");
    }

    public TransformationAccessor(MetadataAnnotation transformation, MetadataAnnotatedElement annotatedElement, ClassAccessor classAccessor) {
        super(transformation, (MetadataAccessibleObject)annotatedElement, classAccessor);
        if (transformation != null) {
            this.setFetch((String)transformation.getAttribute("fetch"));
            this.setOptional((Boolean)transformation.getAttribute("optional"));
        }
        if (this.isAnnotationPresent(ReadTransformer.class)) {
            this.m_readTransformer = new ReadTransformerMetadata(this.getAnnotation(ReadTransformer.class), this);
        }
        if (this.isAnnotationPresent(WriteTransformers.class)) {
            for (Object transformer : (Object[])this.getAnnotation(WriteTransformers.class).getAttributeArray("value")) {
                this.m_writeTransformers.add(new WriteTransformerMetadata((MetadataAnnotation)transformer, this));
            }
        }
        if (this.isAnnotationPresent(WriteTransformer.class)) {
            this.m_writeTransformers.add(new WriteTransformerMetadata(this.getAnnotation(WriteTransformer.class), this));
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof TransformationAccessor) {
            TransformationAccessor transformationAccessor = (TransformationAccessor)objectToCompare;
            if (!this.valuesMatch(this.m_readTransformer, transformationAccessor.getReadTransformer())) {
                return false;
            }
            return this.valuesMatch(this.m_writeTransformers, transformationAccessor.getWriteTransformers());
        }
        return false;
    }

    public ReadTransformerMetadata getReadTransformer() {
        return this.m_readTransformer;
    }

    public List<WriteTransformerMetadata> getWriteTransformers() {
        return this.m_writeTransformers;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_readTransformer, accessibleObject);
        this.initXMLObjects(this.m_writeTransformers, accessibleObject);
    }

    @Override
    public void process() {
        TransformationMapping mapping = new TransformationMapping();
        this.setMapping((DatabaseMapping)mapping);
        mapping.setAttributeName(this.getAttributeName());
        mapping.setIsOptional(this.isOptional());
        mapping.setIsLazy(this.usesIndirection());
        if (this.getMutable() != null) {
            mapping.setIsMutable(this.getMutable().booleanValue());
        }
        this.setAccessorMethods((DatabaseMapping)mapping);
        if (this.m_readTransformer != null) {
            this.m_readTransformer.process(mapping, this.getAnnotatedElementName());
        }
        if (this.m_writeTransformers.isEmpty()) {
            mapping.setIsReadOnly(true);
        } else {
            if (this.m_writeTransformers.size() == 1 && !this.m_writeTransformers.get(0).hasFieldName()) {
                this.m_writeTransformers.get(0).setFieldName(this.getAttributeName());
            }
            for (WriteTransformerMetadata writeTransformer : this.m_writeTransformers) {
                writeTransformer.process(mapping, this.getAnnotatedElementName());
            }
        }
    }

    public void setReadTransformer(ReadTransformerMetadata readTransformer) {
        this.m_readTransformer = readTransformer;
    }

    public void setWriteTransformers(List<WriteTransformerMetadata> writeTransformers) {
        this.m_writeTransformers = writeTransformers;
    }
}

