/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import org.eclipse.jpt.common.utility.internal.model.value.AbstractListValueModel;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListValueModelWrapper<E>
extends AbstractListValueModel {
    protected final ListValueModel<? extends E> listHolder;
    protected final ListChangeListener listChangeListener;

    protected ListValueModelWrapper(ListValueModel<? extends E> listHolder) {
        if (listHolder == null) {
            throw new NullPointerException();
        }
        this.listHolder = listHolder;
        this.listChangeListener = this.buildListChangeListener();
    }

    protected ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListAddEvent event) {
                ListValueModelWrapper.this.itemsAdded(event);
            }

            public void itemsRemoved(ListRemoveEvent event) {
                ListValueModelWrapper.this.itemsRemoved(event);
            }

            public void itemsReplaced(ListReplaceEvent event) {
                ListValueModelWrapper.this.itemsReplaced(event);
            }

            public void itemsMoved(ListMoveEvent event) {
                ListValueModelWrapper.this.itemsMoved(event);
            }

            public void listCleared(ListClearEvent event) {
                ListValueModelWrapper.this.listCleared(event);
            }

            public void listChanged(ListChangeEvent event) {
                ListValueModelWrapper.this.listChanged(event);
            }

            public String toString() {
                return "list change listener";
            }
        };
    }

    @Override
    protected void engageModel() {
        this.listHolder.addListChangeListener("list values", this.listChangeListener);
    }

    @Override
    protected void disengageModel() {
        this.listHolder.removeListChangeListener("list values", this.listChangeListener);
    }

    protected Iterable<E> getItems(ListAddEvent event) {
        return event.getItems();
    }

    protected Iterable<E> getItems(ListRemoveEvent event) {
        return event.getItems();
    }

    protected Iterable<E> getNewItems(ListReplaceEvent event) {
        return event.getNewItems();
    }

    protected Iterable<E> getOldItems(ListReplaceEvent event) {
        return event.getOldItems();
    }

    protected abstract void itemsAdded(ListAddEvent var1);

    protected abstract void itemsRemoved(ListRemoveEvent var1);

    protected abstract void itemsReplaced(ListReplaceEvent var1);

    protected abstract void itemsMoved(ListMoveEvent var1);

    protected abstract void listCleared(ListClearEvent var1);

    protected abstract void listChanged(ListChangeEvent var1);
}

