/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import java.lang.reflect.Modifier;

public class JPTTools {
    public static boolean typeIsPersistable(TypeAdapter typeAdapter) {
        if (typeAdapter.isInterface()) {
            return false;
        }
        if (typeAdapter.isAnnotation()) {
            return false;
        }
        if (typeAdapter.isEnum()) {
            return false;
        }
        if (typeAdapter.isLocal()) {
            return false;
        }
        if (typeAdapter.isAnonymous()) {
            return false;
        }
        if (typeAdapter.isPrimitive()) {
            return false;
        }
        return !typeAdapter.isArray();
    }

    public static boolean fieldIsPersistable(FieldAdapter fieldAdapter) {
        int modifiers = fieldAdapter.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            return false;
        }
        return !Modifier.isTransient(modifiers);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean methodIsPersistablePropertyGetter(MethodAdapter methodAdapter) {
        if (JPTTools.methodHasInvalidModifiers(methodAdapter)) {
            return false;
        }
        if (methodAdapter.isConstructor()) {
            return false;
        }
        String returnTypeName = methodAdapter.getReturnTypeErasureName();
        if (returnTypeName == null) {
            return false;
        }
        if (returnTypeName.equals("void")) {
            return false;
        }
        if (JPTTools.methodHasParameters(methodAdapter)) {
            return false;
        }
        String name = methodAdapter.getName();
        int beginIndex = 0;
        boolean booleanGetter = false;
        if (name.startsWith("is")) {
            if (!returnTypeName.equals("boolean")) return false;
            beginIndex = 2;
        } else {
            if (!name.startsWith("get")) return false;
            beginIndex = 3;
            if (returnTypeName.equals("boolean")) {
                booleanGetter = true;
            }
        }
        String capitalizedAttributeName = name.substring(beginIndex);
        if (!booleanGetter || !JPTTools.methodHasValidSiblingIsMethod(methodAdapter, capitalizedAttributeName)) return JPTTools.methodHasValidSiblingSetMethod(methodAdapter, capitalizedAttributeName, returnTypeName);
        return false;
    }

    private static boolean methodHasInvalidModifiers(SimpleMethodAdapter methodAdapter) {
        int modifiers = methodAdapter.getModifiers();
        return Modifier.isStatic(modifiers);
    }

    private static boolean methodHasParameters(MethodAdapter methodAdapter) {
        return methodAdapter.getParametersLength() != 0;
    }

    private static boolean methodHasValidSiblingIsMethod(MethodAdapter methodAdapter, String capitalizedAttributeName) {
        SimpleMethodAdapter isMethodAdapter = methodAdapter.getSibling("is" + capitalizedAttributeName);
        return JPTTools.methodIsValidSibling(isMethodAdapter, "boolean");
    }

    private static boolean methodHasValidSiblingSetMethod(MethodAdapter methodAdapter, String capitalizedAttributeName, String parameterTypeErasureName) {
        SimpleMethodAdapter setMethodAdapter = methodAdapter.getSibling("set" + capitalizedAttributeName, parameterTypeErasureName);
        return JPTTools.methodIsValidSibling(setMethodAdapter, "void");
    }

    private static boolean methodIsValidSibling(SimpleMethodAdapter methodAdapter, String returnTypeName) {
        if (methodAdapter == null) {
            return false;
        }
        if (JPTTools.methodHasInvalidModifiers(methodAdapter)) {
            return false;
        }
        if (methodAdapter.isConstructor()) {
            return false;
        }
        String rtName = methodAdapter.getReturnTypeErasureName();
        if (rtName == null) {
            return false;
        }
        return rtName.equals(returnTypeName);
    }

    private JPTTools() {
        throw new UnsupportedOperationException();
    }

    public static interface FieldAdapter {
        public int getModifiers();
    }

    public static interface MethodAdapter
    extends SimpleMethodAdapter {
        public String getName();

        public int getParametersLength();

        public SimpleMethodAdapter getSibling(String var1);

        public SimpleMethodAdapter getSibling(String var1, String var2);
    }

    public static interface SimpleMethodAdapter {
        public int getModifiers();

        public String getReturnTypeErasureName();

        public boolean isConstructor();
    }

    public static interface TypeAdapter {
        public int getModifiers();

        public boolean isAnnotation();

        public boolean isAnonymous();

        public boolean isArray();

        public boolean isEnum();

        public boolean isInterface();

        public boolean isLocal();

        public boolean isMember();

        public boolean isPrimitive();
    }
}

