/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionDeclarationAnnotationElementAdapter<E extends Expression>
implements DeclarationAnnotationElementAdapter<E> {
    private final DeclarationAnnotationAdapter annotationAdapter;
    private final String elementName;

    public ExpressionDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter) {
        this(annotationAdapter, "value");
    }

    public ExpressionDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        this.annotationAdapter = annotationAdapter;
        this.elementName = elementName;
    }

    @Override
    public E getValue(ModifiedDeclaration declaration) {
        return this.getExpression(declaration);
    }

    @Override
    public void setValue(E value, ModifiedDeclaration declaration) {
        this.setValue((Expression)value, this.annotationAdapter.getAnnotation(declaration), declaration);
    }

    public E getExpression(ModifiedDeclaration declaration) {
        return this.expression(this.annotationAdapter.getAnnotation(declaration));
    }

    @Override
    public ASTNode getAstNode(ModifiedDeclaration declaration) {
        E exp = this.getExpression(declaration);
        return exp != null ? exp : this.annotationAdapter.getAstNode(declaration);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.elementName);
    }

    protected E expression(Annotation annotation) {
        if (annotation == null) {
            return this.expressionNoAnnotation();
        }
        if (annotation.isMarkerAnnotation()) {
            return this.expressionMarkerAnnotation((MarkerAnnotation)annotation);
        }
        if (annotation.isSingleMemberAnnotation()) {
            return this.expressionSingleMemberAnnotation((SingleMemberAnnotation)annotation);
        }
        if (annotation.isNormalAnnotation()) {
            return this.expressionNormalAnnotation((NormalAnnotation)annotation);
        }
        throw new IllegalArgumentException("unknown annotation type: " + annotation);
    }

    protected E expressionNoAnnotation() {
        return null;
    }

    protected E expressionMarkerAnnotation(MarkerAnnotation annotation) {
        return null;
    }

    protected E expressionSingleMemberAnnotation(SingleMemberAnnotation annotation) {
        return this.downcast(this.elementName.equals("value") ? annotation.getValue() : null);
    }

    private E downcast(Expression e) {
        return (E)e;
    }

    protected E expressionNormalAnnotation(NormalAnnotation annotation) {
        MemberValuePair pair = this.memberValuePair(annotation);
        return this.downcast(pair == null ? null : pair.getValue());
    }

    protected void setValue(Expression value, Annotation annotation, ModifiedDeclaration declaration) {
        if (value == null) {
            this.removeElement(annotation, declaration);
        } else if (annotation == null) {
            this.setValueNoAnnotation(value, declaration);
        } else if (annotation.isMarkerAnnotation()) {
            this.setValueMarkerAnnotation(value, (MarkerAnnotation)annotation, declaration);
        } else if (annotation.isSingleMemberAnnotation()) {
            this.setValueSingleMemberAnnotation(value, (SingleMemberAnnotation)annotation, declaration);
        } else if (annotation.isNormalAnnotation()) {
            this.setValueNormalAnnotation(value, (NormalAnnotation)annotation, declaration);
        } else {
            throw new IllegalArgumentException("unknown annotation type: " + annotation);
        }
    }

    protected void setValueNoAnnotation(Expression value, ModifiedDeclaration declaration) {
        if (this.elementName.equals("value")) {
            this.annotationAdapter.newSingleMemberAnnotation(declaration).setValue(value);
        } else {
            this.addValue(value, this.annotationAdapter.newNormalAnnotation(declaration));
        }
    }

    protected void addValue(Expression value, NormalAnnotation annotation) {
        this.addValue(value, annotation, this.elementName);
    }

    protected void addValue(Expression value, NormalAnnotation annotation, String annotationElementName) {
        AST ast = annotation.getAST();
        MemberValuePair pair = ast.newMemberValuePair();
        pair.setName(ast.newSimpleName(annotationElementName));
        pair.setValue(value);
        List<MemberValuePair> values = this.values(annotation);
        values.add(pair);
    }

    protected void setValueMarkerAnnotation(Expression value, MarkerAnnotation annotation, ModifiedDeclaration declaration) {
        this.setValueNoAnnotation(value, declaration);
    }

    protected void setValueSingleMemberAnnotation(Expression value, SingleMemberAnnotation annotation, ModifiedDeclaration declaration) {
        if (this.elementName.equals("value")) {
            annotation.setValue(value);
        } else {
            Expression vv = annotation.getValue();
            vv = (Expression)ASTNode.copySubtree((AST)vv.getAST(), (ASTNode)vv);
            NormalAnnotation normalAnnotation = this.annotationAdapter.newNormalAnnotation(declaration);
            this.addValue(vv, normalAnnotation, "value");
            this.addValue(value, normalAnnotation);
        }
    }

    protected void setValueNormalAnnotation(Expression value, NormalAnnotation annotation, ModifiedDeclaration declaration) {
        MemberValuePair pair = this.memberValuePair(annotation);
        if (pair == null) {
            this.addValue(value, annotation);
        } else {
            pair.setValue(value);
        }
    }

    protected void removeElement(Annotation annotation, ModifiedDeclaration declaration) {
        if (annotation == null) {
            this.removeElementNoAnnotation(declaration);
        } else if (annotation.isMarkerAnnotation()) {
            this.removeElementMarkerAnnotation((MarkerAnnotation)annotation, declaration);
        } else if (annotation.isSingleMemberAnnotation()) {
            this.removeElementSingleMemberAnnotation((SingleMemberAnnotation)annotation, declaration);
        } else if (annotation.isNormalAnnotation()) {
            this.removeElementNormalAnnotation((NormalAnnotation)annotation, declaration);
        } else {
            throw new IllegalArgumentException("unknown annotation type: " + annotation);
        }
    }

    protected void removeElementNoAnnotation(ModifiedDeclaration declaration) {
    }

    protected void removeElementMarkerAnnotation(MarkerAnnotation annotation, ModifiedDeclaration declaration) {
    }

    protected void removeElementSingleMemberAnnotation(SingleMemberAnnotation annotation, ModifiedDeclaration declaration) {
        if (this.elementName.equals("value")) {
            this.annotationAdapter.newMarkerAnnotation(declaration);
        }
    }

    protected void removeElementNormalAnnotation(NormalAnnotation annotation, ModifiedDeclaration declaration) {
        List<MemberValuePair> values = this.values(annotation);
        if (values.size() == 1 && values.get(0).getName().getFullyQualifiedName().equals(this.elementName)) {
            this.annotationAdapter.newMarkerAnnotation(declaration);
        } else {
            MemberValuePair pair;
            this.removeElement(annotation);
            if (values.size() == 1 && (pair = values.get(0)).getName().getFullyQualifiedName().equals("value")) {
                Expression vv = pair.getValue();
                vv = (Expression)ASTNode.copySubtree((AST)vv.getAST(), (ASTNode)vv);
                this.annotationAdapter.newSingleMemberAnnotation(declaration).setValue(vv);
            }
        }
    }

    protected void removeElement(NormalAnnotation annotation) {
        Iterator<MemberValuePair> stream = this.values(annotation).iterator();
        while (stream.hasNext()) {
            MemberValuePair pair = stream.next();
            if (!pair.getName().getFullyQualifiedName().equals(this.elementName)) continue;
            stream.remove();
        }
    }

    protected MemberValuePair memberValuePair(NormalAnnotation annotation) {
        for (MemberValuePair pair : this.values(annotation)) {
            if (!pair.getName().getFullyQualifiedName().equals(this.elementName)) continue;
            return pair;
        }
        return null;
    }

    protected List<MemberValuePair> values(NormalAnnotation na) {
        return na.values();
    }
}

