/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public final class DefaultAnnotationEditFormatter
implements AnnotationEditFormatter {
    private static final DefaultAnnotationEditFormatter INSTANCE = new DefaultAnnotationEditFormatter();

    public static DefaultAnnotationEditFormatter instance() {
        return INSTANCE;
    }

    private DefaultAnnotationEditFormatter() {
    }

    /*
     * Unable to fully structure code
     */
    public void format(IDocument doc, TextEdit editTree) throws MalformedTreeException, BadLocationException {
        edits = editTree.getChildren();
        len = edits.length;
        if (len == 0) {
            return;
        }
        extraEdits = new MultiTextEdit();
        i = 0;
        while (i < len) {
            block6: {
                edit1 = edits[i];
                if (!(edit1 instanceof InsertEdit)) break block6;
                insert1 = (InsertEdit)edit1;
                j = i + 1;
                if (j >= len || !((edit2 = edits[j]) instanceof InsertEdit)) ** GOTO lbl-1000
                insert2 = (InsertEdit)edit2;
                text1 = insert1.getText();
                text2 = insert2.getText();
                offset1 = insert1.getOffset();
                offset2 = insert2.getOffset();
                if (this.stringIsAnnotation(text1) && text2.equals(" ")) {
                    extraEdits.addChild((TextEdit)new ReplaceEdit(offset2, 1, this.buildCR(doc, offset2)));
                    ++i;
                } else {
                    comma1Length = this.commaLength(text1);
                    if (comma1Length != 0 && this.stringIsAnnotation(text2)) {
                        extraEdits.addChild((TextEdit)new ReplaceEdit(offset1 + comma1Length, text1.length() - comma1Length, this.buildCR(doc, offset1)));
                        ++i;
                    } else lbl-1000:
                    // 2 sources

                    {
                        this.formatArrayInitializer(doc, insert1, extraEdits);
                    }
                }
            }
            ++i;
        }
        extraEdits.apply(doc, 0);
    }

    /*
     * Unable to fully structure code
     */
    private void formatArrayInitializer(IDocument doc, InsertEdit insertEdit, MultiTextEdit extraEdits) throws BadLocationException {
        s = insertEdit.getText();
        if (!this.stringIsAnnotation(s)) {
            return;
        }
        len = s.length();
        pos = 1;
        while (pos < len) {
            c = s.charAt(pos);
            ++pos;
            if (c == '(') break;
        }
        if (pos != len) ** GOTO lbl18
        return;
lbl-1000:
        // 1 sources

        {
            c = s.charAt(pos);
            ++pos;
            if (c == '{') break;
            if (c == ' ') continue;
            return;
lbl18:
            // 2 sources

            ** while (pos < len)
        }
lbl19:
        // 2 sources

        if (pos == len) {
            return;
        }
        offset = insertEdit.getOffset();
        indent = null;
        parenDepth = 0;
        while (pos < len) {
            switch (s.charAt(pos)) {
                case '(': {
                    ++parenDepth;
                    break;
                }
                case ')': {
                    --parenDepth;
                    break;
                }
                case '@': {
                    if (parenDepth != 0) break;
                    if (indent == null) {
                        indent = this.buildCR(doc, offset, "\t");
                    }
                    extraEdits.addChild((TextEdit)new InsertEdit(offset + pos, indent));
                    break;
                }
                case '}': {
                    if (parenDepth != 0) break;
                    extraEdits.addChild((TextEdit)new InsertEdit(offset + pos, this.buildCR(doc, offset)));
                }
            }
            ++pos;
        }
    }

    private String buildCR(IDocument doc, int offset) throws BadLocationException {
        return this.buildCR(doc, offset, "");
    }

    private String buildCR(IDocument doc, int offset, String suffix) throws BadLocationException {
        int line = doc.getLineOfOffset(offset);
        StringBuilder sb = new StringBuilder();
        sb.append(doc.getLineDelimiter(line));
        int o = doc.getLineOffset(line);
        char c = doc.getChar(o++);
        while (c == ' ' || c == '\t') {
            sb.append(c);
            c = doc.getChar(o++);
        }
        sb.append(suffix);
        return sb.toString();
    }

    private boolean stringIsAnnotation(String string) {
        return string.length() > 1 && string.charAt(0) == '@';
    }

    private int commaLength(String string) {
        boolean comma = false;
        int len = string.length();
        int result = 0;
        int i = 0;
        while (i < len) {
            switch (string.charAt(i)) {
                case ' ': {
                    if (comma) break;
                    ++result;
                    break;
                }
                case ',': {
                    if (comma) {
                        return 0;
                    }
                    comma = true;
                    ++result;
                    break;
                }
                default: {
                    return 0;
                }
            }
            ++i;
        }
        return result;
    }
}

