/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.libval;

import java.util.ArrayList;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jpt.common.core.internal.libval.LibraryValidatorConfig;
import org.eclipse.jpt.common.core.internal.utility.XPointTools;
import org.eclipse.jpt.common.core.libprov.JptLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.common.core.libval.LibraryValidator;
import org.eclipse.jpt.common.utility.internal.KeyedSet;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryValidatorManager {
    public static final String EXTENSION_POINT_ID = "libraryValidators";
    public static final String QUALIFIED_EXTENSION_POINT_ID = "org.eclipse.jpt.common.core.libraryValidators";
    public static final String LIBRARY_VALIDATOR_ELEMENT = "libraryValidator";
    public static final String ID_ATTRIBUTE = "id";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String ENABLEMENT_ELEMENT = "enablement";
    private static LibraryValidatorManager INSTANCE = new LibraryValidatorManager();
    private KeyedSet<String, LibraryValidatorConfig> libraryValidatorConfigs = new KeyedSet();

    public static LibraryValidatorManager instance() {
        return INSTANCE;
    }

    private LibraryValidatorManager() {
        this.readExtensions();
    }

    public Iterable<LibraryValidator> getLibraryValidators(final JptLibraryProviderInstallOperationConfig config) {
        return new FilteringIterable<LibraryValidator>((Iterable)new TransformationIterable<LibraryValidatorConfig, LibraryValidator>((Iterable)new FilteringIterable<LibraryValidatorConfig>((Iterable)this.libraryValidatorConfigs.getItemSet()){

            protected boolean accept(LibraryValidatorConfig o) {
                return o.isEnabledFor(config);
            }
        }){

            protected LibraryValidator transform(LibraryValidatorConfig o) {
                return o.getLibraryValidator();
            }
        }){

            protected boolean accept(LibraryValidator o) {
                return o != null;
            }
        };
    }

    private void readExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint xpoint = registry.getExtensionPoint(QUALIFIED_EXTENSION_POINT_ID);
        if (xpoint == null) {
            throw new IllegalStateException();
        }
        ArrayList<IConfigurationElement> configs = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = xpoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                configs.add(element);
                ++n4;
            }
            ++n2;
        }
        for (IConfigurationElement element : configs) {
            if (!element.getName().equals(LIBRARY_VALIDATOR_ELEMENT)) continue;
            this.readExtension(element);
        }
    }

    private void readExtension(IConfigurationElement element) {
        try {
            LibraryValidatorConfig lvConfig = new LibraryValidatorConfig();
            lvConfig.setPluginId(element.getContributor().getName());
            lvConfig.setId(XPointTools.findRequiredAttribute(element, ID_ATTRIBUTE));
            if (this.libraryValidatorConfigs.containsKey((Object)lvConfig.getId())) {
                XPointTools.logDuplicateExtension(QUALIFIED_EXTENSION_POINT_ID, ID_ATTRIBUTE, lvConfig.getId());
                throw new XPointTools.XPointException();
            }
            lvConfig.setClassName(XPointTools.findRequiredAttribute(element, CLASS_ATTRIBUTE));
            IConfigurationElement[] iConfigurationElementArray = element.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement child = iConfigurationElementArray[n2];
                String childName = child.getName();
                if (childName.equals(ENABLEMENT_ELEMENT)) {
                    Expression expr;
                    try {
                        expr = ExpressionConverter.getDefault().perform(child);
                    }
                    catch (CoreException e) {
                        XPointTools.log(e);
                        throw new XPointTools.XPointException();
                    }
                    lvConfig.setEnablementCondition(expr);
                }
                ++n2;
            }
            this.libraryValidatorConfigs.addItem((Object)lvConfig.getId(), (Object)lvConfig);
        }
        catch (XPointTools.XPointException xPointException) {}
    }
}

