/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.DocumentContextFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRootInfo;
import org.eclipse.wst.jsdt.internal.core.NameLookup;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRootInfo;
import org.eclipse.wst.jsdt.internal.core.util.HashtableOfArrayToObject;

public class LookupScopeElementInfo
extends PackageFragmentRootInfo {
    private JavaProject javaProject;
    private IPackageFragmentRoot[] rootsInScope;
    private LookupCache cache;
    private static final boolean LOOKUP_LOCAL_SCOPE_FIRST = false;

    public IPackageFragmentRoot[] getAllRoots() {
        return this.getAllRootsGlobalFirst();
    }

    private IPackageFragmentRoot[] getAllRootsGlobalFirst() {
        IPackageFragmentRoot[] projectRoots = new IPackageFragmentRoot[]{};
        int lastGood = 0;
        try {
            projectRoots = this.javaProject.getPackageFragmentRoots();
            int i = 0;
            while (i < projectRoots.length) {
                if (projectRoots[i].isLanguageRuntime()) {
                    projectRoots[lastGood++] = projectRoots[i];
                }
                ++i;
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            projectRoots = new IPackageFragmentRoot[]{};
        }
        IPackageFragmentRoot[] allRoots = new IPackageFragmentRoot[lastGood + this.rootsInScope.length];
        System.arraycopy(projectRoots, 0, allRoots, 0, lastGood);
        System.arraycopy(this.rootsInScope, 0, allRoots, lastGood, this.rootsInScope.length);
        return allRoots;
    }

    private IPackageFragmentRoot[] getAllRootsLocalFirst() {
        IPackageFragmentRoot[] projectRoots = new IPackageFragmentRoot[]{};
        int lastGood = 0;
        try {
            projectRoots = this.javaProject.getPackageFragmentRoots();
            int i = 0;
            while (i < projectRoots.length) {
                if (projectRoots[i].isLanguageRuntime()) {
                    projectRoots[lastGood++] = projectRoots[i];
                }
                ++i;
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            projectRoots = new IPackageFragmentRoot[]{};
        }
        IPackageFragmentRoot[] allRoots = new IPackageFragmentRoot[lastGood + this.rootsInScope.length];
        System.arraycopy(this.rootsInScope, 0, allRoots, 0, this.rootsInScope.length);
        System.arraycopy(projectRoots, 0, allRoots, this.rootsInScope.length, lastGood);
        return allRoots;
    }

    public LookupScopeElementInfo(JavaProject project, IPackageFragmentRoot[] rootsInScope) {
        this.javaProject = project;
        this.rootsInScope = rootsInScope;
    }

    NameLookup newNameLookup(IJavaScriptUnit[] workingCopies) {
        this.BuildLookupScopeCache(this.getAllRoots());
        return new NameLookup(this.cache.allPkgFragmentRootsCache, this.cache.allPkgFragmentsCache, workingCopies, this.cache.rootToResolvedEntries);
    }

    public LookupCache BuildLookupScopeCache(IPackageFragmentRoot[] rootsInScope) {
        HashMap reverseMap = new HashMap(3);
        HashtableOfArrayToObject fragmentsCache = new HashtableOfArrayToObject();
        HashtableOfArrayToObject isPackageCache = new HashtableOfArrayToObject();
        int i = 0;
        int length = rootsInScope.length;
        while (i < length) {
            block14: {
                IPackageFragmentRoot root = rootsInScope[i];
                IJavaScriptElement[] frags = null;
                try {
                    if (root instanceof DocumentContextFragmentRoot) {
                        LibraryFragmentRootInfo info = new LibraryFragmentRootInfo();
                        ((DocumentContextFragmentRoot)root).computeChildren(info, new HashMap());
                        frags = info.children;
                    } else if (root instanceof LibraryFragmentRoot) {
                        LibraryFragmentRootInfo info = new LibraryFragmentRootInfo();
                        ((LibraryFragmentRoot)root).computeChildren(info, new HashMap());
                        frags = info.children;
                    } else if (root instanceof PackageFragmentRoot) {
                        PackageFragmentRootInfo info = new PackageFragmentRootInfo();
                        ((PackageFragmentRoot)root).computeChildren(info, new HashMap());
                        frags = info.children;
                    } else {
                        frags = root.getChildren();
                    }
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    break block14;
                }
                int j = 0;
                int length2 = frags.length;
                while (j < length2) {
                    PackageFragment fragment = (PackageFragment)frags[j];
                    Object[] pkgName = fragment.names;
                    Object existing = fragmentsCache.get(pkgName);
                    if (existing == null) {
                        fragmentsCache.put(pkgName, root);
                        LookupScopeElementInfo.addNames((String[])pkgName, isPackageCache);
                    } else if (existing instanceof PackageFragmentRoot) {
                        fragmentsCache.put(pkgName, new IPackageFragmentRoot[]{(PackageFragmentRoot)existing, root});
                    } else {
                        IPackageFragmentRoot[] entry = (IPackageFragmentRoot[])existing;
                        IPackageFragmentRoot[] copy = new IPackageFragmentRoot[entry.length + 1];
                        System.arraycopy(entry, 0, copy, 0, entry.length);
                        copy[entry.length] = root;
                        fragmentsCache.put(pkgName, copy);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.cache = new LookupCache(rootsInScope, fragmentsCache, isPackageCache, reverseMap);
        return this.cache;
    }

    public static void addNames(String[] name, HashtableOfArrayToObject set) {
        set.put(name, name);
        int length = name.length;
        int i = length - 1;
        while (i > 0) {
            Object[] superName = new String[i];
            System.arraycopy(name, 0, superName, 0, i);
            set.put(superName, superName);
            --i;
        }
    }

    static class LookupCache {
        public IPackageFragmentRoot[] allPkgFragmentRootsCache;
        public HashtableOfArrayToObject allPkgFragmentsCache;
        public HashtableOfArrayToObject isPackageCache;
        public Map rootToResolvedEntries;

        LookupCache(IPackageFragmentRoot[] allPkgFragmentRootsCache, HashtableOfArrayToObject allPkgFragmentsCache, HashtableOfArrayToObject isPackageCache, Map rootToResolvedEntries) {
            this.allPkgFragmentRootsCache = allPkgFragmentRootsCache;
            this.allPkgFragmentsCache = allPkgFragmentsCache;
            this.isPackageCache = isPackageCache;
            this.rootToResolvedEntries = rootToResolvedEntries;
        }
    }
}

