/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JpaPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private boolean lowercase;
    private Button lowerCaseRadioButton;
    private boolean matchFirstCharacterCase;
    private Button matchFirstCharacterCaseCheckBox;
    private Button upperCaseRadioButton;

    private void addJpqlEditorGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(JptUiMessages.JpaPreferencesPage_jpqlEditor);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        Label description = new Label((Composite)group, 0);
        description.setText(JptUiMessages.JpaPreferencesPage_jpqlEditor_description);
        this.lowerCaseRadioButton = new Button((Composite)group, 16);
        this.lowerCaseRadioButton.setText(JptUiMessages.JpaPreferencesPage_jpqlEditor_lowerCaseRadioButton);
        this.lowerCaseRadioButton.addSelectionListener(this.buildLowercaseSelectionListener());
        this.lowerCaseRadioButton.setSelection(this.lowercase);
        this.upperCaseRadioButton = new Button((Composite)group, 16);
        this.upperCaseRadioButton.setText(JptUiMessages.JpaPreferencesPage_jpqlEditor_upperCaseRadioButton);
        this.upperCaseRadioButton.addSelectionListener(this.buildUppercaseSelectionListener());
        this.upperCaseRadioButton.setSelection(!this.lowercase);
        new Label((Composite)group, 0);
        this.matchFirstCharacterCaseCheckBox = new Button((Composite)group, 32);
        this.matchFirstCharacterCaseCheckBox.setText(JptUiMessages.JpaPreferencesPage_jpqlEditor_matchFirstCharacterCaseRadioButton);
        this.matchFirstCharacterCaseCheckBox.addSelectionListener(this.buildMatchFirstCharacterCaseSelectionListener());
        this.matchFirstCharacterCaseCheckBox.setSelection(this.matchFirstCharacterCase);
    }

    private SelectionListener buildLowercaseSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                JpaPreferencesPage.this.lowercase = button.getSelection();
            }
        };
    }

    private SelectionListener buildMatchFirstCharacterCaseSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                JpaPreferencesPage.this.matchFirstCharacterCase = button.getSelection();
            }
        };
    }

    private SelectionListener buildUppercaseSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                JpaPreferencesPage.this.lowercase = !button.getSelection();
            }
        };
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        parent = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        parent.setLayout((Layout)layout);
        Label description = new Label(parent, 0);
        description.setText(JptUiMessages.JpaPreferencesPage_description);
        this.addJpqlEditorGroup(parent);
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(JptJpaUiPlugin.instance().getPreferenceStore());
        this.lowercase = this.shouldUseLowercaseIdentifiers();
        this.matchFirstCharacterCase = this.shouldMatchFirstCharacterCase();
    }

    private boolean isDefaultJpqlIdentifierLowercase() {
        String value = this.getPreferenceStore().getDefaultString("org.eclipse.jpt.jpa.ui.jpqlIdentifier.case");
        return "lowercase".equals(value);
    }

    private String jpqlIdentifierPreferenceValue() {
        return this.lowercase ? "lowercase" : "uppercase";
    }

    protected void performDefaults() {
        this.lowercase = this.isDefaultJpqlIdentifierLowercase();
        this.matchFirstCharacterCase = this.shouldDefaultMatchFirstCharacterCase();
        this.lowerCaseRadioButton.setSelection(this.lowercase);
        this.upperCaseRadioButton.setSelection(!this.lowercase);
        this.matchFirstCharacterCaseCheckBox.setSelection(this.matchFirstCharacterCase);
        super.performDefaults();
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("org.eclipse.jpt.jpa.ui.jpqlIdentifier.case", this.jpqlIdentifierPreferenceValue());
        this.getPreferenceStore().setValue("org.eclipse.jpt.jpa.ui.jpqlIdentifier.matchFirstCharacterCase", this.matchFirstCharacterCase);
        return super.performOk();
    }

    private boolean shouldDefaultMatchFirstCharacterCase() {
        return this.getPreferenceStore().getDefaultBoolean("org.eclipse.jpt.jpa.ui.jpqlIdentifier.matchFirstCharacterCase");
    }

    private boolean shouldMatchFirstCharacterCase() {
        return this.getPreferenceStore().getBoolean("org.eclipse.jpt.jpa.ui.jpqlIdentifier.matchFirstCharacterCase");
    }

    private boolean shouldUseLowercaseIdentifiers() {
        String value = this.getPreferenceStore().getString("org.eclipse.jpt.jpa.ui.jpqlIdentifier.case");
        return "lowercase".equals(value);
    }
}

