/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.jpql;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.persistence.jpa.jpql.ContentAssistProposals;
import org.eclipse.persistence.jpa.jpql.ResultQuery;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

final class JpqlCompletionProposal
implements ICompletionProposal {
    private String actualQuery;
    private String additionalInfo;
    private ContentAssistProposals proposals;
    private int cursorOffset;
    private String displayString;
    private boolean escapeCharacters;
    private Image image;
    private String jpqlQuery;
    private NamedQuery namedQuery;
    private int offset;
    private int position;
    private String proposal;
    private ResultQuery result;
    private boolean toggleCompletion;

    JpqlCompletionProposal(ContentAssistProposals proposals, String proposal, String displayString, String additionalInfo, Image image, NamedQuery namedQuery, String actualQuery, String jpqlQuery, int offset, int position, int cursorOffset, boolean escapeCharacters) {
        this.image = image;
        this.offset = offset;
        this.position = position;
        this.proposal = proposal;
        this.jpqlQuery = jpqlQuery;
        this.proposals = proposals;
        this.namedQuery = namedQuery;
        this.actualQuery = actualQuery;
        this.cursorOffset = cursorOffset;
        this.displayString = displayString;
        this.additionalInfo = additionalInfo;
        this.escapeCharacters = escapeCharacters;
    }

    public void apply(IDocument document) {
        try {
            ResultQuery result = this.buildResult();
            document.replace(this.offset, this.actualQuery.length(), result.getQuery());
        }
        catch (BadLocationException badLocationException) {}
    }

    private ResultQuery buildResult() {
        if (this.result == null) {
            this.result = this.escapeCharacters ? this.proposals.buildEscapedQuery(this.jpqlQuery, this.proposal, this.position, this.isCompletionInserts() ^ this.toggleCompletion) : this.proposals.buildQuery(this.jpqlQuery, this.proposal, this.position, this.isCompletionInserts() ^ this.toggleCompletion);
        }
        return this.result;
    }

    public String getAdditionalProposalInfo() {
        return this.additionalInfo;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public Image getImage() {
        return this.image;
    }

    public Point getSelection(IDocument document) {
        ResultQuery result = this.buildResult();
        return new Point(this.offset + result.getPosition() + this.cursorOffset, 0);
    }

    private boolean isCompletionInserts() {
        IJavaProject javaProject = this.namedQuery.getJpaProject().getJavaProject();
        String value = PreferenceConstants.getPreference((String)"content_assist_insert_completion", (IJavaProject)javaProject);
        return Boolean.valueOf(value);
    }
}

