/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.gen;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jaxb.core.internal.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.internal.gen.ClassesGenerator;
import org.eclipse.jpt.jaxb.core.internal.gen.ClassesGeneratorExtensionOptions;
import org.eclipse.jpt.jaxb.core.internal.gen.ClassesGeneratorOptions;

public class GenerateJaxbClassesJob
extends WorkspaceJob {
    private final IJavaProject javaProject;
    private final String absoluteLocalXsdUri;
    private final String outputDir;
    private final String targetPackage;
    private final String catalog;
    private final boolean usesMoxyGenerator;
    private final String[] bindingsFileNames;
    private final ClassesGeneratorOptions generatorOptions;
    private final ClassesGeneratorExtensionOptions generatorExtensionOptions;

    public GenerateJaxbClassesJob(IJavaProject javaProject, String absoluteLocalXsdUri, String outputDir, String targetPackage, String catalog, boolean usesMoxyGenerator, String[] bindingsFileNames, ClassesGeneratorOptions generatorOptions, ClassesGeneratorExtensionOptions generatorExtensionOptions) {
        super(JptJaxbCoreMessages.ClassesGenerator_generatingClasses);
        if (javaProject == null) {
            throw new RuntimeException("Project is null");
        }
        if (StringTools.stringIsEmpty((String)absoluteLocalXsdUri)) {
            throw new RuntimeException("Schema cannot be empty");
        }
        if (StringTools.stringIsEmpty((String)outputDir)) {
            throw new RuntimeException("Output directory cannot be empty");
        }
        this.javaProject = javaProject;
        this.absoluteLocalXsdUri = absoluteLocalXsdUri;
        this.outputDir = outputDir;
        this.targetPackage = targetPackage;
        this.catalog = catalog;
        this.usesMoxyGenerator = usesMoxyGenerator;
        this.bindingsFileNames = bindingsFileNames;
        this.generatorOptions = generatorOptions;
        this.generatorExtensionOptions = generatorExtensionOptions;
        this.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)this.javaProject.getProject()));
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)JptJaxbCoreMessages.ClassesGenerator_generatingClassesTask, (int)1);
        try {
            this.classesGeneratorGenerate(this.javaProject, this.absoluteLocalXsdUri, this.outputDir, this.targetPackage, this.catalog, this.usesMoxyGenerator, this.bindingsFileNames, this.generatorOptions, this.generatorExtensionOptions, (IProgressMonitor)sm.newChild(1));
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (RuntimeException re) {
            throw new RuntimeException(re);
        }
        return Status.OK_STATUS;
    }

    private void classesGeneratorGenerate(IJavaProject javaProject, String absoluteLocalXsdUri, String outputDir, String targetPackage, String catalog, boolean usesMoxyGenerator, String[] bindingsFileNames, ClassesGeneratorOptions generatorOptions, ClassesGeneratorExtensionOptions generatorExtensionOptions, IProgressMonitor monitor) {
        ClassesGenerator.generate(javaProject, absoluteLocalXsdUri, outputDir, targetPackage, catalog, usesMoxyGenerator, bindingsFileNames, generatorOptions, generatorExtensionOptions, monitor);
    }
}

