/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.XmlJavaTypeAdapter;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.resource.java.XmlJavaTypeAdapterAnnotation;

public abstract class AbstractJavaXmlJavaTypeAdapter
extends AbstractJavaContextNode
implements XmlJavaTypeAdapter {
    protected final XmlJavaTypeAdapterAnnotation resourceXmlJavaTypeAdapter;
    protected String value;
    protected String specifiedType;
    protected String defaultType;

    protected AbstractJavaXmlJavaTypeAdapter(JaxbContextNode parent, XmlJavaTypeAdapterAnnotation resource) {
        super(parent);
        this.resourceXmlJavaTypeAdapter = resource;
        this.value = this.getResourceValue();
        this.specifiedType = this.getResourceTypeString();
        this.defaultType = this.buildDefaultType();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setValue_(this.getResourceValue());
        this.setSpecifiedType_(this.getResourceTypeString());
        this.setDefaultType(this.buildDefaultType());
    }

    public XmlJavaTypeAdapterAnnotation getResourceXmlJavaTypeAdapter() {
        return this.resourceXmlJavaTypeAdapter;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.resourceXmlJavaTypeAdapter.setValue(value);
        this.setValue_(value);
    }

    protected void setValue_(String value) {
        String old = this.value;
        this.value = value;
        this.firePropertyChanged("value", old, value);
    }

    protected String getResourceValue() {
        return this.resourceXmlJavaTypeAdapter.getValue();
    }

    public String getType() {
        return this.specifiedTypeNotSet() ? this.getDefaultType() : this.getSpecifiedType();
    }

    protected boolean specifiedTypeNotSet() {
        return this.getSpecifiedType() == null || this.getSpecifiedType().equals("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.DEFAULT");
    }

    public String getDefaultType() {
        return this.defaultType;
    }

    protected void setDefaultType(String defaultType) {
        String oldDefaultType = this.defaultType;
        this.defaultType = defaultType;
        this.firePropertyChanged("defaultType", oldDefaultType, defaultType);
    }

    protected abstract String buildDefaultType();

    public String getSpecifiedType() {
        return this.specifiedType;
    }

    public void setSpecifiedType(String location) {
        this.resourceXmlJavaTypeAdapter.setType(location);
        this.setSpecifiedType_(location);
    }

    protected void setSpecifiedType_(String type) {
        String old = this.specifiedType;
        this.specifiedType = type;
        this.firePropertyChanged("specifiedType", old, type);
    }

    protected String getResourceTypeString() {
        return this.resourceXmlJavaTypeAdapter.getType();
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getResourceXmlJavaTypeAdapter().getTextRange(astRoot);
    }
}

