/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.beans.Introspector;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbContextRoot;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentType;
import org.eclipse.jpt.jaxb.core.context.XmlRootElement;
import org.eclipse.jpt.jaxb.core.internal.AbstractJaxbNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaType;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.jaxb.core.resource.java.XmlRootElementAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlTypeAnnotation;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaPersistentType
extends AbstractJavaType
implements JaxbPersistentType {
    protected String factoryClass = this.getResourceFactoryClass();
    protected String factoryMethod = this.getResourceFactoryMethod();
    protected String specifiedXmlTypeName = this.getResourceXmlTypeName();
    protected String specifiedNamespace = this.getResourceNamespace();
    protected final PropOrderContainer propOrderContainer = new PropOrderContainer();
    protected XmlRootElement rootElement = this.buildRootElement();

    public AbstractJavaPersistentType(JaxbContextRoot parent, JavaResourceAbstractType resourceType) {
        super(parent, resourceType);
    }

    @Override
    public JaxbContextRoot getParent() {
        return (JaxbContextRoot)super.getParent();
    }

    protected JaxbPackageInfo getPackageInfo() {
        JaxbPackage jaxbPackage = this.getParent().getPackage(this.getPackageName());
        return jaxbPackage == null ? null : jaxbPackage.getPackageInfo();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setFactoryClass_(this.getResourceFactoryClass());
        this.setFactoryMethod_(this.getResourceFactoryMethod());
        this.setSpecifiedXmlTypeName_(this.getResourceXmlTypeName());
        this.setSpecifiedNamespace_(this.getResourceNamespace());
        this.syncPropOrder();
        this.syncRootElement();
    }

    protected XmlTypeAnnotation getXmlTypeAnnotation() {
        return (XmlTypeAnnotation)this.getJavaResourceType().getNonNullAnnotation("javax.xml.bind.annotation.XmlType");
    }

    @Override
    public String getFactoryClass() {
        return this.factoryClass;
    }

    @Override
    public void setFactoryClass(String factoryClass) {
        this.getXmlTypeAnnotation().setFactoryClass(factoryClass);
        this.setFactoryClass_(factoryClass);
    }

    protected void setFactoryClass_(String factoryClass) {
        String old = this.factoryClass;
        this.factoryClass = factoryClass;
        this.firePropertyChanged("factoryClass", old, factoryClass);
    }

    protected String getResourceFactoryClass() {
        return this.getXmlTypeAnnotation().getFactoryClass();
    }

    @Override
    public String getFactoryMethod() {
        return this.factoryMethod;
    }

    @Override
    public void setFactoryMethod(String factoryMethod) {
        this.getXmlTypeAnnotation().setFactoryMethod(factoryMethod);
        this.setFactoryMethod_(factoryMethod);
    }

    protected void setFactoryMethod_(String factoryMethod) {
        String old = this.factoryMethod;
        this.factoryMethod = factoryMethod;
        this.firePropertyChanged("factoryMethod", old, factoryMethod);
    }

    protected String getResourceFactoryMethod() {
        return this.getXmlTypeAnnotation().getFactoryMethod();
    }

    @Override
    public String getXmlTypeName() {
        return this.specifiedXmlTypeName != null ? this.specifiedXmlTypeName : this.getDefaultXmlTypeName();
    }

    @Override
    public String getSpecifiedXmlTypeName() {
        return this.specifiedXmlTypeName;
    }

    @Override
    public void setSpecifiedXmlTypeName(String xmlTypeName) {
        this.getXmlTypeAnnotation().setName(xmlTypeName);
        this.setSpecifiedXmlTypeName_(xmlTypeName);
    }

    protected void setSpecifiedXmlTypeName_(String xmlTypeName) {
        String old = this.specifiedXmlTypeName;
        this.specifiedXmlTypeName = xmlTypeName;
        this.firePropertyChanged("specifiedXmlTypeName", old, xmlTypeName);
    }

    @Override
    public String getDefaultXmlTypeName() {
        return Introspector.decapitalize(this.getSimpleName());
    }

    protected String getResourceXmlTypeName() {
        return this.getXmlTypeAnnotation().getName();
    }

    @Override
    public String getNamespace() {
        return this.specifiedNamespace != null ? this.specifiedNamespace : this.getDefaultNamespace();
    }

    @Override
    public String getSpecifiedNamespace() {
        return this.specifiedNamespace;
    }

    @Override
    public void setSpecifiedNamespace(String namespace) {
        this.getXmlTypeAnnotation().setNamespace(namespace);
        this.setSpecifiedNamespace_(namespace);
    }

    protected void setSpecifiedNamespace_(String namespace) {
        String old = this.specifiedNamespace;
        this.specifiedNamespace = namespace;
        this.firePropertyChanged("specifiedNamespace", old, namespace);
    }

    @Override
    public String getDefaultNamespace() {
        return this.getJaxbPackage().getNamespace();
    }

    protected String getResourceNamespace() {
        return this.getXmlTypeAnnotation().getNamespace();
    }

    @Override
    public ListIterable<String> getPropOrder() {
        return this.propOrderContainer.getContextElements();
    }

    @Override
    public int getPropOrderSize() {
        return this.propOrderContainer.getContextElementsSize();
    }

    @Override
    public void addProp(int index, String prop) {
        this.getXmlTypeAnnotation().addProp(index, prop);
        this.propOrderContainer.addContextElement(index, prop);
    }

    @Override
    public void removeProp(String prop) {
        this.removeProp(this.propOrderContainer.indexOfContextElement(prop));
    }

    @Override
    public void removeProp(int index) {
        this.getXmlTypeAnnotation().removeProp(index);
        this.propOrderContainer.removeContextElement(index);
    }

    @Override
    public void moveProp(int targetIndex, int sourceIndex) {
        this.getXmlTypeAnnotation().moveProp(targetIndex, sourceIndex);
        this.propOrderContainer.moveContextElement(targetIndex, sourceIndex);
    }

    protected void syncPropOrder() {
        this.propOrderContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<String> getResourcePropOrder() {
        return this.getXmlTypeAnnotation().getPropOrder();
    }

    @Override
    public XmlRootElement getRootElement() {
        return this.rootElement;
    }

    @Override
    public boolean isRootElement() {
        return this.rootElement != null;
    }

    @Override
    public XmlRootElement setRootElement(String name) {
        if (name == null) {
            this.getJavaResourceType().removeAnnotation("javax.xml.bind.annotation.XmlRootElement");
            this.setRootElement_(null);
            return null;
        }
        XmlRootElementAnnotation resourceRootElement = (XmlRootElementAnnotation)this.getJavaResourceType().addAnnotation("javax.xml.bind.annotation.XmlRootElement");
        resourceRootElement.setName(name);
        XmlRootElement contextRootElement = this.buildRootElement(resourceRootElement);
        this.setRootElement_(contextRootElement);
        return contextRootElement;
    }

    protected void setRootElement_(XmlRootElement rootElement) {
        XmlRootElement old = this.rootElement;
        this.rootElement = rootElement;
        this.firePropertyChanged("rootElement", old, rootElement);
    }

    protected XmlRootElement buildRootElement() {
        XmlRootElementAnnotation resourceRootElement = this.getRootElementAnnotation();
        return resourceRootElement == null ? null : this.buildRootElement(resourceRootElement);
    }

    protected XmlRootElement buildRootElement(XmlRootElementAnnotation resourceRootElement) {
        return this.getFactory().buildJavaXmlRootElement(this, resourceRootElement);
    }

    protected void syncRootElement() {
        XmlRootElementAnnotation resourceRootElement = this.getRootElementAnnotation();
        if (resourceRootElement != null) {
            if (this.rootElement != null) {
                this.rootElement.synchronizeWithResourceModel();
            } else {
                this.setRootElement_(this.buildRootElement(resourceRootElement));
            }
        } else if (this.rootElement != null) {
            this.setRootElement_(null);
        }
    }

    protected XmlRootElementAnnotation getRootElementAnnotation() {
        return (XmlRootElementAnnotation)this.getJavaResourceType().getAnnotation("javax.xml.bind.annotation.XmlRootElement");
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        this.getJaxbProject().getSchemaLibrary().refreshSchema(this.getJaxbPackage().getNamespace());
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        if (this.namespaceTouches(pos, astRoot)) {
            return this.getNamespaceProposals(filter);
        }
        if (this.nameTouches(pos, astRoot)) {
            return this.getNameProposals(filter);
        }
        if (this.rootElement != null && !CollectionTools.isEmpty(result = this.rootElement.getJavaCompletionProposals(pos, filter, astRoot))) {
            return result;
        }
        return EmptyIterable.instance();
    }

    protected boolean namespaceTouches(int pos, CompilationUnit astRoot) {
        return this.getXmlTypeAnnotation().namespaceTouches(pos, astRoot);
    }

    protected Iterable<String> getNamespaceProposals(Filter<String> filter) {
        XsdSchema schema = this.getJaxbPackage().getXsdSchema();
        if (schema == null) {
            return EmptyIterable.instance();
        }
        return schema.getNamespaceProposals(filter);
    }

    protected boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.getXmlTypeAnnotation().nameTouches(pos, astRoot);
    }

    protected Iterable<String> getNameProposals(Filter<String> filter) {
        XsdSchema schema = this.getJaxbPackage().getXsdSchema();
        if (schema == null) {
            return EmptyIterable.instance();
        }
        return schema.getTypeNameProposals(this.getNamespace(), filter);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getXmlTypeAnnotation().getTextRange(astRoot);
        return textRange != null ? textRange : super.getValidationTextRange(astRoot);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateXmlType(messages, reporter, astRoot);
        if (this.rootElement != null) {
            this.rootElement.validate(messages, reporter, astRoot);
        }
    }

    protected void validateXmlType(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        String name = this.getXmlTypeName();
        String namespace = this.getNamespace();
        if ("".equals(name)) {
            if (!StringTools.stringsAreEqual((String)namespace, (String)this.getJaxbPackage().getNamespace())) {
                messages.add(DefaultValidationMessages.buildMessage(1, "XML_TYPE_UNMATCHING_NAMESPACE_FOR_ANONYMOUS_TYPE", this, this.getXmlTypeAnnotation().getNamespaceTextRange(astRoot)));
            }
        } else {
            XsdTypeDefinition schemaType;
            XsdSchema schema = this.getJaxbPackage().getXsdSchema();
            if (schema != null && (schemaType = schema.getTypeDefinition(namespace, name)) == null) {
                messages.add(DefaultValidationMessages.buildMessage(1, "XML_TYPE_UNRESOLVED_SCHEMA_TYPE", new String[]{name, namespace}, this, this.getXmlTypeAnnotation().getTextRange(astRoot)));
            }
        }
    }

    @Override
    public XsdTypeDefinition getXsdTypeDefinition() {
        XsdSchema xsdSchema = this.getJaxbPackage().getXsdSchema();
        return xsdSchema == null ? null : xsdSchema.getTypeDefinition(this.getNamespace(), this.getXmlTypeName());
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.getFullyQualifiedName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PropOrderContainer
    extends AbstractJaxbNode.ListContainer<String, String> {
        protected PropOrderContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "propOrder";
        }

        @Override
        protected String buildContextElement(String resourceElement) {
            return resourceElement;
        }

        @Override
        protected ListIterable<String> getResourceElements() {
            return AbstractJavaPersistentType.this.getResourcePropOrder();
        }

        @Override
        protected String getResourceElement(String contextElement) {
            return contextElement;
        }
    }
}

