/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.libprov.JaxbLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDescription;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformGroupDescription;

public class JaxbPlatformTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!property.equals("jaxbPlatform") && !property.equals("jaxbPlatformGroup") || !(expectedValue instanceof String)) {
            return false;
        }
        JaxbPlatformDescription platform = null;
        if (receiver instanceof IResource) {
            platform = this.platform(((IResource)receiver).getProject());
        } else if (receiver instanceof IJavaElement) {
            platform = this.platform(((IJavaElement)receiver).getResource().getProject());
        } else if (receiver instanceof JaxbPlatformDescription) {
            platform = (JaxbPlatformDescription)receiver;
        } else if (receiver instanceof JaxbLibraryProviderInstallOperationConfig) {
            platform = ((JaxbLibraryProviderInstallOperationConfig)receiver).getJaxbPlatform();
        }
        if (property.equals("jaxbPlatform")) {
            JaxbPlatformDescription otherPlatform = JptJaxbCorePlugin.getJaxbPlatformManager().getJaxbPlatform((String)expectedValue);
            return platform == null ? false : platform.equals(otherPlatform);
        }
        if (property.equals("jaxbPlatformGroup")) {
            JaxbPlatformGroupDescription group = platform == null ? null : platform.getGroup();
            JaxbPlatformGroupDescription otherGroup = JptJaxbCorePlugin.getJaxbPlatformManager().getJaxbPlatformGroup((String)expectedValue);
            return group == null ? false : group.equals(otherGroup);
        }
        return false;
    }

    private JaxbPlatformDescription platform(IProject project) {
        return project == null ? null : JptJaxbCorePlugin.getJaxbPlatformManager().getJaxbPlatform(JptJaxbCorePlugin.getJaxbPlatformId(project));
    }
}

