/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.ui.CodeGeneration;

class NewJSFileWizardPage
extends WizardNewFileCreationPage {
    private IContentType fContentType;
    private List fValidExtensions = null;
    private Button commentsButton;

    public NewJSFileWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
    }

    private void typePageLinkActivated() {
        IProject project = this.getProjectFromPath(this.getContainerFullPath());
        if (project != null && this.isWebProject(project)) {
            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)project.getProject(), (String)"org.eclipse.wst.jsdt.ui.propertyPages.CodeTemplatePreferencePage", null, null);
            dialog.open();
        } else {
            String title = NewWizardMessages.NewTypeWizardPage_configure_templates_title;
            String message = NewWizardMessages.NewTypeWizardPage_configure_templates_message;
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    protected void createAdvancedControls(Composite parent) {
        Link link = new Link(parent, 0);
        link.setText(NewWizardMessages.NewTypeWizardPage_addcomment_description);
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                NewJSFileWizardPage.this.typePageLinkActivated();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                NewJSFileWizardPage.this.typePageLinkActivated();
            }
        });
        DialogField.createEmptySpace(parent);
        this.commentsButton = new Button(parent, 32);
        this.commentsButton.setFont(parent.getFont());
        this.commentsButton.setText(NewWizardMessages.NewTypeWizardPage_addcomment_label);
        DialogField.createEmptySpace(parent);
        super.createAdvancedControls(parent);
    }

    protected void initialPopulateContainerNameField() {
        super.initialPopulateContainerNameField();
        IPath fullPath = this.getContainerFullPath();
        if (fullPath != null && fullPath.segmentCount() > 0) {
            IProject project = this.getProjectFromPath(fullPath);
            IPath webContentPath = this.getWebContentPath(project);
            IPath projectPath = project.getFullPath();
            if (projectPath.equals((Object)fullPath)) {
                this.setContainerFullPath(webContentPath);
            } else {
                this.setContainerFullPath(fullPath);
            }
        }
    }

    protected boolean validatePage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (!super.validatePage()) {
            return false;
        }
        String fileName = this.getFileName();
        IPath fullPath = this.getContainerFullPath();
        if (fullPath != null && !fullPath.isEmpty() && fileName != null) {
            IPath webContentPath;
            IProject project;
            if (!this.extensionValidForContentType(fileName)) {
                this.setErrorMessage(NLS.bind((String)NewWizardMessages.Javascript_Error_Filename_Must_End_JS, (Object)this.getValidExtensions().toString()));
                return false;
            }
            if (fileName.lastIndexOf(46) == -1) {
                String newFileName = this.addDefaultExtension(fileName);
                IPath resourcePath = fullPath.append(newFileName);
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IStatus result = workspace.validatePath(resourcePath.toString(), 2);
                if (!result.isOK()) {
                    this.setErrorMessage(result.getMessage());
                    return false;
                }
                if (workspace.getRoot().getFolder(resourcePath).exists() || workspace.getRoot().getFile(resourcePath).exists()) {
                    this.setErrorMessage(NewWizardMessages.Javascript_Resource_Group_Name_Exists);
                    return false;
                }
            }
            if ((project = this.getProjectFromPath(fullPath)) != null && this.isWebProject(project) && !(webContentPath = this.getWebContentPath(project)).isPrefixOf(fullPath)) {
                this.setMessage(NewWizardMessages.Javascript_Warning_Folder_Must_Be_Inside_Web_Content, 2);
            }
        }
        return true;
    }

    private IContentType getContentType() {
        if (this.fContentType == null) {
            this.fContentType = Platform.getContentTypeManager().getContentType("org.eclipse.wst.jsdt.core.jsSource");
        }
        return this.fContentType;
    }

    private List getValidExtensions() {
        if (this.fValidExtensions == null) {
            IContentType type = this.getContentType();
            this.fValidExtensions = new ArrayList<String>(Arrays.asList(type.getFileSpecs(8)));
        }
        return this.fValidExtensions;
    }

    private boolean extensionValidForContentType(String fileName) {
        boolean valid = false;
        IContentType type = this.getContentType();
        if (fileName.lastIndexOf(46) != -1) {
            IContentType[] types = Platform.getContentTypeManager().findContentTypesFor(fileName);
            int i = 0;
            while (i < types.length && !valid) {
                valid = types[i].isKindOf(type);
                ++i;
            }
        } else {
            valid = true;
        }
        return valid;
    }

    String addDefaultExtension(String filename) {
        StringBuffer newFileName = new StringBuffer(filename);
        newFileName.append(".");
        newFileName.append("js");
        return newFileName.toString();
    }

    private IProject getProjectFromPath(IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = null;
        if (path != null) {
            project = workspace.validatePath(path.toString(), 4).isOK() ? workspace.getRoot().getProject(path.toString()) : workspace.getRoot().getFile(path).getProject();
        }
        return project;
    }

    private boolean isWebProject(IProject project) {
        return true;
    }

    private IPath getWebContentPath(IProject project) {
        IPath path = null;
        if (project != null && this.isWebProject(project)) {
            path = project.getFullPath();
            path.append("/");
        }
        return path;
    }

    public void addFileComment(IFile file) {
        if (this.commentsButton.getSelection()) {
            IJavaScriptUnit cu = JavaScriptCore.createCompilationUnitFrom((IFile)file);
            try {
                cu.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                cu.getBuffer().setContents(CodeGeneration.getFileComment(cu, StubUtility.getLineDelimiterUsed((IJavaScriptElement)cu)));
                cu.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                cu.discardWorkingCopy();
            }
            catch (CoreException e) {
                JavaScriptPlugin.log(e);
            }
        }
    }
}

