/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.wst.jsdt.internal.ui.text.java.MemberProposalInfo;

public final class MethodProposalInfo
extends MemberProposalInfo {
    private IFunction fFallbackMatch;

    public MethodProposalInfo(IJavaScriptProject project, CompletionProposal proposal) {
        super(project, proposal);
    }

    protected IMember resolveMember() throws JavaScriptModelException {
        char[] declarationSignature = this.fProposal.getDeclarationSignature();
        IFunction func = null;
        if (declarationSignature != null) {
            int i;
            String[] paramTypeNameStrings;
            String typeName = SignatureUtil.stripSignatureToFQN(String.valueOf(declarationSignature));
            String name = String.valueOf(this.fProposal.getName());
            char[] signature = this.fProposal.getSignature();
            if (signature != null && signature.length > 0) {
                paramTypeNameStrings = Signature.getParameterTypes((String)String.valueOf(this.fProposal.getSignature()));
            } else {
                char[][] paramTypeNameChars = this.fProposal.getParameterTypeNames();
                paramTypeNameStrings = new String[paramTypeNameChars.length];
                i = 0;
                while (i < paramTypeNameChars.length) {
                    paramTypeNameStrings[i] = String.valueOf(paramTypeNameChars[i]);
                    ++i;
                }
            }
            IType[] types = this.fJavaProject.findTypes(typeName);
            if (types != null && types.length > 0) {
                i = 0;
                while (i < types.length && func == null) {
                    IType type = types[i];
                    if (type != null) {
                        boolean isConstructor = this.fProposal.isConstructor();
                        try {
                            func = this.findMethod(name, paramTypeNameStrings, isConstructor, type);
                        }
                        catch (JavaScriptModelException javaScriptModelException) {}
                    }
                    ++i;
                }
            } else {
                ITypeRoot typeRoot = this.fJavaProject.findTypeRoot(typeName);
                if (typeRoot != null) {
                    func = typeRoot.getFunction(name, paramTypeNameStrings);
                }
            }
        }
        return func;
    }

    private IFunction findMethod(String name, String[] paramTypes, boolean isConstructor, IType type) throws JavaScriptModelException {
        Map typeVariables = this.computeTypeVariables(type);
        return this.findMethod(name, paramTypes, isConstructor, type.getFunctions(), typeVariables);
    }

    private Map computeTypeVariables(IType type) throws JavaScriptModelException {
        HashMap map = new HashMap();
        char[] declarationSignature = this.fProposal.getDeclarationSignature();
        if (declarationSignature == null) {
            return map;
        }
        return map;
    }

    private IFunction findMethod(String name, String[] paramTypes, boolean isConstructor, IFunction[] methods, Map typeVariables) throws JavaScriptModelException {
        int i = methods.length - 1;
        while (i >= 0) {
            if (this.isSameMethodSignature(name, paramTypes, isConstructor, methods[i], typeVariables)) {
                return methods[i];
            }
            --i;
        }
        return this.fFallbackMatch;
    }

    private boolean isSameMethodSignature(String name, String[] paramTypes, boolean isConstructor, IFunction method, Map typeVariables) throws JavaScriptModelException {
        String[] otherParams;
        if ((isConstructor || name.equals(method.getElementName())) && isConstructor == method.isConstructor() && paramTypes.length == (otherParams = method.getParameterTypes()).length) {
            this.fFallbackMatch = method;
            String signature = method.getSignature();
            String[] otherParamsFromSignature = Signature.getParameterTypes((String)signature);
            int i = 0;
            while (i < paramTypes.length) {
                String ourParamName = this.computeSimpleTypeName(paramTypes[i], typeVariables);
                String otherParamName1 = this.computeSimpleTypeName(otherParams[i], typeVariables);
                String otherParamName2 = this.computeSimpleTypeName(otherParamsFromSignature[i], typeVariables);
                if (!ourParamName.equals(otherParamName1) && !ourParamName.equals(otherParamName2)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private String computeSimpleTypeName(String signature, Map typeVariables) {
        String simpleName = "";
        if (signature != null && signature.length() > 0) {
            String erasure = signature;
            simpleName = Signature.getSimpleName((String)Signature.toString((String)(erasure = erasure.replaceAll("/", "."))));
            char[] typeVar = (char[])typeVariables.get(simpleName);
            if (typeVar != null) {
                simpleName = String.valueOf(Signature.getSignatureSimpleName((char[])typeVar));
            }
        }
        return simpleName;
    }
}

