/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ASTCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public class IntroduceFactoryRefactoring
extends ScriptableRefactoring {
    private static final String ATTRIBUTE_PROTECT = "protect";
    private IJavaScriptUnit fCUHandle;
    private JavaScriptUnit fCU;
    private IJavaScriptUnit fFactoryUnitHandle;
    private int fSelectionStart;
    private int fSelectionLength;
    private ASTNode fSelectedNode;
    private IFunctionBinding fCtorBinding;
    private AbstractTypeDeclaration fCtorOwningClass;
    private String fNewMethodName = null;
    private SearchResultGroup[] fAllCallsTo;
    private AbstractTypeDeclaration fFactoryOwningClass;
    private FunctionDeclaration fFactoryMethod = null;
    private String[] fFormalArgNames = null;
    private ITypeBinding[] fArgTypes;
    private boolean fCtorIsVarArgs;
    private boolean fProtectConstructor = true;
    private ImportRewrite fImportRewriter;
    private boolean fCallSitesInBinaryUnits;
    private JavaScriptUnit fFactoryCU;
    private String fFactoryClassName;
    private int fConstructorVisibility = 2;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public IntroduceFactoryRefactoring(IJavaScriptUnit cu, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCUHandle = cu;
        if (cu != null) {
            this.initialize();
        }
    }

    private void initialize() {
        this.fCU = ASTCreator.createAST(this.fCUHandle, null);
    }

    private ASTNode getTargetNode(IJavaScriptUnit unit, int offset, int length) {
        ASTNode node = ASTNodes.getNormalizedNode(NodeFinder.perform((ASTNode)this.fCU, offset, length));
        if (node.getNodeType() == 14) {
            return node;
        }
        if (node.getNodeType() == 31 && ((FunctionDeclaration)node).isConstructor()) {
            return node;
        }
        StructuralPropertyDescriptor location = node.getLocationInParent();
        ASTNode parent = node.getParent();
        if (location == ClassInstanceCreation.TYPE_PROPERTY) {
            return parent;
        }
        if (location == FunctionDeclaration.NAME_PROPERTY && ((FunctionDeclaration)parent).isConstructor()) {
            return parent;
        }
        return null;
    }

    private RefactoringStatus checkSelection(IProgressMonitor pm) throws JavaScriptModelException {
        IType ctorOwningType;
        block16: {
            block15: {
                block14: {
                    block13: {
                        RefactoringStatus refactoringStatus;
                        try {
                            pm.beginTask(RefactoringCoreMessages.IntroduceFactory_examiningSelection, 2);
                            this.fSelectedNode = this.getTargetNode(this.fCUHandle, this.fSelectionStart, this.fSelectionLength);
                            if (this.fSelectedNode != null) break block13;
                            refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_notAConstructorInvocation);
                            Object var5_7 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_12 = null;
                            pm.done();
                            throw throwable;
                        }
                        pm.done();
                        return refactoringStatus;
                    }
                    if (this.fSelectedNode instanceof ClassInstanceCreation) {
                        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)this.fSelectedNode;
                        this.fCtorBinding = classInstanceCreation.resolveConstructorBinding();
                    } else if (this.fSelectedNode instanceof FunctionDeclaration) {
                        FunctionDeclaration methodDeclaration = (FunctionDeclaration)this.fSelectedNode;
                        this.fCtorBinding = methodDeclaration.resolveBinding();
                    }
                    if (this.fCtorBinding != null) break block14;
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_unableToResolveConstructorBinding);
                    Object var5_8 = null;
                    pm.done();
                    return refactoringStatus;
                }
                this.fCtorBinding = this.fCtorBinding.getMethodDeclaration();
                if (this.fNewMethodName == null) {
                    this.fNewMethodName = "create" + this.fCtorBinding.getName();
                }
                pm.worked(1);
                if (!this.fCtorBinding.getDeclaringClass().isNested()) break block15;
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_unsupportedNestedTypes);
                Object var5_9 = null;
                pm.done();
                return refactoringStatus;
            }
            ITypeBinding ctorType = this.fCtorBinding.getDeclaringClass();
            ctorOwningType = (IType)ctorType.getJavaElement();
            if (!ctorOwningType.isBinary()) break block16;
            RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_constructorInBinaryClass);
            Object var5_10 = null;
            pm.done();
            return refactoringStatus;
        }
        this.fFactoryUnitHandle = ctorOwningType.getJavaScriptUnit();
        this.fFactoryCU = this.getASTFor(this.fFactoryUnitHandle);
        Name ctorOwnerName = (Name)NodeFinder.perform((ASTNode)this.fFactoryCU, ctorOwningType.getNameRange());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fFactoryOwningClass = this.fCtorOwningClass = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)ctorOwnerName, clazz);
        pm.worked(1);
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        Object var5_11 = null;
        pm.done();
        return refactoringStatus;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        block3: {
            RefactoringStatus refactoringStatus;
            try {
                pm.beginTask(RefactoringCoreMessages.IntroduceFactory_checkingActivation, 1);
                if (this.fCUHandle.isStructureKnown()) break block3;
                refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_syntaxError);
                Object var2_4 = null;
            }
            catch (Throwable throwable) {
                Object var2_6 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return refactoringStatus;
        }
        RefactoringStatus refactoringStatus = this.checkSelection((IProgressMonitor)new SubProgressMonitor(pm, 1));
        Object var2_5 = null;
        pm.done();
        return refactoringStatus;
    }

    private IJavaScriptUnit[] collectAffectedUnits(SearchResultGroup[] searchHits) {
        ArrayList<IJavaScriptUnit> result = new ArrayList<IJavaScriptUnit>();
        boolean hitInFactoryClass = false;
        int i = 0;
        while (i < searchHits.length) {
            SearchResultGroup rg = searchHits[i];
            IJavaScriptUnit icu = rg.getCompilationUnit();
            result.add(icu);
            if (icu.equals(this.fFactoryUnitHandle)) {
                hitInFactoryClass = true;
            }
            ++i;
        }
        if (!hitInFactoryClass) {
            result.add(this.fFactoryUnitHandle);
        }
        return result.toArray(new IJavaScriptUnit[result.size()]);
    }

    private SearchPattern createSearchPattern(IFunction ctor, IFunctionBinding methodBinding) {
        Assert.isNotNull((Object)methodBinding, (String)RefactoringCoreMessages.IntroduceFactory_noBindingForSelectedConstructor);
        if (ctor != null) {
            return SearchPattern.createPattern((IJavaScriptElement)ctor, (int)2, (int)24);
        }
        StringBuffer buf = new StringBuffer();
        buf.append(methodBinding.getDeclaringClass().getQualifiedName()).append("(");
        int i = 0;
        while (i < this.fArgTypes.length) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(this.fArgTypes[i].getQualifiedName());
            ++i;
        }
        buf.append(")");
        return SearchPattern.createPattern((String)buf.toString(), (int)3, (int)2, (int)24);
    }

    private IJavaScriptSearchScope createSearchScope(IFunction ctor, IFunctionBinding binding) throws JavaScriptModelException {
        if (ctor != null) {
            return RefactoringScopeFactory.create((IJavaScriptElement)ctor);
        }
        ITypeBinding type = Bindings.getTopLevelType(binding.getDeclaringClass());
        return RefactoringScopeFactory.create(type.getJavaElement());
    }

    private SearchResultGroup[] excludeBinaryUnits(SearchResultGroup[] groups) {
        ArrayList<SearchResultGroup> result = new ArrayList<SearchResultGroup>();
        int i = 0;
        while (i < groups.length) {
            SearchResultGroup rg = groups[i];
            IJavaScriptUnit unit = rg.getCompilationUnit();
            if (unit != null) {
                result.add(rg);
            } else {
                this.fCallSitesInBinaryUnits = true;
            }
            ++i;
        }
        return result.toArray(new SearchResultGroup[result.size()]);
    }

    private SearchResultGroup[] searchForCallsTo(IFunctionBinding methodBinding, IProgressMonitor pm, RefactoringStatus status) throws JavaScriptModelException {
        IFunction method = (IFunction)methodBinding.getJavaElement();
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(this.createSearchPattern(method, methodBinding));
        engine.setFiltering(true, true);
        engine.setScope(this.createSearchScope(method, methodBinding));
        engine.setStatus(status);
        engine.searchPattern((IProgressMonitor)new SubProgressMonitor(pm, 1));
        return (SearchResultGroup[])engine.getResults();
    }

    private SearchResultGroup[] findAllCallsTo(IFunctionBinding ctorBinding, IProgressMonitor pm, RefactoringStatus status) throws JavaScriptModelException {
        SearchResultGroup[] groups = this.excludeBinaryUnits(this.searchForCallsTo(ctorBinding, pm, status));
        return groups;
    }

    private IType findNonPrimaryType(String fullyQualifiedName, IProgressMonitor pm, RefactoringStatus status) throws JavaScriptModelException {
        SearchPattern p = SearchPattern.createPattern((String)fullyQualifiedName, (int)0, (int)0, (int)24);
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(p);
        engine.setFiltering(true, true);
        engine.setScope(RefactoringScopeFactory.create((IJavaScriptElement)this.fCtorBinding.getJavaElement().getJavaScriptProject()));
        engine.setStatus(status);
        engine.searchPattern((IProgressMonitor)new SubProgressMonitor(pm, 1));
        SearchResultGroup[] groups = (SearchResultGroup[])engine.getResults();
        if (groups.length != 0) {
            int i = 0;
            while (i < groups.length) {
                SearchMatch[] matches = groups[i].getSearchResults();
                int j = 0;
                while (j < matches.length) {
                    if (matches[j].getAccuracy() == 0) {
                        return (IType)matches[j].getElement();
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result;
        block5: {
            RefactoringStatus refactoringStatus;
            try {
                pm.beginTask(RefactoringCoreMessages.IntroduceFactory_checking_preconditions, 1);
                result = new RefactoringStatus();
                if (this.fFactoryClassName != null) {
                    result.merge(this.setFactoryClass(this.fFactoryClassName));
                }
                if (!result.hasFatalError()) break block5;
                refactoringStatus = result;
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return refactoringStatus;
        }
        this.fArgTypes = this.fCtorBinding.getParameterTypes();
        this.fCtorIsVarArgs = this.fCtorBinding.isVarargs();
        this.fAllCallsTo = this.findAllCallsTo(this.fCtorBinding, pm, result);
        this.fFormalArgNames = this.findCtorArgNames();
        IJavaScriptUnit[] affectedFiles = this.collectAffectedUnits(this.fAllCallsTo);
        result.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(affectedFiles), this.getValidationContext()));
        if (this.fCallSitesInBinaryUnits) {
            result.merge(RefactoringStatus.createWarningStatus((String)RefactoringCoreMessages.IntroduceFactory_callSitesInBinaryClass));
        }
        RefactoringStatus refactoringStatus = result;
        Object var4_6 = null;
        pm.done();
        return refactoringStatus;
    }

    private String[] findCtorArgNames() {
        JavaScriptUnit ctorUnit;
        FunctionDeclaration ctorDecl;
        int numArgs = this.fCtorBinding.getParameterTypes().length;
        String[] names = new String[numArgs];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.JavaScriptUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((ctorDecl = (FunctionDeclaration)(ctorUnit = (JavaScriptUnit)ASTNodes.getParent((ASTNode)this.fCtorOwningClass, clazz)).findDeclaringNode(this.fCtorBinding.getKey())) != null) {
            List formalArgs = ctorDecl.parameters();
            int i = 0;
            Iterator iter = formalArgs.iterator();
            while (iter.hasNext()) {
                SingleVariableDeclaration svd = (SingleVariableDeclaration)iter.next();
                names[i] = svd.getName().getIdentifier();
                ++i;
            }
            return names;
        }
        int i = 0;
        while (i < numArgs) {
            names[i] = "arg" + (i + 1);
            ++i;
        }
        return names;
    }

    private FunctionDeclaration createFactoryMethod(AST ast, IFunctionBinding ctorBinding, ASTRewrite unitRewriter) {
        FunctionDeclaration newMethod = ast.newFunctionDeclaration();
        SimpleName newMethodName = ast.newSimpleName(this.fNewMethodName);
        ClassInstanceCreation newCtorCall = ast.newClassInstanceCreation();
        ReturnStatement ret = ast.newReturnStatement();
        Block body = ast.newBlock();
        List stmts = body.statements();
        String retTypeName = ctorBinding.getName();
        this.createFactoryMethodSignature(ast, newMethod);
        newMethod.setName(newMethodName);
        newMethod.setBody(body);
        this.setMethodReturnType(newMethod, retTypeName, null, ast);
        newMethod.modifiers().addAll(ASTNodeFactory.newModifiers(ast, 9));
        this.setCtorTypeArguments(newCtorCall, retTypeName, null, ast);
        this.createFactoryMethodConstructorArgs(ast, newCtorCall);
        ret.setExpression((Expression)newCtorCall);
        stmts.add(ret);
        return newMethod;
    }

    private void setCtorTypeArguments(ClassInstanceCreation newCtorCall, String ctorTypeName, ITypeBinding[] ctorOwnerTypeParameters, AST ast) {
        if (ctorOwnerTypeParameters.length == 0) {
            newCtorCall.setType(ASTNodeFactory.newType(ast, ctorTypeName));
        }
    }

    private void setMethodReturnType(FunctionDeclaration newMethod, String retTypeName, ITypeBinding[] ctorOwnerTypeParameters, AST ast) {
        if (ctorOwnerTypeParameters.length == 0) {
            newMethod.setReturnType2((Type)ast.newSimpleType((Name)ast.newSimpleName(retTypeName)));
        }
    }

    private void createFactoryMethodSignature(AST ast, FunctionDeclaration newMethod) {
        List argDecls = newMethod.parameters();
        int i = 0;
        while (i < this.fArgTypes.length) {
            Type argType;
            SingleVariableDeclaration argDecl = ast.newSingleVariableDeclaration();
            if (i == this.fArgTypes.length - 1 && this.fCtorIsVarArgs) {
                argType = this.typeNodeForTypeBinding(this.fArgTypes[i].getElementType(), this.fArgTypes[i].getDimensions() - 1, ast);
                argDecl.setVarargs(true);
            } else {
                argType = this.typeNodeForTypeBinding(this.fArgTypes[i], 0, ast);
            }
            argDecl.setName(ast.newSimpleName(this.fFormalArgNames[i]));
            argDecl.setType(argType);
            argDecls.add(argDecl);
            ++i;
        }
    }

    private Type typeNodeForTypeBinding(ITypeBinding argType, int extraDims, AST ast) {
        if (extraDims > 0) {
            return ast.newArrayType(this.typeNodeForTypeBinding(argType, 0, ast), extraDims);
        }
        if (argType.isArray()) {
            Type elementType = this.typeNodeForTypeBinding(argType.getElementType(), extraDims, ast);
            return ast.newArrayType(elementType, argType.getDimensions());
        }
        return this.fImportRewriter.addImport(argType, ast);
    }

    private void createFactoryMethodConstructorArgs(AST ast, ClassInstanceCreation newCtorCall) {
        List argList = newCtorCall.arguments();
        int i = 0;
        while (i < this.fArgTypes.length) {
            SimpleName ctorArg = ast.newSimpleName(this.fFormalArgNames[i]);
            argList.add(ctorArg);
            ++i;
        }
    }

    private FunctionInvocation createFactoryMethodCall(AST ast, ClassInstanceCreation ctorCall, ASTRewrite unitRewriter, TextEditGroup gd) {
        AbstractTypeDeclaration callOwner;
        ITypeBinding callOwnerBinding;
        FunctionInvocation factoryMethodCall = ast.newFunctionInvocation();
        List actualFactoryArgs = factoryMethodCall.arguments();
        List actualCtorArgs = ctorCall.arguments();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((callOwnerBinding = (callOwner = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)ctorCall, clazz)).resolveBinding()) == null || !Bindings.equals((IBinding)callOwner.resolveBinding(), (IBinding)this.fFactoryOwningClass.resolveBinding())) {
            String qualifier = this.fImportRewriter.addImport(this.fFactoryOwningClass.resolveBinding());
            factoryMethodCall.setExpression((Expression)ASTNodeFactory.newName(ast, qualifier));
        }
        factoryMethodCall.setName(ast.newSimpleName(this.fNewMethodName));
        int i = 0;
        while (i < actualCtorArgs.size()) {
            Expression actualCtorArg = (Expression)actualCtorArgs.get(i);
            ASTNode movedArg = unitRewriter.createMoveTarget((ASTNode)actualCtorArg);
            actualFactoryArgs.add(movedArg);
            ++i;
        }
        unitRewriter.replace((ASTNode)ctorCall, (ASTNode)factoryMethodCall, gd);
        return factoryMethodCall;
    }

    private boolean isConstructorUnit(IJavaScriptUnit unit) {
        return unit.equals(ASTCreator.getCu((ASTNode)this.fCtorOwningClass));
    }

    private boolean shouldProtectConstructor() {
        return this.fProtectConstructor && this.fCtorOwningClass != null;
    }

    private boolean protectConstructor(JavaScriptUnit unitAST, ASTRewrite unitRewriter, TextEditGroup declGD) {
        FunctionDeclaration constructor = (FunctionDeclaration)unitAST.findDeclaringNode(this.fCtorBinding.getKey());
        if (constructor == null || JdtFlags.getVisibilityCode((BodyDeclaration)constructor) == this.fConstructorVisibility) {
            return false;
        }
        ModifierRewrite.create(unitRewriter, (ASTNode)constructor).setVisibility(this.fConstructorVisibility, declGD);
        return true;
    }

    private boolean addAllChangesFor(SearchResultGroup rg, IJavaScriptUnit unitHandle, CompilationUnitChange unitChange) throws CoreException {
        TextEditGroup declGD;
        Assert.isTrue((rg == null || rg.getCompilationUnit() == unitHandle ? 1 : 0) != 0);
        JavaScriptUnit unit = this.getASTFor(unitHandle);
        ASTRewrite unitRewriter = ASTRewrite.create((AST)unit.getAST());
        MultiTextEdit root = new MultiTextEdit();
        boolean someChange = false;
        unitChange.setEdit((TextEdit)root);
        this.fImportRewriter = StubUtility.createImportRewrite(unit, true);
        if (unitHandle.equals(this.fFactoryUnitHandle)) {
            TextEditGroup factoryGD = new TextEditGroup(RefactoringCoreMessages.IntroduceFactory_addFactoryMethod);
            this.createFactoryChange(unitRewriter, unit, factoryGD);
            unitChange.addTextEditGroup(factoryGD);
            someChange = true;
        }
        if (rg != null && this.replaceConstructorCalls(rg, unit, unitRewriter, unitChange)) {
            someChange = true;
        }
        if (this.shouldProtectConstructor() && this.isConstructorUnit(unitHandle) && this.protectConstructor(unit, unitRewriter, declGD = new TextEditGroup(RefactoringCoreMessages.IntroduceFactory_protectConstructor))) {
            unitChange.addTextEditGroup(declGD);
            someChange = true;
        }
        if (someChange) {
            root.addChild(unitRewriter.rewriteAST());
            root.addChild(this.fImportRewriter.rewriteImports(null));
        }
        return someChange;
    }

    private JavaScriptUnit getASTFor(IJavaScriptUnit unitHandle) {
        if (unitHandle.equals(this.fCUHandle)) {
            if (this.fCU == null) {
                this.fCU = ASTCreator.createAST(unitHandle, null);
                if (this.fCU.equals((Object)this.fFactoryUnitHandle)) {
                    this.fFactoryCU = this.fCU;
                }
            }
            return this.fCU;
        }
        if (unitHandle.equals(this.fFactoryUnitHandle)) {
            if (this.fFactoryCU == null) {
                this.fFactoryCU = ASTCreator.createAST(unitHandle, null);
            }
            return this.fFactoryCU;
        }
        return ASTCreator.createAST(unitHandle, null);
    }

    private boolean replaceConstructorCalls(SearchResultGroup rg, JavaScriptUnit unit, ASTRewrite unitRewriter, CompilationUnitChange unitChange) throws CoreException {
        Assert.isTrue((boolean)ASTCreator.getCu((ASTNode)unit).equals(rg.getCompilationUnit()));
        SearchMatch[] hits = rg.getSearchResults();
        AST ctorCallAST = unit.getAST();
        boolean someCallPatched = false;
        int i = 0;
        while (i < hits.length) {
            ClassInstanceCreation creation = this.getCtorCallAt(hits[i].getOffset(), hits[i].getLength(), unit);
            if (creation != null) {
                TextEditGroup gd = new TextEditGroup(RefactoringCoreMessages.IntroduceFactory_replaceCalls);
                this.createFactoryMethodCall(ctorCallAST, creation, unitRewriter, gd);
                unitChange.addTextEditGroup(gd);
                someCallPatched = true;
            }
            ++i;
        }
        return someCallPatched;
    }

    private ClassInstanceCreation getCtorCallAt(int start, int length, JavaScriptUnit unitAST) throws CoreException {
        IJavaScriptUnit unitHandle = ASTCreator.getCu((ASTNode)unitAST);
        ASTNode node = NodeFinder.perform((ASTNode)unitAST, start, length);
        if (node == null) {
            throw new CoreException(JavaUIStatus.createError(4, Messages.format(RefactoringCoreMessages.IntroduceFactory_noASTNodeForConstructorSearchHit, new Object[]{Integer.toString(start), Integer.toString(start + length), unitHandle.getSource().substring(start, start + length), unitHandle.getElementName()}), null));
        }
        if (node instanceof ClassInstanceCreation) {
            return (ClassInstanceCreation)node;
        }
        if (node instanceof VariableDeclaration) {
            Expression init = ((VariableDeclaration)node).getInitializer();
            if (init instanceof ClassInstanceCreation) {
                return (ClassInstanceCreation)init;
            }
            if (init != null) {
                throw new CoreException(JavaUIStatus.createError(4, Messages.format(RefactoringCoreMessages.IntroduceFactory_unexpectedInitializerNodeType, new Object[]{init.toString(), unitHandle.getElementName()}), null));
            }
            throw new CoreException(JavaUIStatus.createError(4, Messages.format(RefactoringCoreMessages.IntroduceFactory_noConstructorCallNodeInsideFoundVarbleDecl, new Object[]{node.toString()}), null));
        }
        if (node instanceof ConstructorInvocation) {
            return null;
        }
        if (node instanceof SuperConstructorInvocation) {
            this.fConstructorVisibility = 4;
            return null;
        }
        if (node instanceof ExpressionStatement) {
            Expression expr = ((ExpressionStatement)node).getExpression();
            if (expr instanceof ClassInstanceCreation) {
                return (ClassInstanceCreation)expr;
            }
            throw new CoreException(JavaUIStatus.createError(4, Messages.format(RefactoringCoreMessages.IntroduceFactory_unexpectedASTNodeTypeForConstructorSearchHit, new Object[]{expr.toString(), unitHandle.getElementName()}), null));
        }
        if (node instanceof SimpleName && (node.getParent() instanceof FunctionDeclaration || node.getParent() instanceof AbstractTypeDeclaration)) {
            this.fConstructorVisibility = 4;
            return null;
        }
        throw new CoreException(JavaUIStatus.createError(4, Messages.format(RefactoringCoreMessages.IntroduceFactory_unexpectedASTNodeTypeForConstructorSearchHit, new Object[]{String.valueOf(node.getClass().getName()) + "('" + node.toString() + "')", unitHandle.getElementName()}), null));
    }

    private void createFactoryChange(ASTRewrite unitRewriter, JavaScriptUnit unit, TextEditGroup gd) {
        AST ast = unit.getAST();
        this.fFactoryMethod = this.createFactoryMethod(ast, this.fCtorBinding, unitRewriter);
        AbstractTypeDeclaration factoryOwner = (AbstractTypeDeclaration)unit.findDeclaringNode(this.fFactoryOwningClass.resolveBinding().getKey());
        this.fImportRewriter.addImport(this.fCtorOwningClass.resolveBinding());
        int idx = ASTNodes.getInsertionIndex((BodyDeclaration)this.fFactoryMethod, factoryOwner.bodyDeclarations());
        if (idx < 0) {
            idx = 0;
        }
        unitRewriter.getListRewrite((ASTNode)factoryOwner, factoryOwner.getBodyDeclarationsProperty()).insertAt((ASTNode)this.fFactoryMethod, idx, gd);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        DynamicValidationRefactoringChange dynamicValidationRefactoringChange;
        try {
            pm.beginTask(RefactoringCoreMessages.IntroduceFactory_createChanges, this.fAllCallsTo.length);
            ITypeBinding binding = this.fFactoryOwningClass.resolveBinding();
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IJavaScriptProject javaProject = this.fCUHandle.getJavaScriptProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 589830;
            if (binding.isNested() && !binding.isMember()) {
                flags |= 0x40000;
            }
            String description = Messages.format(RefactoringCoreMessages.IntroduceFactoryRefactoring_descriptor_description_short, this.fCtorOwningClass.getName());
            String header = Messages.format(RefactoringCoreMessages.IntroduceFactory_descriptor_description, new String[]{this.fNewMethodName, BindingLabelProvider.getBindingLabel((IBinding)binding, JavaScriptElementLabels.ALL_FULLY_QUALIFIED), BindingLabelProvider.getBindingLabel((IBinding)this.fCtorBinding, JavaScriptElementLabels.ALL_FULLY_QUALIFIED)});
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceFactoryRefactoring_original_pattern, BindingLabelProvider.getBindingLabel((IBinding)this.fCtorBinding, JavaScriptElementLabels.ALL_FULLY_QUALIFIED)));
            comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceFactoryRefactoring_factory_pattern, this.fNewMethodName));
            comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceFactoryRefactoring_owner_pattern, BindingLabelProvider.getBindingLabel((IBinding)binding, JavaScriptElementLabels.ALL_FULLY_QUALIFIED)));
            if (this.fProtectConstructor) {
                comment.addSetting(RefactoringCoreMessages.IntroduceFactoryRefactoring_declare_private);
            }
            JDTRefactoringDescriptor descriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.introduce.factory", project, description, comment.asString(), arguments, flags);
            arguments.put("input", descriptor.elementToHandle((IJavaScriptElement)this.fCUHandle));
            arguments.put("name", this.fNewMethodName);
            arguments.put("element1", descriptor.elementToHandle(binding.getJavaElement()));
            arguments.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
            arguments.put(ATTRIBUTE_PROTECT, Boolean.valueOf(this.fProtectConstructor).toString());
            DynamicValidationRefactoringChange result = new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.IntroduceFactory_name);
            boolean hitInFactoryClass = false;
            boolean hitInCtorClass = false;
            int i = 0;
            while (i < this.fAllCallsTo.length) {
                CompilationUnitChange cuChange;
                SearchResultGroup rg = this.fAllCallsTo[i];
                IJavaScriptUnit unitHandle = rg.getCompilationUnit();
                if (this.addAllChangesFor(rg, unitHandle, cuChange = new CompilationUnitChange(this.getName(), unitHandle))) {
                    result.add((Change)cuChange);
                }
                if (unitHandle.equals(this.fFactoryUnitHandle)) {
                    hitInFactoryClass = true;
                }
                if (unitHandle.equals(ASTCreator.getCu((ASTNode)this.fCtorOwningClass))) {
                    hitInCtorClass = true;
                }
                pm.worked(1);
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
            if (!hitInFactoryClass) {
                CompilationUnitChange cuChange = new CompilationUnitChange(this.getName(), this.fFactoryUnitHandle);
                this.addAllChangesFor(null, this.fFactoryUnitHandle, cuChange);
                result.add((Change)cuChange);
            }
            if (!hitInCtorClass && !this.fFactoryUnitHandle.equals(ASTCreator.getCu((ASTNode)this.fCtorOwningClass))) {
                CompilationUnitChange cuChange = new CompilationUnitChange(this.getName(), ASTCreator.getCu((ASTNode)this.fCtorOwningClass));
                this.addAllChangesFor(null, ASTCreator.getCu((ASTNode)this.fCtorOwningClass), cuChange);
                result.add((Change)cuChange);
            }
            dynamicValidationRefactoringChange = result;
            Object var18_21 = null;
        }
        catch (Throwable throwable) {
            Object var18_22 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return dynamicValidationRefactoringChange;
    }

    public String getName() {
        return RefactoringCoreMessages.IntroduceFactory_name;
    }

    public String getNewMethodName() {
        return this.fNewMethodName;
    }

    public RefactoringStatus setNewMethodName(String newMethodName) {
        Assert.isNotNull((Object)newMethodName);
        this.fNewMethodName = newMethodName;
        RefactoringStatus stat = Checks.checkMethodName(newMethodName);
        stat.merge(this.isUniqueMethodName(newMethodName));
        return stat;
    }

    private RefactoringStatus isUniqueMethodName(String methodName) {
        boolean conflict = this.hasMethod(this.fFactoryOwningClass, methodName);
        return conflict ? RefactoringStatus.createErrorStatus((String)(String.valueOf(RefactoringCoreMessages.IntroduceFactory_duplicateMethodName) + methodName)) : new RefactoringStatus();
    }

    private boolean hasMethod(AbstractTypeDeclaration type, String name) {
        List decls = type.bodyDeclarations();
        Iterator iter = decls.iterator();
        while (iter.hasNext()) {
            BodyDeclaration decl = (BodyDeclaration)iter.next();
            if (!(decl instanceof FunctionDeclaration) || !((FunctionDeclaration)decl).getName().getIdentifier().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean canProtectConstructor() {
        return this.fFactoryCU.findDeclaringNode(this.fCtorBinding.getKey()) != null;
    }

    public void setProtectConstructor(boolean protectConstructor) {
        this.fProtectConstructor = protectConstructor;
    }

    public IJavaScriptProject getProject() {
        return this.fCUHandle.getJavaScriptProject();
    }

    public RefactoringStatus setFactoryClass(String fullyQualifiedTypeName) {
        IType factoryType;
        try {
            factoryType = this.findFactoryClass(fullyQualifiedTypeName);
            if (factoryType == null) {
                return RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.IntroduceFactory_noSuchClass, fullyQualifiedTypeName));
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_cantCheckForInterface);
        }
        IJavaScriptUnit factoryUnitHandle = factoryType.getJavaScriptUnit();
        if (factoryType.isBinary()) {
            return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_cantPutFactoryInBinaryClass);
        }
        try {
            String ctorPkg;
            if (!this.fFactoryUnitHandle.equals(factoryUnitHandle)) {
                this.fFactoryCU = this.getASTFor(factoryUnitHandle);
                this.fFactoryUnitHandle = factoryUnitHandle;
            }
            ASTNode aSTNode = NodeFinder.perform((ASTNode)this.fFactoryCU, factoryType.getNameRange());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fFactoryOwningClass = (AbstractTypeDeclaration)ASTNodes.getParent(aSTNode, clazz);
            String factoryPkg = factoryType.getPackageFragment().getElementName();
            if (!factoryPkg.equals(ctorPkg = this.fCtorOwningClass.resolveBinding().getPackage().getName())) {
                this.fConstructorVisibility = 1;
            } else if (this.fFactoryOwningClass != this.fCtorOwningClass) {
                this.fConstructorVisibility = 0;
            }
            if (this.fFactoryOwningClass != this.fCtorOwningClass) {
                this.fConstructorVisibility = 0;
            }
        }
        catch (JavaScriptModelException e) {
            return RefactoringStatus.createFatalErrorStatus((String)e.getMessage());
        }
        return new RefactoringStatus();
    }

    private IType findFactoryClass(String fullyQualifiedTypeName) throws JavaScriptModelException {
        IType factoryType = this.getProject().findType(fullyQualifiedTypeName);
        if (factoryType == null) {
            factoryType = this.findNonPrimaryType(fullyQualifiedTypeName, (IProgressMonitor)new NullProgressMonitor(), new RefactoringStatus());
        }
        return factoryType;
    }

    public String getFactoryClassName() {
        return this.fFactoryOwningClass.resolveBinding().getQualifiedName();
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String protect;
        if (arguments instanceof JavaRefactoringArguments) {
            IJavaScriptElement element;
            int length;
            int offset;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String selection = extended.getAttribute("selection");
            if (selection != null) {
                offset = -1;
                length = -1;
                StringTokenizer tokenizer = new StringTokenizer(selection);
                if (tokenizer.hasMoreTokens()) {
                    offset = Integer.valueOf(tokenizer.nextToken());
                }
                if (tokenizer.hasMoreTokens()) {
                    length = Integer.valueOf(tokenizer.nextToken());
                }
                if (offset < 0 || length < 0) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
            }
            this.fSelectionStart = offset;
            this.fSelectionLength = length;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 5) {
                    return this.createInputFatalStatus(element, "org.eclipse.wst.jsdt.ui.introduce.factory");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fCUHandle = (IJavaScriptUnit)element;
            this.initialize();
            handle = extended.getAttribute("element1");
            if (handle != null) {
                element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 7) {
                    return this.createInputFatalStatus(element, "org.eclipse.wst.jsdt.ui.introduce.factory");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            IType type = (IType)element;
            this.fFactoryClassName = type.getFullyQualifiedName();
            String name = extended.getAttribute("name");
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            this.fNewMethodName = name;
            protect = extended.getAttribute(ATTRIBUTE_PROTECT);
            if (protect == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_PROTECT));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fProtectConstructor = Boolean.valueOf(protect);
        return new RefactoringStatus();
    }
}

