/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.actions;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Rel;
import org.eclipse.wst.ws.internal.explorer.platform.actions.NodeAction;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;

public abstract class ClearNodeAction
extends NodeAction {
    public ClearNodeAction(Controller controller, NodeManager nodeManager) {
        super(controller, nodeManager);
    }

    public boolean run() {
        int nodeId = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        if (!this.isStaleNode(nodeId)) {
            Node node = this.nodeManager_.getNode(nodeId);
            TreeElement element = node.getTreeElement();
            ArrayList elements2remove = new ArrayList();
            this.collectElements2Remove(element, elements2remove);
            for (TreeElement e : elements2remove) {
                e.getModel().removeElement((Element)e);
            }
            if (element.getModel().getRootElement() != element) {
                this.nodeManager_.removeFromNodeTable(nodeId);
            }
            MessageQueue messageQueue = this.controller_.getCurrentPerspective().getMessageQueue();
            messageQueue.addMessage(this.controller_.getMessage("MSG_INFO_NODE_CLEARED", node.getNodeName()));
            return true;
        }
        return false;
    }

    private void collectElements2Remove(TreeElement element, List elements2remove) {
        if (!elements2remove.contains((Object)element)) {
            if (element.getModel().getRootElement() != element) {
                elements2remove.add(element);
            }
            Enumeration rels = element.getRels();
            while (rels.hasMoreElements()) {
                Rel rel = (Rel)rels.nextElement();
                String relName = rel.getName();
                if ("owner".equals(relName)) continue;
                Enumeration children = element.getElements(rel.getName());
                while (children.hasMoreElements()) {
                    this.collectElements2Remove((TreeElement)((Object)children.nextElement()), elements2remove);
                }
            }
        }
    }

    public final String getActionLinkForHistory() {
        return null;
    }

    public abstract String getTreeContentVar();

    public abstract String getTreeContentPage();

    public abstract String getPropertiesContainerVar();

    public abstract String getPropertiesContainerPage();

    public abstract String getStatusContentVar();

    public abstract String getStatusContentPage();
}

