/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching;

import java.io.Serializable;
import org.eclipse.jpt.eclipselink.core.context.persistence.caching.CacheType;
import org.eclipse.jpt.eclipselink.core.context.persistence.caching.Caching;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.AbstractModel;

public class Entity
extends AbstractModel
implements Cloneable,
Serializable {
    private String name;
    private Caching parent;
    public static final String CACHE_TYPE_PROPERTY = "cacheType";
    public static final String CACHE_SIZE_PROPERTY = "cacheSize";
    public static final String SHARED_CACHE_PROPERTY = "sharedCache";
    private CacheType cacheType;
    private Integer cacheSize;
    private Boolean cacheIsShared;
    private static final long serialVersionUID = 1L;

    public Entity(Caching parent, String name) {
        this(parent);
        this.initialize(name);
    }

    private Entity(Caching parent) {
        this.parent = parent;
    }

    private void initialize(String name) {
        if (StringTools.stringIsEmpty((String)name)) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        Entity entity = (Entity)o;
        return (this.cacheType == null ? entity.cacheType == null : this.cacheType.equals((Object)entity.cacheType)) && (this.cacheIsShared == null ? entity.cacheIsShared == null : this.cacheIsShared.equals(entity.cacheIsShared)) && (this.cacheSize == null ? entity.cacheSize == null : this.cacheSize.equals(entity.cacheSize));
    }

    public Entity clone() {
        try {
            return (Entity)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean isEmpty() {
        return this.cacheType == null && this.cacheSize == null && this.cacheIsShared == null;
    }

    public boolean entityNameIsValid() {
        return !StringTools.stringIsEmpty((String)this.name);
    }

    public Caching getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    protected CacheType getCacheType() {
        return this.cacheType;
    }

    protected void setCacheType(CacheType cacheType) {
        CacheType old = this.cacheType;
        this.cacheType = cacheType;
        this.firePropertyChanged(CACHE_TYPE_PROPERTY, (Object)old, (Object)cacheType);
    }

    protected Integer getCacheSize() {
        return this.cacheSize;
    }

    protected void setCacheSize(Integer cacheSize) {
        Integer old = this.cacheSize;
        this.cacheSize = cacheSize;
        this.firePropertyChanged(CACHE_SIZE_PROPERTY, old, cacheSize);
    }

    protected Boolean cacheIsShared() {
        return this.cacheIsShared;
    }

    protected void setSharedCache(Boolean isShared) {
        Boolean old = this.cacheIsShared;
        this.cacheIsShared = isShared;
        this.firePropertyChanged(SHARED_CACHE_PROPERTY, old, isShared);
    }

    public void toString(StringBuilder sb) {
        sb.append("name: ");
        sb.append(this.name);
        sb.append(", cacheType: ");
        sb.append((Object)this.cacheType);
        sb.append(", cacheSize: ");
        sb.append(this.cacheSize);
        sb.append(", cacheIsShared: ");
        sb.append(this.cacheIsShared);
    }
}

