/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.annotations.initialization;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.initialization.AnnotationAttributeInitializer;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.utils.JAXWSUtils;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebParamAttributeInitializer
extends AnnotationAttributeInitializer {
    public List<MemberValuePair> getMemberValuePairs(IJavaElement javaElement, AST ast, Class<? extends Annotation> annotationClass) {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        if (javaElement.getElementType() == 14) {
            ILocalVariable parameter = (ILocalVariable)javaElement;
            MemberValuePair nameValuePair = AnnotationsCore.createStringMemberValuePair((AST)ast, (String)"name", (String)this.getName(parameter));
            memberValuePairs.add(nameValuePair);
        }
        return memberValuePairs;
    }

    public List<ICompletionProposal> getCompletionProposalsForMemberValuePair(IJavaElement javaElement, MemberValuePair memberValuePair) {
        ArrayList<ICompletionProposal> completionProposals = new ArrayList<ICompletionProposal>();
        if (javaElement.getElementType() == 14) {
            ILocalVariable parameter = (ILocalVariable)javaElement;
            String memberValuePairName = memberValuePair.getName().getIdentifier();
            if (memberValuePairName.equals("name")) {
                completionProposals.add((ICompletionProposal)this.createCompletionProposal(this.getName(parameter), memberValuePair.getValue()));
            }
            if (memberValuePairName.equals("partName")) {
                completionProposals.add((ICompletionProposal)this.createCompletionProposal(this.getPartName(parameter), memberValuePair.getValue()));
            }
            if (memberValuePairName.equals("targetNamespace")) {
                completionProposals.add((ICompletionProposal)this.createCompletionProposal(this.getTargetNamespace(parameter), memberValuePair.getValue()));
            }
        }
        return completionProposals;
    }

    private String getName(ILocalVariable parameter) {
        IMethod method = (IMethod)parameter.getParent();
        if (this.hasDocumentBareSOAPBinding((IJavaElement)method)) {
            return this.getWebMethodOperationName(method);
        }
        try {
            List<String> methodNames = Arrays.asList(method.getParameterNames());
            return "arg" + methodNames.indexOf(parameter.getElementName());
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
            return parameter.getElementName();
        }
    }

    private String getPartName(ILocalVariable parameter) {
        String name;
        org.eclipse.jdt.core.dom.Annotation annotation = AnnotationUtils.getAnnotation((IJavaElement)parameter, WebParam.class);
        if (annotation != null && (name = AnnotationUtils.getStringValue((org.eclipse.jdt.core.dom.Annotation)annotation, (String)"name")) != null) {
            return name;
        }
        return this.getName(parameter);
    }

    private String getTargetNamespace(ILocalVariable parameter) {
        if (this.hasDocumentWrappedSOAPBinding(parameter) && !this.isHeader(parameter)) {
            return "";
        }
        return this.getDefaultTargetNamespace(parameter);
    }

    private String getDefaultTargetNamespace(ILocalVariable parameter) {
        String targetNamespace;
        IMethod method = (IMethod)parameter.getParent();
        IType type = method.getDeclaringType();
        org.eclipse.jdt.core.dom.Annotation annotation = AnnotationUtils.getAnnotation((IJavaElement)type, WebService.class);
        if (annotation != null && (targetNamespace = AnnotationUtils.getStringValue((org.eclipse.jdt.core.dom.Annotation)annotation, (String)"targetNamespace")) != null) {
            return targetNamespace;
        }
        return JDTUtils.getTargetNamespaceFromPackageName((String)type.getPackageFragment().getElementName());
    }

    private boolean isHeader(ILocalVariable parameter) {
        Boolean header;
        org.eclipse.jdt.core.dom.Annotation annotation = AnnotationUtils.getAnnotation((IJavaElement)parameter, WebParam.class);
        if (annotation != null && (header = AnnotationUtils.getBooleanValue((org.eclipse.jdt.core.dom.Annotation)annotation, (String)"header")) != null) {
            return header;
        }
        return false;
    }

    private boolean hasDocumentWrappedSOAPBinding(ILocalVariable parameter) {
        IMethod method = (IMethod)parameter.getParent();
        org.eclipse.jdt.core.dom.Annotation annotation = AnnotationUtils.getAnnotation((IJavaElement)method, SOAPBinding.class);
        if (annotation != null) {
            return JAXWSUtils.isDocumentWrapped((org.eclipse.jdt.core.dom.Annotation)annotation);
        }
        org.eclipse.jdt.core.dom.Annotation typeAnnotation = AnnotationUtils.getAnnotation((IJavaElement)method.getDeclaringType(), SOAPBinding.class);
        if (typeAnnotation != null) {
            return JAXWSUtils.isDocumentWrapped((org.eclipse.jdt.core.dom.Annotation)typeAnnotation);
        }
        return true;
    }

    private boolean hasDocumentBareSOAPBinding(IJavaElement javaElement) {
        org.eclipse.jdt.core.dom.Annotation annotation = AnnotationUtils.getAnnotation((IJavaElement)javaElement, SOAPBinding.class);
        if (annotation != null) {
            return JAXWSUtils.isDocumentBare((org.eclipse.jdt.core.dom.Annotation)annotation);
        }
        if (javaElement.getElementType() == 9) {
            IMethod method = (IMethod)javaElement;
            return this.hasDocumentBareSOAPBinding((IJavaElement)method.getDeclaringType());
        }
        return false;
    }

    private String getWebMethodOperationName(IMethod method) {
        String operationName;
        org.eclipse.jdt.core.dom.Annotation annotation = AnnotationUtils.getAnnotation((IJavaElement)method, WebMethod.class);
        if (annotation != null && (operationName = AnnotationUtils.getStringValue((org.eclipse.jdt.core.dom.Annotation)annotation, (String)"operationName")) != null) {
            return operationName;
        }
        return method.getElementName();
    }
}

