/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.views.contentoutline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.dtd.core.internal.Attribute;
import org.eclipse.wst.dtd.core.internal.AttributeList;
import org.eclipse.wst.dtd.core.internal.Comment;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.Element;
import org.eclipse.wst.dtd.core.internal.Entity;
import org.eclipse.wst.dtd.core.internal.NodeList;
import org.eclipse.wst.dtd.core.internal.Notation;
import org.eclipse.wst.dtd.core.internal.ParameterEntityReference;
import org.eclipse.wst.dtd.core.internal.document.DTDModelImpl;
import org.eclipse.wst.dtd.core.internal.event.IDTDFileListener;
import org.eclipse.wst.dtd.core.internal.event.NodesEvent;
import org.w3c.dom.Node;

class DTDTreeContentProvider
implements ITreeContentProvider,
IDTDFileListener {
    private Object fInputObject;
    protected Viewer fViewer;
    protected Object[] logicalNodeLists = null;
    private boolean showLogicalOrder = false;

    public void dispose() {
        this.fViewer = null;
    }

    private void expandToNode(DTDNode node) {
        DTDFile dtdFile = node.getDTDFile();
        AbstractTreeViewer viewer = (AbstractTreeViewer)this.fViewer;
        viewer.expandToLevel((Object)dtdFile, 1);
        NodeList listToExpand = null;
        if (node instanceof Element || node instanceof ParameterEntityReference) {
            listToExpand = dtdFile.getElementsAndParameterEntityReferences();
        } else if (node instanceof Notation) {
            listToExpand = dtdFile.getNotations();
        } else if (node instanceof Entity) {
            listToExpand = dtdFile.getEntities();
        } else if (node instanceof Comment) {
            listToExpand = dtdFile.getComments();
        }
        if (listToExpand != null) {
            viewer.expandToLevel((Object)listToExpand, 1);
        }
        viewer.expandToLevel((Object)node, 0);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof DTDFile) {
            if (this.isShowLogicalOrder()) {
                if (this.logicalNodeLists == null) {
                    Iterator nodeLists = ((DTDFile)parentElement).getNodeLists().iterator();
                    ArrayList<NodeList> visibleLists = new ArrayList<NodeList>(7);
                    while (nodeLists.hasNext()) {
                        NodeList list = (NodeList)nodeLists.next();
                        if (!this.isVisibleNodeList(list)) continue;
                        visibleLists.add(list);
                    }
                    this.logicalNodeLists = visibleLists.toArray();
                }
                return this.logicalNodeLists;
            }
            List allNodes = ((DTDFile)parentElement).getNodes();
            ArrayList visibleNodes = new ArrayList(allNodes.size());
            int i = 0;
            while (i < allNodes.size()) {
                Object o = allNodes.get(i);
                if (this.isVisibleNode(o)) {
                    visibleNodes.add(o);
                }
                ++i;
            }
            return visibleNodes.toArray();
        }
        if (parentElement instanceof NodeList) {
            return ((NodeList)parentElement).getNodes().toArray();
        }
        if (parentElement instanceof Element) {
            Object[] children = ((DTDNode)parentElement).getChildren();
            List attributes = ((Element)parentElement).getElementAttributes();
            Object[] logicalChildren = new Object[children.length + attributes.size()];
            int index = 0;
            index = 0;
            while (index < children.length) {
                logicalChildren[index] = children[index];
                ++index;
            }
            Iterator iter = attributes.iterator();
            while (iter.hasNext()) {
                logicalChildren[index++] = iter.next();
            }
            return logicalChildren;
        }
        if (parentElement instanceof DTDNode) {
            return ((DTDNode)parentElement).getChildren();
        }
        return Collections.EMPTY_LIST.toArray();
    }

    public Object[] getElements(Object inputElement) {
        Object[] elements = null;
        if (inputElement instanceof DTDModelImpl) {
            elements = new Object[]{((DTDModelImpl)inputElement).getDTDFile()};
        }
        if (elements == null) {
            elements = new Object[]{};
        }
        return elements;
    }

    public Object getParent(Object element) {
        Object parent = null;
        if (element instanceof DTDNode) {
            DTDNode node = (DTDNode)element;
            if (element instanceof Attribute && (parent = node.getParentNode()) != null && parent instanceof AttributeList) {
                return this.getParent(parent);
            }
            if (element instanceof AttributeList) {
                String attListName = ((AttributeList)element).getName();
                Iterator iter = node.getDTDFile().getElementsAndParameterEntityReferences().getNodes().iterator();
                while (iter.hasNext() && parent == null) {
                    DTDNode currentNode = (DTDNode)iter.next();
                    if (!(currentNode instanceof Element) || !currentNode.getName().equals(attListName)) continue;
                    parent = currentNode;
                }
            }
            if (parent == null) {
                parent = ((DTDNode)element).getParentNode();
            }
            if (parent == null) {
                if (this.isShowLogicalOrder()) {
                    Object[] indexedNodeLists = this.getChildren(((DTDModelImpl)this.fInputObject).getDTDFile());
                    int i = 0;
                    while (i < indexedNodeLists.length && parent == null) {
                        if (indexedNodeLists[i] instanceof NodeList && ((NodeList)indexedNodeLists[i]).getNodes().contains(element)) {
                            parent = indexedNodeLists[i];
                        }
                        ++i;
                    }
                } else {
                    parent = ((DTDModelImpl)this.fInputObject).getDTDFile();
                }
            }
        } else if (element instanceof NodeList && this.fInputObject instanceof DTDModelImpl) {
            parent = ((DTDModelImpl)this.fInputObject).getDTDFile();
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children.length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = viewer;
        if (this.fInputObject instanceof DTDModelImpl) {
            ((DTDModelImpl)this.fInputObject).getDTDFile().removeDTDFileListener((IDTDFileListener)this);
        }
        this.fInputObject = newInput;
        if (this.fInputObject instanceof DTDModelImpl) {
            ((DTDModelImpl)this.fInputObject).getDTDFile().addDTDFileListener((IDTDFileListener)this);
        }
    }

    public boolean isShowLogicalOrder() {
        return this.showLogicalOrder;
    }

    private boolean isVisibleNode(Object o) {
        return !(o instanceof AttributeList);
    }

    private boolean isVisibleNodeList(NodeList nodeList) {
        return true;
    }

    public void nodeChanged(final DTDNode node) {
        if (this.fViewer instanceof StructuredViewer) {
            if (node instanceof AttributeList && this.isShowLogicalOrder()) {
                Iterator iter = node.getDTDFile().getNodes().iterator();
                while (iter.hasNext()) {
                    DTDNode currentNode = (DTDNode)iter.next();
                    if (!currentNode.getName().equals(node.getName()) || !(currentNode instanceof Element)) continue;
                    ((StructuredViewer)this.fViewer).refresh((Object)currentNode, true);
                }
            } else {
                this.fViewer.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (DTDTreeContentProvider.this.fViewer.getControl().isDisposed()) {
                            return;
                        }
                        if (node.getParentNode() != null) {
                            ((StructuredViewer)DTDTreeContentProvider.this.fViewer).refresh((Object)node.getParentNode(), true);
                        }
                        ((StructuredViewer)DTDTreeContentProvider.this.fViewer).refresh((Object)node, true);
                    }
                });
            }
            if (node instanceof Attribute) {
                this.fViewer.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (DTDTreeContentProvider.this.fViewer.getControl().isDisposed()) {
                            return;
                        }
                        Node attrList = node.getParentNode();
                        if (attrList != null && attrList instanceof AttributeList) {
                            String attListName = ((AttributeList)attrList).getName();
                            Iterator iter = node.getDTDFile().getElementsAndParameterEntityReferences().getNodes().iterator();
                            DTDNode parent = null;
                            while (iter.hasNext() && parent == null) {
                                DTDNode currentNode = (DTDNode)iter.next();
                                if (!(currentNode instanceof Element) || !currentNode.getName().equals(attListName)) continue;
                                parent = currentNode;
                            }
                            if (parent != null) {
                                ((StructuredViewer)DTDTreeContentProvider.this.fViewer).refresh(parent, true);
                            }
                        }
                    }
                });
            }
        }
    }

    public void nodesAdded(NodesEvent event) {
        if (this.fViewer instanceof AbstractTreeViewer) {
            StructuredViewer viewer = (StructuredViewer)this.fViewer;
            ISelection selection = viewer.getSelection();
            Object firstObj = !selection.isEmpty() && selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).getFirstElement() : null;
            DTDNode oldSelectedNode = null;
            if (firstObj instanceof DTDNode) {
                oldSelectedNode = (DTDNode)firstObj;
            }
            final AbstractTreeViewer abstractTreeViewer = (AbstractTreeViewer)this.fViewer;
            Iterator it = event.getNodes().iterator();
            block0: while (it.hasNext()) {
                Object node = it.next();
                final Object parent = this.getParent(node);
                if (parent instanceof DTDFile) {
                    Object[] objs = this.getChildren(parent);
                    int i = 0;
                    while (i < objs.length) {
                        if (objs[i] == node) {
                            abstractTreeViewer.insert(parent, node, i);
                            continue block0;
                        }
                        ++i;
                    }
                    continue;
                }
                if (parent != null) {
                    this.fViewer.getControl().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (DTDTreeContentProvider.this.fViewer.getControl().isDisposed()) {
                                return;
                            }
                            abstractTreeViewer.refresh(parent, true);
                        }
                    });
                    continue;
                }
                this.fViewer.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (DTDTreeContentProvider.this.fViewer.getControl().isDisposed()) {
                            return;
                        }
                        abstractTreeViewer.refresh(true);
                    }
                });
            }
            Iterator iter = event.getNodes().iterator();
            ArrayList<DTDNode> newSelection = new ArrayList<DTDNode>();
            while (iter.hasNext()) {
                DTDNode node = (DTDNode)iter.next();
                if (oldSelectedNode != null && node.getStructuredDTDDocumentRegion() == oldSelectedNode.getStructuredDTDDocumentRegion() && node.getStartOffset() == oldSelectedNode.getStartOffset() && node.getEndOffset() == oldSelectedNode.getEndOffset()) continue;
                newSelection.add(node);
                this.expandToNode(node);
            }
            if (newSelection.size() > 0) {
                viewer.setSelection((ISelection)new StructuredSelection(newSelection));
            }
        }
    }

    public void nodesRemoved(NodesEvent event) {
        if (this.fViewer instanceof AbstractTreeViewer) {
            AbstractTreeViewer abstractTreeViewer = (AbstractTreeViewer)this.fViewer;
            Iterator iter = event.getNodes().iterator();
            while (iter.hasNext()) {
                abstractTreeViewer.remove(iter.next());
            }
        }
    }

    public void setShowLogicalOrder(boolean value) {
        this.showLogicalOrder = value;
        if (!value) {
            this.logicalNodeLists = null;
        }
    }
}

