/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.pagedesigner.dtresourceprovider.DTResourceProviderFactory;
import org.eclipse.jst.pagedesigner.dtresourceprovider.DTSkinManager;
import org.eclipse.jst.pagedesigner.dtresourceprovider.IDTResourceProvider;
import org.eclipse.jst.pagedesigner.dtresourceprovider.IDTSkin;
import org.eclipse.jst.pagedesigner.utils.EditorUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinsMenuItemBuilder {
    private static final String DATAKEY_DTSKIN = "DATAKEY_DTSKIN";
    private static final String DATAKEY_NSURI = "DTATKEY_NSURI";
    private static List<Menu> menuList = new ArrayList<Menu>();
    private IProject project;

    public SkinsMenuItemBuilder(IProject project) {
        this.project = project;
    }

    public void buildMenuItems(Menu menu) {
        for (Menu oldMenu : menuList) {
            oldMenu.dispose();
        }
        if (menu != null) {
            List<TaglibData> taglibDataList = this.getTaglibDataList();
            if (taglibDataList.size() > 0) {
                new MenuItem(menu, 2);
            }
            for (TaglibData taglibData : taglibDataList) {
                String nsURI = taglibData.getNSURI();
                DTSkinManager dtSkinManager = DTSkinManager.getInstance(this.project);
                IDTSkin currentDTSkin = dtSkinManager.getCurrentSkin(nsURI);
                MenuItem menuItem = new MenuItem(menu, 64);
                menuItem.setText(taglibData.getName());
                Menu skinMenu = new Menu(menuItem);
                menuList.add(skinMenu);
                menuItem.setMenu(skinMenu);
                List<IDTSkin> dtSkins = dtSkinManager.getSkins(nsURI);
                for (IDTSkin dtSkin : dtSkins) {
                    MenuItem skinMenuItem;
                    if (currentDTSkin == dtSkin) {
                        skinMenuItem = new MenuItem(skinMenu, 32);
                        skinMenuItem.setSelection(true);
                    } else {
                        skinMenuItem = new MenuItem(skinMenu, 8);
                    }
                    skinMenuItem.setText(dtSkin.getName());
                    skinMenuItem.setData(DATAKEY_DTSKIN, (Object)dtSkin);
                    skinMenuItem.setData(DATAKEY_NSURI, (Object)nsURI);
                    skinMenuItem.addSelectionListener((SelectionListener)new SkinSelectionListener());
                }
            }
        }
    }

    public void buildMenuManagers(IMenuManager parent) {
        List<TaglibData> taglibDataList = this.getTaglibDataList();
        if (taglibDataList.size() > 0) {
            parent.appendToGroup("additions", (IContributionItem)new Separator());
        }
        for (TaglibData taglibData : taglibDataList) {
            String nsURI = taglibData.getNSURI();
            MenuManager newMgr = new MenuManager(taglibData.getName());
            DTSkinManager dtSkinManager = DTSkinManager.getInstance(this.project);
            IDTSkin currentDTSkin = dtSkinManager.getCurrentSkin(nsURI);
            List<IDTSkin> dtSkins = dtSkinManager.getSkins(nsURI);
            for (IDTSkin dtSkin : dtSkins) {
                newMgr.add((IAction)new ChangeCurrentSkinAction(nsURI, dtSkin, dtSkin == currentDTSkin));
            }
            parent.appendToGroup("additions", (IContributionItem)newMgr);
        }
    }

    private List<TaglibData> getTaglibDataList() {
        ArrayList<TaglibData> taglibDataList = new ArrayList<TaglibData>();
        List<IDTResourceProvider> dtResourceProviders = DTResourceProviderFactory.getInstance().getActiveDTResourceProviders(this.project);
        for (IDTResourceProvider dtResourceProvider : dtResourceProviders) {
            TaglibData taglibData = new TaglibData(dtResourceProvider.getId());
            if (taglibDataList.contains(taglibData)) continue;
            taglibDataList.add(taglibData);
        }
        return taglibDataList;
    }

    private class ChangeCurrentSkinAction
    extends Action {
        private String nsURI;
        private IDTSkin dtSkin;

        public ChangeCurrentSkinAction(String nsURI, IDTSkin dtSkin, boolean checked) {
            super(dtSkin.getName());
            this.nsURI = nsURI;
            this.dtSkin = dtSkin;
            this.setChecked(checked);
        }

        public void run() {
            DTSkinManager.getInstance(SkinsMenuItemBuilder.this.project).setCurrentSkin(this.nsURI, this.dtSkin);
            EditorUtil.refreshAllWPEDesignViewers();
        }
    }

    private class SkinSelectionListener
    implements SelectionListener {
        private SkinSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            String nsURI = (String)event.widget.getData(SkinsMenuItemBuilder.DATAKEY_NSURI);
            IDTSkin dtSkin = (IDTSkin)event.widget.getData(SkinsMenuItemBuilder.DATAKEY_DTSKIN);
            DTSkinManager.getInstance(SkinsMenuItemBuilder.this.project).setCurrentSkin(nsURI, dtSkin);
            EditorUtil.refreshAllWPEDesignViewers();
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }
    }

    private class TaglibData {
        private String nsURI;
        private String name;

        public TaglibData(String nsURI) {
            this.nsURI = nsURI;
            ITaglibDomainMetaDataModelContext modelContext = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)SkinsMenuItemBuilder.this.project, (String)nsURI);
            Model model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)modelContext);
            Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)model, (String)"display-label");
            this.name = TraitValueHelper.getValueAsString((Trait)trait);
        }

        public String getNSURI() {
            return this.nsURI;
        }

        public String getName() {
            if (this.name == null) {
                return this.nsURI;
            }
            return this.name;
        }

        public int hashCode() {
            int nsURIHashCode = 0;
            if (this.nsURI != null) {
                nsURIHashCode = this.nsURI.hashCode();
            }
            int nameHashCode = 0;
            if (this.name != null) {
                nameHashCode = this.name.hashCode();
            }
            return nameHashCode | nsURIHashCode;
        }
    }
}

