/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.properties.sections;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ui.internal.ISelectionMapper;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.asd.ASDEditorCSHelpIds;
import org.eclipse.wst.wsdl.ui.internal.asd.Messages;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IBinding;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IInterface;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IMessage;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.INamedObject;
import org.eclipse.wst.wsdl.ui.internal.asd.properties.sections.ASDAbstractSection;
import org.eclipse.wst.wsdl.ui.internal.refactor.handlers.RenameHandler;

public class NameSection
extends ASDAbstractSection
implements IHyperlinkListener {
    protected static final String NEW_STRING = Messages._UI_BUTTON_NEW;
    protected static final String BROWSE_STRING = Messages._UI_BUTTON_BROWSE;
    protected boolean isTraversing = false;
    CLabel nameLabel;
    protected Text nameText;
    protected ImageHyperlink renameHyperlink;
    private Composite lightBulbComposite;
    private Composite topComposite;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.topComposite = this.getWidgetFactory().createFlatFormComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.topComposite.setLayout((Layout)gridLayout);
        this.composite = this.getWidgetFactory().createComposite(this.topComposite);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.composite.setLayout((Layout)gridLayout);
        GridData data = new GridData(1808);
        this.composite.setLayoutData((Object)data);
        this.nameLabel = this.getWidgetFactory().createCLabel(this.composite, Messages._UI_LABEL_NAME);
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        this.nameLabel.setLayoutData((Object)data);
        this.nameText = this.getWidgetFactory().createText(this.composite, "");
        this.nameText.setLayoutData((Object)new GridData(768));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.nameText, ASDEditorCSHelpIds.PROPERTIES_NAME_TEXT);
        this.applyTextListeners((Control)this.nameText);
    }

    private void showRefactorButton() {
        if (this.isReadOnly) {
            return;
        }
        if (this.lightBulbComposite == null) {
            this.lightBulbComposite = this.getWidgetFactory().createComposite(this.topComposite);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            this.lightBulbComposite.setLayout((Layout)gridLayout);
            this.lightBulbComposite.setLayoutData((Object)new GridData(1, 1, false, false));
        }
        if (this.renameHyperlink == null) {
            this.renameHyperlink = this.getWidgetFactory().createImageHyperlink(this.lightBulbComposite, 0);
            this.renameHyperlink.setImage(WSDLEditorPlugin.getInstance().getImage("icons/quickassist.gif"));
            this.renameHyperlink.setToolTipText(Messages._UI_TOOLTIP_RENAME_REFACTOR);
            this.renameHyperlink.setLayoutData((Object)new GridData(1, 1, false, false));
            this.renameHyperlink.addHyperlinkListener((IHyperlinkListener)this);
        }
        this.renameHyperlink.setVisible(true);
    }

    private void hideRefactorButton() {
        if (this.isReadOnly) {
            return;
        }
        if (this.renameHyperlink == null) {
            return;
        }
        this.renameHyperlink.setVisible(false);
    }

    public void refresh() {
        super.refresh();
        if (this.nameText.isDisposed() || this.nameText.isFocusControl()) {
            return;
        }
        this.setListenerEnabled(false);
        String name = null;
        if (this.getModel() instanceof INamedObject) {
            name = ((INamedObject)this.getModel()).getName();
        } else if (this.getModel() instanceof EditPart) {
            Object model = ((EditPart)this.getModel()).getModel();
            name = ((INamedObject)model).getName();
        }
        if (name == null) {
            name = "";
        }
        this.nameText.setText(name);
        this.setControlForegroundColor((Control)this.nameText);
        if (this.canRefactor()) {
            this.showRefactorButton();
        } else {
            this.hideRefactorButton();
        }
        this.setListenerEnabled(true);
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    public void doHandleEvent(Event event) {
        if (event.widget == this.nameText && !this.nameText.isDisposed()) {
            String newValue = this.nameText.getText();
            Object model = this.getModel();
            INamedObject namedObject = null;
            if (model instanceof INamedObject) {
                namedObject = (INamedObject)model;
            }
            if (namedObject != null && !newValue.equals(namedObject.getName())) {
                Command command = namedObject.getSetNameCommand(newValue);
                this.executeCommand(command);
            }
        }
    }

    private void invokeRenameRefactoring() {
        ISelectionMapper mapper;
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.wsdl.Definition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Definition definition = (Definition)editor.getAdapter((Class)clazz);
        ISelection selection = editor.getSite().getSelectionProvider().getSelection();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.wst.wsdl.ui.internal.ISelectionMapper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        selection = (mapper = (ISelectionMapper)editor.getAdapter((Class)clazz2)) != null ? mapper.mapSelection(selection) : selection;
        RenameHandler renameHandler = new RenameHandler();
        renameHandler.execute(definition, selection);
    }

    private Object getRealModel() {
        Object realModel = this.getModel();
        if (realModel instanceof EditPart) {
            realModel = ((EditPart)this.getModel()).getModel();
        }
        return realModel;
    }

    private boolean canRefactor() {
        Object model = this.getRealModel();
        boolean canRefactor = model instanceof IMessage || model instanceof IBinding || model instanceof IInterface;
        return canRefactor;
    }

    public void linkActivated(HyperlinkEvent e) {
        this.invokeRenameRefactoring();
    }

    public void linkEntered(HyperlinkEvent e) {
    }

    public void linkExited(HyperlinkEvent e) {
    }

    protected boolean shouldPerformComboSelection(Event event, Object selectedItem) {
        boolean wasTraversing = this.isTraversing;
        if (this.isTraversing) {
            this.isTraversing = false;
        }
        if (event.type == 14) {
            if (!(selectedItem instanceof String)) {
                return false;
            }
            if (!BROWSE_STRING.equals(selectedItem) && !NEW_STRING.equals(selectedItem)) {
                return false;
            }
        }
        return !wasTraversing || !(selectedItem instanceof String) || !BROWSE_STRING.equals(selectedItem) && !NEW_STRING.equals(selectedItem);
    }
}

