/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaSequenceGenerator;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaGenerator;
import org.eclipse.jpt.core.resource.java.SequenceGeneratorAnnotation;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.utility.internal.iterables.FilteringIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaSequenceGenerator
extends AbstractJavaGenerator
implements JavaSequenceGenerator {
    protected String specifiedSequenceName;

    protected AbstractJavaSequenceGenerator(JavaJpaContextNode parent) {
        super(parent);
    }

    @Override
    public String getSequenceName() {
        return this.specifiedSequenceName != null ? this.specifiedSequenceName : this.getDefaultSequenceName();
    }

    @Override
    public String getSpecifiedSequenceName() {
        return this.specifiedSequenceName;
    }

    @Override
    public void setSpecifiedSequenceName(String specifiedSequenceName) {
        String old = this.specifiedSequenceName;
        this.specifiedSequenceName = specifiedSequenceName;
        this.getResourceGenerator().setSequenceName(specifiedSequenceName);
        this.firePropertyChanged("specifiedSequenceName", old, specifiedSequenceName);
    }

    protected void setSpecifiedSequenceName_(String specifiedSequenceName) {
        String old = this.specifiedSequenceName;
        this.specifiedSequenceName = specifiedSequenceName;
        this.firePropertyChanged("specifiedSequenceName", old, specifiedSequenceName);
    }

    @Override
    public String getDefaultSequenceName() {
        return null;
    }

    @Override
    public void initialize(SequenceGeneratorAnnotation resourceSequenceGenerator) {
        super.initialize(resourceSequenceGenerator);
        this.specifiedSequenceName = resourceSequenceGenerator.getSequenceName();
    }

    @Override
    public void update(SequenceGeneratorAnnotation resourceSequenceGenerator) {
        super.update(resourceSequenceGenerator);
        this.setSpecifiedSequenceName_(resourceSequenceGenerator.getSequenceName());
    }

    @Override
    public Iterator<String> connectedJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.connectedJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.sequenceNameTouches(pos, astRoot)) {
            return this.getJavaCandidateSequences(filter).iterator();
        }
        return null;
    }

    protected boolean sequenceNameTouches(int pos, CompilationUnit astRoot) {
        return this.getResourceGenerator().sequenceNameTouches(pos, astRoot);
    }

    protected Iterable<String> getJavaCandidateSequences(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateSequences(filter));
    }

    protected Iterable<String> getCandidateSequences(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateSequences(), filter);
    }

    protected Iterable<String> getCandidateSequences() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema != null ? dbSchema.getSortedSequenceIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public int getDefaultInitialValue() {
        return 1;
    }

    @Override
    protected SequenceGeneratorAnnotation getResourceGenerator() {
        return (SequenceGeneratorAnnotation)super.getResourceGenerator();
    }
}

