/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.CollectionMapping;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeMappingDefinition;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.jpa2.context.MetamodelField;
import org.eclipse.jpt.core.jpa2.context.java.JavaPersistentAttribute2_0;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.ClassName;
import org.eclipse.jpt.utility.internal.ReflectionTools;
import org.eclipse.jpt.utility.internal.Tools;
import org.eclipse.jpt.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.utility.internal.iterables.EmptyIterable;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaPersistentAttribute
extends AbstractJavaJpaContextNode
implements JavaPersistentAttribute2_0 {
    protected String name;
    protected JavaAttributeMapping defaultMapping;
    protected JavaAttributeMapping specifiedMapping;
    protected AccessType defaultAccess;
    protected JavaResourcePersistentAttribute resourcePersistentAttribute;
    protected static final String[] VALID_BASIC_ARRAY_ELEMENT_TYPE_NAMES = new String[]{Byte.TYPE.getName(), Character.TYPE.getName(), Byte.class.getName(), Character.class.getName()};
    protected static final String[] OTHER_VALID_BASIC_TYPE_NAMES = new String[]{String.class.getName(), BigInteger.class.getName(), BigDecimal.class.getName(), java.util.Date.class.getName(), Calendar.class.getName(), Date.class.getName(), Time.class.getName(), Timestamp.class.getName()};
    protected static final String SERIALIZABLE_TYPE_NAME = Serializable.class.getName();
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final Iterable<JavaPersistentAttribute.JpaContainer> JPA_CONTAINERS = new ArrayIterable((Object[])new JavaPersistentAttribute.JpaContainer[]{new CollectionJpaContainer(Collection.class, "javax.persistence.metamodel.CollectionAttribute"), new CollectionJpaContainer(Set.class, "javax.persistence.metamodel.SetAttribute"), new CollectionJpaContainer(List.class, "javax.persistence.metamodel.ListAttribute"), new MapJpaContainer(Map.class, "javax.persistence.metamodel.MapAttribute")});

    protected AbstractJavaPersistentAttribute(PersistentType parent, JavaResourcePersistentAttribute resourcePersistentAttribute) {
        super(parent);
        this.resourcePersistentAttribute = resourcePersistentAttribute;
        this.name = this.buildName();
        this.defaultMapping = this.buildDefaultMapping();
        this.specifiedMapping = this.buildSpecifiedMapping();
        this.defaultAccess = this.buildDefaultAccess();
    }

    @Override
    public void update() {
        this.setName(this.buildName());
        this.updateDefaultMapping();
        this.updateSpecifiedMapping();
        this.setDefaultAccess(this.buildDefaultAccess());
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        this.getMapping().postUpdate();
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.java.persistentAttribute";
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.getSelectionTextRange(this.buildASTRoot());
    }

    protected TextRange getSelectionTextRange(CompilationUnit astRoot) {
        return this.resourcePersistentAttribute.getNameTextRange(astRoot);
    }

    protected CompilationUnit buildASTRoot() {
        return this.resourcePersistentAttribute.getJavaResourceCompilationUnit().buildASTRoot();
    }

    @Override
    public void dispose() {
    }

    @Override
    public AccessType getAccess() {
        AccessType access = this.getSpecifiedAccess();
        return access != null ? access : this.getDefaultAccess();
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType defaultAccess) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = defaultAccess;
        this.firePropertyChanged("defaultAccess", (Object)old, (Object)defaultAccess);
    }

    protected AccessType buildDefaultAccess() {
        return this.resourcePersistentAttribute.isField() ? AccessType.FIELD : AccessType.PROPERTY;
    }

    @Override
    public JavaResourcePersistentAttribute getResourcePersistentAttribute() {
        return this.resourcePersistentAttribute;
    }

    @Override
    public PersistentType getOwningPersistentType() {
        return this.getParent();
    }

    @Override
    public TypeMapping getOwningTypeMapping() {
        return this.getOwningPersistentType().getMapping();
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.getMapping().getPrimaryKeyColumnName();
    }

    @Override
    public String getTypeName() {
        return this.resourcePersistentAttribute.getTypeName();
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean contains(int offset, CompilationUnit astRoot) {
        TextRange fullTextRange = this.getFullTextRange(astRoot);
        return fullTextRange == null ? false : fullTextRange.includes(offset);
    }

    protected TextRange getFullTextRange(CompilationUnit astRoot) {
        return this.resourcePersistentAttribute.getTextRange(astRoot);
    }

    @Override
    public Embeddable getEmbeddable() {
        return this.getTypeName() == null ? null : this.getPersistenceUnit().getEmbeddable(this.getTypeName());
    }

    @Override
    public boolean isField() {
        return this.resourcePersistentAttribute.isField();
    }

    @Override
    public boolean isProperty() {
        return this.resourcePersistentAttribute.isProperty();
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic((int)this.resourcePersistentAttribute.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal((int)this.resourcePersistentAttribute.getModifiers());
    }

    @Override
    public boolean typeIsBasic() {
        String typeName = this.getTypeName();
        if (typeName == null) {
            return false;
        }
        int arrayDepth = ReflectionTools.getArrayDepthForTypeDeclaration((String)typeName);
        if (arrayDepth > 1) {
            return false;
        }
        if (arrayDepth == 1) {
            String elementTypeName = ReflectionTools.getElementTypeNameForTypeDeclaration((String)typeName, (int)1);
            return this.elementTypeIsValidForBasicArray(elementTypeName);
        }
        if (ClassName.isVariablePrimitive((String)typeName)) {
            return true;
        }
        if (ClassName.isVariablePrimitiveWrapper((String)typeName)) {
            return true;
        }
        if (this.typeIsOtherValidBasicType(typeName)) {
            return true;
        }
        if (this.resourcePersistentAttribute.typeIsEnum()) {
            return true;
        }
        return this.resourcePersistentAttribute.typeIsSubTypeOf(SERIALIZABLE_TYPE_NAME);
    }

    protected boolean elementTypeIsValidForBasicArray(String elementTypeName) {
        return ArrayTools.contains((Object[])VALID_BASIC_ARRAY_ELEMENT_TYPE_NAMES, (Object)elementTypeName);
    }

    protected boolean typeIsOtherValidBasicType(String typeName) {
        return ArrayTools.contains((Object[])OTHER_VALID_BASIC_TYPE_NAMES, (Object)typeName);
    }

    @Override
    public String getSingleReferenceTargetTypeName() {
        String typeName = this.getTypeName();
        if (typeName == null) {
            return null;
        }
        if (ReflectionTools.getArrayDepthForTypeDeclaration((String)typeName) != 0) {
            return null;
        }
        if (this.typeIsContainer(typeName)) {
            return null;
        }
        return typeName;
    }

    @Override
    public String getMultiReferenceTargetTypeName() {
        return this.getJpaContainer().getMultiReferenceTargetTypeName(this.resourcePersistentAttribute);
    }

    @Override
    public String getMultiReferenceMapKeyTypeName() {
        return this.getJpaContainer().getMultiReferenceMapKeyTypeName(this.resourcePersistentAttribute);
    }

    protected boolean typeIsContainer(String typeName) {
        return this.getJpaContainer(typeName).isContainer();
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    protected String buildName() {
        return this.resourcePersistentAttribute.getName();
    }

    @Override
    public JavaAttributeMapping getMapping() {
        return this.specifiedMapping != null ? this.specifiedMapping : this.defaultMapping;
    }

    @Override
    public String getMappingKey() {
        return this.getMapping().getKey();
    }

    @Override
    public JavaAttributeMapping getDefaultMapping() {
        return this.defaultMapping;
    }

    protected void setDefaultMapping(JavaAttributeMapping defaultMapping) {
        JavaAttributeMapping old = this.defaultMapping;
        this.defaultMapping = defaultMapping;
        this.firePropertyChanged("defaultMapping", old, defaultMapping);
    }

    protected JavaAttributeMapping buildDefaultMapping() {
        JavaAttributeMappingDefinition mappingDefinition = this.getJpaPlatform().getDefaultJavaAttributeMappingDefinition(this);
        return this.buildDefaultMapping(mappingDefinition);
    }

    protected JavaAttributeMapping buildDefaultMapping(JavaAttributeMappingDefinition mappingDefinition) {
        Annotation annotation = this.resourcePersistentAttribute.buildNullAnnotation(mappingDefinition.getAnnotationName());
        JavaAttributeMapping mapping = mappingDefinition.buildMapping(this, this.getJpaFactory());
        mapping.initialize(annotation);
        return mapping;
    }

    @Override
    public String getDefaultMappingKey() {
        return this.defaultMapping.getKey();
    }

    @Override
    public boolean mappingIsDefault(JavaAttributeMapping mapping) {
        return this.defaultMapping == mapping;
    }

    protected void updateDefaultMapping() {
        JavaAttributeMappingDefinition mappingDefinition = this.getJpaPlatform().getDefaultJavaAttributeMappingDefinition(this);
        String mappingKey = mappingDefinition.getKey();
        if (this.valuesAreEqual(this.defaultMapping.getKey(), mappingKey)) {
            this.defaultMapping.update(this.resourcePersistentAttribute.buildNullAnnotation(mappingDefinition.getAnnotationName()));
        } else {
            this.setDefaultMapping(this.buildDefaultMapping(mappingDefinition));
        }
    }

    @Override
    public JavaAttributeMapping getSpecifiedMapping() {
        return this.specifiedMapping;
    }

    protected void setSpecifiedMapping(JavaAttributeMapping specifiedMapping) {
        JavaAttributeMapping old = this.specifiedMapping;
        this.specifiedMapping = specifiedMapping;
        this.firePropertyChanged("specifiedMapping", old, specifiedMapping);
    }

    protected JavaAttributeMapping buildSpecifiedMapping() {
        JavaAttributeMappingDefinition mappingDefinition = this.getJpaPlatform().getSpecifiedJavaAttributeMappingDefinition(this);
        return this.buildSpecifiedMapping(mappingDefinition);
    }

    protected JavaAttributeMapping buildSpecifiedMapping(JavaAttributeMappingDefinition mappingDefinition) {
        Annotation annotation = this.resourcePersistentAttribute.getAnnotation(mappingDefinition.getAnnotationName());
        JavaAttributeMapping mapping = mappingDefinition.buildMapping(this, this.getJpaFactory());
        if (mapping != null) {
            mapping.initialize(annotation);
        }
        return mapping;
    }

    protected String getSpecifiedMappingKey() {
        return this.specifiedMapping == null ? null : this.specifiedMapping.getKey();
    }

    @Override
    public void setSpecifiedMappingKey(String key) {
        JavaAttributeMapping newMapping;
        if (Tools.valuesAreEqual((Object)key, (Object)this.getSpecifiedMappingKey())) {
            return;
        }
        JavaAttributeMapping old = this.specifiedMapping;
        this.specifiedMapping = newMapping = this.buildMappingFromMappingKey(key);
        String newAnnotation = newMapping == null ? null : newMapping.getAnnotationName();
        JavaAttributeMapping mapping = newMapping == null ? this.defaultMapping : newMapping;
        this.resourcePersistentAttribute.setPrimaryAnnotation(newAnnotation, mapping.getSupportingAnnotationNames());
        this.firePropertyChanged("specifiedMapping", old, newMapping);
    }

    protected String getSpecifiedMappingAnnotationName() {
        return this.specifiedMapping == null ? null : this.specifiedMapping.getAnnotationName();
    }

    protected JavaAttributeMapping buildMappingFromMappingKey(String key) {
        JavaAttributeMappingDefinition mappingDefinition = this.getJpaPlatform().getSpecifiedJavaAttributeMappingDefinition(key);
        JavaAttributeMapping mapping = mappingDefinition.buildMapping(this, this.getJpaFactory());
        return mapping;
    }

    protected Iterable<String> getSupportingAnnotationNames() {
        JavaAttributeMapping mapping = this.getMapping();
        return mapping != null ? mapping.getSupportingAnnotationNames() : EmptyIterable.instance();
    }

    protected void updateSpecifiedMapping() {
        JavaAttributeMappingDefinition mappingDefinition = this.getJpaPlatform().getSpecifiedJavaAttributeMappingDefinition(this);
        String mappingKey = mappingDefinition.getKey();
        if (this.specifiedMapping != null && this.specifiedMapping.getKey().equals(mappingKey)) {
            this.specifiedMapping.update(this.resourcePersistentAttribute.getAnnotation(mappingDefinition.getAnnotationName()));
        } else {
            this.setSpecifiedMapping(this.buildSpecifiedMapping(mappingDefinition));
        }
    }

    @Override
    public PersistentType getParent() {
        return (PersistentType)super.getParent();
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.name);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getSelectionTextRange(astRoot);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateModifiers(messages, astRoot);
        if (this.specifiedMapping != null) {
            this.specifiedMapping.validate(messages, reporter, astRoot);
        } else if (this.defaultMapping != null) {
            this.defaultMapping.validate(messages, reporter, astRoot);
        }
    }

    protected void validateModifiers(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.getMappingKey() == "transient") {
            return;
        }
        if (this.isField()) {
            if (this.isFinal()) {
                messages.add(this.buildAttributeMessage("PERSISTENT_ATTRIBUTE_FINAL_FIELD", astRoot));
            }
            if (this.isPublic()) {
                messages.add(this.buildAttributeMessage("PERSISTENT_ATTRIBUTE_PUBLIC_FIELD", astRoot));
            }
        }
    }

    protected IMessage buildAttributeMessage(String msgID, CompilationUnit astRoot) {
        return DefaultJpaValidationMessages.buildMessage(1, msgID, new String[]{this.getName()}, this, this.getValidationTextRange(astRoot));
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return this.getMapping().javaCompletionProposals(pos, filter, astRoot);
    }

    @Override
    public String getMetamodelContainerFieldTypeName() {
        return this.getJpaContainer().getMetamodelContainerFieldTypeName();
    }

    @Override
    public String getMetamodelContainerFieldMapKeyTypeName() {
        return this.getJpaContainer().getMetamodelContainerFieldMapKeyTypeName((CollectionMapping)((Object)this.getMapping()));
    }

    @Override
    public String getMetamodelTypeName() {
        String typeName = this.getTypeName();
        if (typeName == null) {
            return MetamodelField.DEFAULT_TYPE_NAME;
        }
        if (ClassName.isPrimitive((String)typeName)) {
            return ClassName.getWrapperClassName((String)typeName);
        }
        return typeName;
    }

    @Override
    public JavaPersistentAttribute.JpaContainer getJpaContainer() {
        return this.getJpaContainer(this.resourcePersistentAttribute.getTypeName());
    }

    protected JavaPersistentAttribute.JpaContainer getJpaContainer(String typeName) {
        for (JavaPersistentAttribute.JpaContainer jpaContainer : JPA_CONTAINERS) {
            if (!jpaContainer.getTypeName().equals(typeName)) continue;
            return jpaContainer;
        }
        return JavaPersistentAttribute.JpaContainer.Null.instance();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AbstractJpaContainer
    implements JavaPersistentAttribute.JpaContainer {
        protected final String typeName;
        protected final String metamodelContainerFieldTypeName;

        protected AbstractJpaContainer(Class<?> containerClass, String metamodelContainerFieldTypeName) {
            this(containerClass.getName(), metamodelContainerFieldTypeName);
        }

        protected AbstractJpaContainer(String typeName, String metamodelContainerFieldTypeName) {
            if (typeName == null || metamodelContainerFieldTypeName == null) {
                throw new NullPointerException();
            }
            this.typeName = typeName;
            this.metamodelContainerFieldTypeName = metamodelContainerFieldTypeName;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public boolean isContainer() {
            return true;
        }

        @Override
        public String getMetamodelContainerFieldTypeName() {
            return this.metamodelContainerFieldTypeName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CollectionJpaContainer
    extends AbstractJpaContainer {
        protected CollectionJpaContainer(Class<?> collectionClass, String staticMetamodelTypeDeclarationTypeName) {
            super(collectionClass, staticMetamodelTypeDeclarationTypeName);
        }

        @Override
        public String getMultiReferenceTargetTypeName(JavaResourcePersistentAttribute resourcePersistentAttribute) {
            return resourcePersistentAttribute.typeTypeArgumentNamesSize() == 1 ? resourcePersistentAttribute.getTypeTypeArgumentName(0) : null;
        }

        @Override
        public String getMultiReferenceMapKeyTypeName(JavaResourcePersistentAttribute resourcePersistentAttribute) {
            return null;
        }

        @Override
        public String getMetamodelContainerFieldMapKeyTypeName(CollectionMapping mapping) {
            return null;
        }

        @Override
        public boolean isMap() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MapJpaContainer
    extends AbstractJpaContainer {
        protected MapJpaContainer(Class<?> mapClass, String staticMetamodelTypeDeclarationTypeName) {
            super(mapClass, staticMetamodelTypeDeclarationTypeName);
        }

        @Override
        public String getMultiReferenceTargetTypeName(JavaResourcePersistentAttribute resourcePersistentAttribute) {
            return resourcePersistentAttribute.typeTypeArgumentNamesSize() == 2 ? resourcePersistentAttribute.getTypeTypeArgumentName(1) : null;
        }

        @Override
        public String getMultiReferenceMapKeyTypeName(JavaResourcePersistentAttribute resourcePersistentAttribute) {
            return resourcePersistentAttribute.typeTypeArgumentNamesSize() == 2 ? resourcePersistentAttribute.getTypeTypeArgumentName(0) : null;
        }

        @Override
        public String getMetamodelContainerFieldMapKeyTypeName(CollectionMapping mapping) {
            return mapping.getMetamodelFieldMapKeyTypeName();
        }

        @Override
        public boolean isMap() {
            return true;
        }
    }
}

