/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.text;

import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xsd.ui.internal.text.XSDModelDelayedReconciler;
import org.eclipse.wst.xsd.ui.internal.util.ModelReconcileAdapter;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDModelReconcileAdapter
extends ModelReconcileAdapter {
    protected XSDSchema schema;
    protected XSDModelDelayedReconciler delayedReconciler;

    public XSDModelReconcileAdapter(Document document, XSDSchema schema) {
        super(document);
        this.schema = schema;
        this.delayedReconciler = new XSDModelDelayedReconciler();
    }

    protected void handleNodeChanged(Node node) {
        try {
            if (!this.shouldReconcileModelFor(node)) {
                return;
            }
        }
        catch (Exception exception) {}
        if (node instanceof Element) {
            Element element = (Element)node;
            if (this.delayedReconciler.shouldDelay(this.schema)) {
                this.delayedReconciler.elementChanged(element, this.schema);
            } else {
                XSDConcreteComponent concreteComponent = this.schema.getCorrespondingComponent(node);
                concreteComponent.elementChanged(element);
            }
        } else if (node instanceof Document) {
            Document document = (Document)node;
            Element schemaElement = document.getDocumentElement();
            if (schemaElement != null && schemaElement != this.schema.getElement()) {
                if (schemaElement.getLocalName().equals("schema")) {
                    this.schema.setElement(schemaElement);
                }
            } else if (schemaElement != null) {
                this.schema.elementChanged(schemaElement);
            } else {
                try {
                    this.schema.getContents().clear();
                }
                catch (NullPointerException nullPointerException) {}
                try {
                    this.schema.getIncorporatedVersions().clear();
                }
                catch (Exception exception) {}
                try {
                    this.schema.getElementDeclarations().clear();
                }
                catch (Exception exception) {}
                try {
                    this.schema.getTypeDefinitions().clear();
                }
                catch (Exception exception) {}
                try {
                    this.schema.getAttributeDeclarations().clear();
                }
                catch (Exception exception) {}
                try {
                    this.schema.getModelGroupDefinitions().clear();
                }
                catch (Exception exception) {}
                try {
                    this.schema.getAttributeGroupDefinitions().clear();
                }
                catch (Exception exception) {}
                try {
                    this.schema.setTargetNamespace(null);
                }
                catch (Exception exception) {}
                try {
                    this.schema.reset();
                }
                catch (Exception exception) {}
                this.schema.setElement(null);
            }
        }
    }

    protected boolean shouldReconcileModelFor(Node changedNode) {
        String nodeName;
        if (changedNode instanceof Document) {
            return true;
        }
        String nodeNamespace = changedNode.getNamespaceURI();
        String schemaNamespace = this.schema.getSchemaForSchemaNamespace();
        if (!schemaNamespace.equals(nodeNamespace) && nodeNamespace != null) {
            return false;
        }
        Node parentNode = changedNode.getParentNode();
        return parentNode == null || !"appinfo".equals(nodeName = changedNode.getLocalName()) && !"documentation".equals(nodeName);
    }

    public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
    }
}

