/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfcore;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory2;
import org.eclipse.jst.pagedesigner.converter.HiddenTagConverter;
import org.eclipse.jst.pagedesigner.converter.IConverterFactory;
import org.eclipse.jst.pagedesigner.converter.ITagConverter;
import org.eclipse.jst.pagedesigner.converter.TagConverterToInlineBlock;
import org.eclipse.jst.pagedesigner.dtmanager.converter.internal.DTTagConverter;
import org.eclipse.jst.pagedesigner.editors.palette.TagImageManager;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfcore.LoadBundleTagConverter;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfcore.ViewTagConverter;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Element;

public class JSFCoreConverterFactory
implements IConverterFactory {
    private final ILabelProvider _labelProvider = new MyLabelProvider();
    private static final Set _dtConversionSupported = new HashSet();

    public ITagConverter createConverter(Element element, int mode) {
        Object converter;
        String tagName = element.getLocalName();
        if (_dtConversionSupported.contains(tagName)) {
            converter = this.createDTTagConverter(element);
        } else if ("view".equalsIgnoreCase(tagName) || "subview".equalsIgnoreCase(tagName)) {
            converter = new ViewTagConverter(element);
            ((ViewTagConverter)((Object)converter)).setNeedBorderDecorator(true);
        } else if ("facet".equalsIgnoreCase(tagName) || "verbatim".equalsIgnoreCase(tagName)) {
            TagConverterToInlineBlock toSpan = new TagConverterToInlineBlock(element, mode);
            toSpan.setMinWidth(10);
            toSpan.setMinHeight(10);
            toSpan.setNeedBorderDecorator(true);
            converter = toSpan;
        } else {
            converter = "loadBundle".equalsIgnoreCase(tagName) ? new LoadBundleTagConverter(element, this._labelProvider) : new HiddenTagConverter(element, this._labelProvider);
        }
        converter.setMode(mode);
        return converter;
    }

    public String getSupportedURI() {
        return "http://java.sun.com/jsf/core";
    }

    private ITagConverter createDTTagConverter(Element element) {
        return new DTTagConverter(element);
    }

    private static class MyLabelProvider
    extends LabelProvider {
        private MyLabelProvider() {
        }

        public Image getImage(Object element) {
            IWorkspaceContextResolver wsResolver;
            Element hostElement;
            IStructuredDocumentContext context;
            if (element instanceof ITagConverter && (context = IStructuredDocumentContextFactory2.INSTANCE.getContext(hostElement = ((ITagConverter)element).getHostElement())) != null && (wsResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context)) != null) {
                return TagImageManager.getInstance().getSmallIconImage(wsResolver.getProject(), "http://java.sun.com/jsf/core", hostElement.getLocalName());
            }
            return null;
        }
    }
}

