/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath.ui.internal.views;

import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xpath.jaxp.XPathFactoryImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.xpath.core.util.NodeListImpl;
import org.eclipse.wst.xml.xpath.core.util.XPath20Helper;
import org.eclipse.wst.xml.xpath.core.util.XPathCoreHelper;
import org.eclipse.wst.xml.xpath.core.util.XSLTXPathHelper;
import org.eclipse.wst.xml.xpath.ui.internal.Messages;
import org.eclipse.wst.xml.xpath.ui.internal.XPathUIPlugin;
import org.eclipse.wst.xml.xpath.ui.internal.views.DefaultNamespaceContext;
import org.eclipse.wst.xml.xpath.ui.internal.views.XPathView;
import org.eclipse.wst.xml.xpath2.processor.DefaultDynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DefaultEvaluator;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.JFlexCupParser;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.StaticContext;
import org.eclipse.wst.xml.xpath2.processor.StaticNameResolver;
import org.eclipse.wst.xml.xpath2.processor.function.FnFunctionLibrary;
import org.eclipse.wst.xml.xpath2.processor.function.XSCtrLibrary;
import org.eclipse.wst.xml.xpath2.processor.internal.DefaultResultSequence;
import org.eclipse.wst.xml.xpath2.processor.internal.Focus;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathNode;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FunctionLibrary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathComputer {
    private static final int UPDATE_DELAY = 500;
    private static final byte[] XPATH_LOCK = new byte[0];
    private boolean xpath20 = true;
    private XPathView xpathView;
    private IModelStateListener modelStateListener = new IModelStateListener(){

        public void modelAboutToBeChanged(IStructuredModel model) {
        }

        public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
        }

        public void modelChanged(IStructuredModel model) {
            XPathComputer.this.updateXPath();
            XPathComputer.this.compute();
        }

        public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
        }

        public void modelReinitialized(IStructuredModel structuredModel) {
        }

        public void modelResourceDeleted(IStructuredModel model) {
        }

        public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
        }
    };
    private Node node;
    private IStructuredModel model;
    private String expression;
    private String text;
    private NodeList nodeList;

    public XPathComputer(XPathView xpathView) {
        this.xpathView = xpathView;
    }

    public void setModel(IStructuredModel model) {
        if (this.model != null) {
            this.model.removeModelStateListener(this.modelStateListener);
        }
        this.model = model;
        if (model != null) {
            model.addModelStateListener(this.modelStateListener);
            this.updateXPath();
        } else {
            this.node = null;
        }
    }

    private void updateXPath() {
        Document doc = (Document)this.model.getAdapter(Document.class);
        if (doc == null) {
            return;
        }
        try {
            this.updateExpression();
        }
        catch (XPathExpressionException xPathExpressionException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExpression() throws XPathExpressionException {
        byte[] byArray = XPATH_LOCK;
        synchronized (XPATH_LOCK) {
            if (this.text != null) {
                if (this.xpath20) {
                    XPath20Helper.compile((String)this.text);
                } else {
                    XSLTXPathHelper.compile((String)this.text);
                }
                this.expression = this.text;
            } else {
                this.expression = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void setText(String text) throws XPathExpressionException {
        this.text = text;
        this.updateExpression();
    }

    public void setSelectedNode(Node node) {
        this.node = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compute() {
        final String[] xps = new String[1];
        byte[] byArray = XPATH_LOCK;
        synchronized (XPATH_LOCK) {
            xps[0] = this.expression;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Job refresh = new Job(Messages.XPathComputer_5){

                protected IStatus run(IProgressMonitor monitor) {
                    if (!xps[0].equals(XPathComputer.this.expression)) {
                        return Status.CANCEL_STATUS;
                    }
                    return XPathComputer.this.doCompute(xps[0]);
                }
            };
            refresh.setSystem(true);
            refresh.setPriority(20);
            IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)this.xpathView.getSite().getService(IWorkbenchSiteProgressService.class);
            service.schedule(refresh, 500L);
            return;
        }
    }

    private IStatus doCompute(String xp) {
        IStatus status = this.executeXPath(xp);
        this.xpathView.xpathRecomputed(this.nodeList);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IStatus executeXPath(String xp) {
        IStatus status = Status.CANCEL_STATUS;
        this.xpath20 = XPathCoreHelper.getPreferences().getBoolean("XPATH2.0", false);
        try {
            if (xp == null) return status;
            if (this.node == null) return status;
            byte[] byArray = XPATH_LOCK;
            synchronized (XPATH_LOCK) {
                if (!this.xpath20) return this.evaluateXPath(xp);
                return this.evaluateXPath2(xp);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            return Status.CANCEL_STATUS;
        }
    }

    protected IStatus evaluateXPath(String xp) throws XPathExpressionException {
        XPath newXPath = new XPathFactoryImpl().newXPath();
        IDOMDocument doc = null;
        doc = this.node.getNodeType() == 9 ? (IDOMDocument)this.node : (IDOMDocument)this.node.getOwnerDocument();
        List<NamespaceInfo> namespaces = XPathUIPlugin.getDefault().getNamespaceInfo(doc);
        if (namespaces != null) {
            newXPath.setNamespaceContext(new DefaultNamespaceContext(namespaces));
        }
        XPathExpression xpExp = newXPath.compile(xp);
        try {
            this.nodeList = (NodeList)xpExp.evaluate(this.node, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xee) {
            if (xee.getCause() != null && xee.getCause().getMessage().indexOf("Can not convert ") >= 0) {
                try {
                    String value = (String)xpExp.evaluate(this.node, XPathConstants.STRING);
                    this.nodeList = new NodeListImpl((ResultSequence)new DefaultResultSequence((AnyType)new XSString(value)));
                }
                catch (XPathExpressionException xPathExpressionException) {
                    return Status.CANCEL_STATUS;
                }
            }
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    protected IStatus evaluateXPath2(String xp) throws XPathExpressionException {
        IDOMDocument doc = this.node.getNodeType() == 9 ? (IDOMDocument)this.node : (IDOMDocument)this.node.getOwnerDocument();
        DefaultDynamicContext dc = new DefaultDynamicContext(null, (Document)doc);
        List<NamespaceInfo> namespaces = XPathUIPlugin.getDefault().getNamespaceInfo(doc);
        dc.add_namespace("xs", "http://www.w3.org/2001/XMLSchema");
        if (namespaces != null) {
            for (NamespaceInfo namespaceinfo : namespaces) {
                dc.add_namespace(namespaceinfo.prefix, namespaceinfo.uri);
            }
        }
        dc.add_function_library((FunctionLibrary)new FnFunctionLibrary());
        dc.add_function_library((FunctionLibrary)new XSCtrLibrary());
        JFlexCupParser xpp = new JFlexCupParser();
        try {
            org.eclipse.wst.xml.xpath2.processor.ast.XPath xpath = xpp.parse(xp);
            StaticNameResolver namecheck = new StaticNameResolver((StaticContext)dc);
            namecheck.check((XPathNode)xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, (Document)doc);
            dc.set_focus(new Focus((ResultSequence)new DefaultResultSequence((AnyType)NodeType.dom_to_xpath((Node)this.node))));
            ResultSequence rs = eval.evaluate((XPathNode)xpath);
            this.nodeList = new NodeListImpl(rs);
        }
        catch (Exception ex) {
            throw new XPathExpressionException(ex);
        }
        return Status.OK_STATUS;
    }

    public void dispose() {
        if (this.model != null) {
            this.model.removeModelStateListener(this.modelStateListener);
            this.model = null;
        }
    }
}

