/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.search;

import com.mbartl.viimplementation.preferences.ViPreferenceService;
import com.mbartl.viimplementation.search.Search;
import com.mbartl.viimplementation.search.SimpleSearch;
import com.mbartl.viimplementation.util.Region;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class JakartaRegExSearch
extends Search {
    public Region search(String text, String regex, int direction, int mode, int startPos) {
        if (regex == null || regex.length() == 0) {
            return null;
        }
        RE re = null;
        try {
            re = new RE(regex, this.getFlags());
        }
        catch (RESyntaxException e) {
            SimpleSearch search = new SimpleSearch();
            return search.search(text, regex, direction, mode);
        }
        int pos = startPos;
        if (direction == 0) {
            if (mode == 0 || mode == 1) {
                if (++pos > text.length() - 1) {
                    pos = 0;
                }
                return this.searchForward(re, text, pos);
            }
            if (--pos < 0) {
                pos = text.length() - 1;
            }
            return this.searchBackward(re, text, pos);
        }
        if (mode == 0 || mode == 1) {
            if (--pos < 0) {
                pos = text.length() - 1;
            }
            return this.searchBackward(re, text, pos);
        }
        if (++pos > text.length() - 1) {
            pos = 0;
        }
        return this.searchForward(re, text, pos);
    }

    private Region searchForward(RE re, String text, int startPos) {
        int idx = -1;
        String foundStr = "";
        if (re.match(text, startPos)) {
            idx = re.getParenStart(0);
            foundStr = re.getParen(0);
        }
        if (idx == -1 && this.shouldWrapScan() && re.match(text)) {
            idx = re.getParenStart(0);
            foundStr = re.getParen(0);
        }
        if (idx != -1) {
            return new Region(idx, foundStr.length());
        }
        return null;
    }

    private Region searchBackward(RE re, String text, int startPos) {
        int idx = -1;
        String foundStr = "";
        int newCursor = -1;
        while (re.match(text, ++newCursor)) {
            newCursor = re.getParenStart(0);
            if (newCursor > startPos) break;
            idx = newCursor;
            foundStr = re.getParen(0);
        }
        if (idx == -1 && this.shouldWrapScan()) {
            newCursor = -1;
            while (re.match(text, ++newCursor)) {
                idx = newCursor = re.getParenStart(0);
                foundStr = re.getParen(0);
            }
        }
        if (idx != -1) {
            return new Region(idx, foundStr.length());
        }
        return null;
    }

    private int getFlags() {
        boolean ignoreCase = ViPreferenceService.getInstance().getBoolean("ignorecase");
        int flags = 2;
        if (ignoreCase) {
            flags |= 1;
        }
        return flags;
    }

    private boolean shouldWrapScan() {
        return true;
    }
}

