/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.search;

import com.mbartl.viimplementation.layer.ViLayer;
import com.mbartl.viimplementation.layer.ViLayerManager;
import com.mbartl.viimplementation.search.Search;
import com.mbartl.viimplementation.search.SearchFactory;
import com.mbartl.viimplementation.util.DocumentAnalyzer;
import com.mbartl.viimplementation.util.Region;
import java.util.Vector;

public class GetOccurences {
    public static Vector getAll(String text, String match, boolean global) {
        Region startingSelection = new Region(0, text.length());
        return GetOccurences.get(text, startingSelection, match, global);
    }

    public static Vector getInSelection(String text, String match, Region region, boolean global) {
        return GetOccurences.get(text, region, match, global);
    }

    private static Vector get(String text, Region startingSelection, String match, boolean global) {
        ViLayer viLayer = ViLayerManager.getInstance().getCurrentLayer();
        DocumentAnalyzer analyzer = viLayer.getDocumentAnalyzer();
        Search search = SearchFactory.getNewRegExpSearch();
        int lastLineNr = -1;
        Vector<Integer> locations = new Vector<Integer>();
        Vector<Region> occurences = new Vector<Region>();
        Region result = search.search(text, match, 0, startingSelection.getOffset());
        while (result != null) {
            int foundOffset = result.getOffset();
            if (GetOccurences.isLocationPassed(locations, foundOffset)) break;
            locations.add(new Integer(foundOffset));
            if (foundOffset >= startingSelection.getOffset() && foundOffset <= startingSelection.getOffset() + startingSelection.getLength() - 1) {
                int lineNr = analyzer.getLinePosOfOffset(result.getOffset());
                if ((global || lastLineNr != lineNr) && !GetOccurences.isSubSelection(occurences, result)) {
                    occurences.add(result);
                    lastLineNr = lineNr;
                }
            }
            result = search.searchNext(text, result.getOffset());
        }
        return occurences;
    }

    private static boolean isLocationPassed(Vector locations, int foundOffset) {
        int i = 0;
        while (i < locations.size()) {
            Integer loc = (Integer)locations.get(i);
            if (loc == foundOffset) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isSubSelection(Vector occurences, Region selection) {
        int i = 0;
        while (i < occurences.size()) {
            Region region = (Region)occurences.get(i);
            int startPos = selection.getOffset();
            if (region.getOffset() <= startPos && selection.getOffset() <= region.getOffsetEnd() - 1) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

