/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.registers;

import com.mbartl.viimplementation.layer.ViLayer;
import com.mbartl.viimplementation.layer.ViLayerManager;
import com.mbartl.viimplementation.preferences.ViPreferenceService;
import com.mbartl.viimplementation.registers.TextBuffer;
import java.util.HashMap;
import java.util.Map;

public class YankBufferHandler {
    private Map _buffers = new HashMap();
    private String _currentKey = "<default>";
    private static YankBufferHandler _instance = null;

    public static YankBufferHandler getInstance() {
        if (_instance == null) {
            _instance = new YankBufferHandler();
        }
        return _instance;
    }

    public TextBuffer getBuffer(String key) {
        boolean copytoclipboard = ViPreferenceService.getInstance().getBoolean("copytoclipboard");
        if (key.equals("<*>") || copytoclipboard && key.equals("<default>")) {
            ViLayer layer = ViLayerManager.getInstance().getCurrentLayer();
            TextBuffer textBuffer = new TextBuffer();
            String clipboardContent = layer.getEditor().getClipboardContent();
            if (clipboardContent == null) {
                clipboardContent = "";
            }
            textBuffer.fill(clipboardContent, layer.getDocument().get());
            this._buffers.put(key, textBuffer);
        } else if (!this._buffers.containsKey(key)) {
            this._buffers.put(key, new TextBuffer());
        }
        return (TextBuffer)this._buffers.get(key);
    }

    public void setCurrentKey(String key) {
        this._currentKey = key;
    }

    public TextBuffer getCurrentBuffer() {
        return this.getBuffer(this._currentKey);
    }

    public String getCurrentKey() {
        return this._currentKey;
    }
}

