/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.preferences;

import com.mbartl.viimplementation.preferences.AbstractSetPrefCommand;
import com.mbartl.viimplementation.preferences.Preferences;
import com.mbartl.viimplementation.preferences.SetBoolean;
import com.mbartl.viimplementation.preferences.SetInt;
import com.mbartl.viimplementation.preferences.SetPrefCommand;
import java.util.HashMap;
import java.util.Map;

public final class ViPreferenceService {
    private static ViPreferenceService _preferenceService = null;
    private Map _prefCommands = new HashMap();
    private Preferences _preferences = new Preferences();

    private void initCommandMappings() {
        Map pf = this._prefCommands;
        AbstractSetPrefCommand c = null;
        c = new SetBoolean("ignorecase", true);
        pf.put("ic", c);
        pf.put("ignorecase", c);
        c = new SetBoolean("ignorecase", false);
        pf.put("noic", c);
        pf.put("noignorecase", c);
        c = new SetBoolean("vimcursor", true);
        pf.put("vc", c);
        pf.put("vimcursor", c);
        c = new SetBoolean("vimcursor", false);
        pf.put("novc", c);
        pf.put("novimcursor", c);
        c = new SetInt("shiftwidth");
        pf.put("shiftwidth", c);
        pf.put("sw", c);
        c = new SetBoolean("expandtab", true);
        pf.put("et", c);
        pf.put("expandtab", c);
        c = new SetBoolean("expandtab", false);
        pf.put("noet", c);
        pf.put("noexpandtab", c);
        c = new SetBoolean("hlsearch", true);
        pf.put("hlsearch", c);
        c = new SetBoolean("hlsearch", false);
        pf.put("nohlsearch", c);
        c = new SetBoolean("incsearch", true);
        pf.put("incsearch", c);
        c = new SetBoolean("incsearch", false);
        pf.put("noincsearch", c);
        c = new SetInt("undolevels");
        pf.put("undolevels", c);
        c = new SetBoolean("copytoclipboard", true);
        pf.put("copytoclipboard", c);
        c = new SetBoolean("copytoclipboard", false);
        pf.put("nocopytoclipboard", c);
    }

    private ViPreferenceService() {
        this.initCommandMappings();
    }

    public static ViPreferenceService getInstance() {
        if (_preferenceService == null) {
            _preferenceService = new ViPreferenceService();
        }
        return _preferenceService;
    }

    public Preferences getPreferences() {
        return this._preferences;
    }

    public void set(String name, String value) {
        SetPrefCommand command = (SetPrefCommand)this._prefCommands.get(name);
        if (command != null) {
            command.execute(value);
        }
    }

    public boolean getBoolean(String name) {
        return this._preferences.getBoolean(name);
    }

    public String getString(String name) {
        return this._preferences.getString(name);
    }

    public int getInt(String name) {
        return this._preferences.getInt(name);
    }
}

