/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.preferences;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Vector;
import nanoxml.XMLElement;
import nanoxml.XMLParseException;

public class Preferences {
    public static final String VIMCURSOR = "vimcursor";
    public static final String IGNORECASE = "ignorecase";
    public static final String SHIFTWIDTH = "shiftwidth";
    public static final String EXPANDTAB = "expandtab";
    public static final String HIGHLIGHTSEARCH = "hlsearch";
    public static final String INCSEARCH = "incsearch";
    public static final String UNDOLEVELS = "undolevels";
    public static final String WORDSEPARATORS = "wordseparators";
    public static final String COPYTOCLIPBOARD = "copytoclipboard";
    private HashMap _preferences = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public Preferences() {
        this.setDefaultPreferences();
    }

    public void checkPreferencesLocations(String[] paths) throws XMLParseException, IOException {
        String path = "";
        boolean found = false;
        int i = 0;
        while (i < paths.length) {
            path = String.valueOf(paths[i]) + File.separator + "viPlugin_rc.xml";
            if (new File(path).exists()) {
                found = true;
                break;
            }
            path = String.valueOf(paths[i]) + File.separator + "viplugin_rc.xml";
            if (new File(path).exists()) {
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            this.loadPreferences(new File(path));
        }
    }

    private void loadPreferences(File file) throws XMLParseException, IOException {
        Class<?> clazz;
        XMLElement xml = new XMLElement();
        xml.parseFromReader((Reader)new FileReader(file));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setValueFromXML(xml, VIMCURSOR, clazz2);
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setValueFromXML(xml, IGNORECASE, clazz3);
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setValueFromXML(xml, SHIFTWIDTH, clazz4);
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setValueFromXML(xml, EXPANDTAB, clazz5);
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setValueFromXML(xml, HIGHLIGHTSEARCH, clazz6);
        Class<?> clazz7 = class$0;
        if (clazz7 == null) {
            try {
                clazz7 = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setValueFromXML(xml, INCSEARCH, clazz7);
        Class<?> clazz8 = class$1;
        if (clazz8 == null) {
            try {
                clazz8 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setValueFromXML(xml, UNDOLEVELS, clazz8);
        Class<?> clazz9 = class$0;
        if (clazz9 == null) {
            try {
                clazz9 = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setValueFromXML(xml, COPYTOCLIPBOARD, clazz9);
        int undoLevels = this.getInt(UNDOLEVELS);
        if (undoLevels == 0) {
            this.setValue(UNDOLEVELS, 1);
        }
        if ((clazz = class$2) == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setValueFromXML(xml, WORDSEPARATORS, clazz);
    }

    public boolean getBoolean(String name) {
        Boolean bool = (Boolean)this._preferences.get(name);
        return bool;
    }

    public String getString(String name) {
        return (String)this._preferences.get(name);
    }

    public int getInt(String name) {
        Integer integer = (Integer)this._preferences.get(name);
        return integer;
    }

    public void setValue(String name, int i) {
        this._preferences.put(name, new Integer(i));
    }

    public void setValue(String name, String value) {
        this._preferences.put(name, value);
    }

    public void setValue(String name, String value, Object type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            if (value.equals("true")) {
                this.setValue(name, true);
            } else if (value.equals("false")) {
                this.setValue(name, false);
            }
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (type == clazz2) {
                try {
                    int intValue = Integer.parseInt(value);
                    this.setValue(name, intValue);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type == clazz3) {
                    this.setValue(name, value);
                }
            }
        }
    }

    public void setValue(String name, boolean b) {
        this._preferences.put(name, new Boolean(b));
    }

    public String toString() {
        String str = "";
        Object[] keys = this._preferences.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            str = String.valueOf(str) + (String)keys[i] + " = " + this._preferences.get(keys[i]) + "\n";
            ++i;
        }
        return str;
    }

    private void setDefaultPreferences() {
        this._preferences.put(VIMCURSOR, new Boolean(true));
        this._preferences.put(IGNORECASE, new Boolean(true));
        this._preferences.put(SHIFTWIDTH, new Integer(4));
        this._preferences.put(EXPANDTAB, new Boolean(false));
        this._preferences.put(HIGHLIGHTSEARCH, new Boolean(true));
        this._preferences.put(INCSEARCH, new Boolean(true));
        this._preferences.put(UNDOLEVELS, new Integer(1000));
        this._preferences.put(WORDSEPARATORS, ".,(,), ,TAB,ENTER,:,;,?,+,=,ANGLE_BRACKET_RIGHT,ANGLE_BRACKET_LEFT,*,{,},\",|,COMMA,-,\\,/,@,[,],},~,!,#,$,%,^,AND,',`,\u00b4");
        this._preferences.put(COPYTOCLIPBOARD, new Boolean(false));
    }

    private void setValueFromXML(XMLElement xml, String preference, Object type) {
        Vector children = xml.getChildren();
        int i = 0;
        while (i < children.size()) {
            XMLElement child = (XMLElement)children.get(i);
            if (child.getName().equals(preference) && child.getContent() != null) {
                this.setValue(preference, child.getContent(), type);
            }
            ++i;
        }
    }
}

