/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.layer;

import com.mbartl.viimplementation.interfaces.IEditorManager;
import com.mbartl.viimplementation.interfaces.NullEditorManager;
import com.mbartl.viimplementation.layer.LayerInformation;
import com.mbartl.viimplementation.layer.ViLayer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ViLayerManager {
    private IEditorManager _editorManager = new NullEditorManager();
    private Map _viLayers = new HashMap();
    private String _currentLayerId = "";
    private static ViLayerManager _manager = null;
    private static boolean _fullVersion = false;

    private ViLayerManager() {
    }

    public static ViLayerManager getInstance() {
        if (_manager == null) {
            _manager = new ViLayerManager();
        }
        return _manager;
    }

    public boolean activateLayer(String layerId) {
        ViLayer currViLayer;
        if (!this._currentLayerId.equals(layerId) && (currViLayer = this.getLayerById(layerId)) != null) {
            this._currentLayerId = layerId;
        }
        return false;
    }

    public ViLayer createLayer(String layerId, LayerInformation info) {
        if (!this._currentLayerId.equals(layerId)) {
            ViLayer currViLayer = this.getLayerById(layerId);
            if (currViLayer == null) {
                this._viLayers.put(layerId, new ViLayer(info));
            }
            this._currentLayerId = layerId;
        }
        return this.getCurrentLayer();
    }

    public void removeAllLayers() {
        Iterator iter = this._viLayers.values().iterator();
        while (iter.hasNext()) {
            ViLayer layer = (ViLayer)iter.next();
            layer.unLoad();
        }
        _manager = null;
    }

    public void removeViLayer(String layerId) {
        ViLayer viLayer = this.getLayerById(layerId);
        if (viLayer != null) {
            viLayer.unLoad();
            this._viLayers.remove(layerId);
            if (this._currentLayerId.equals(layerId)) {
                this._currentLayerId = "";
            }
        }
    }

    public ViLayer getLayerById(String layerId) {
        return (ViLayer)this._viLayers.get(layerId);
    }

    public ViLayer getCurrentLayer() {
        return this.getLayerById(this._currentLayerId);
    }

    public void setEditorManager(IEditorManager editorManager) {
        this._editorManager = editorManager;
    }

    public IEditorManager getEditorManager() {
        return this._editorManager;
    }

    public void setFullVersion(boolean fullVersion) {
        _fullVersion = fullVersion;
    }

    public boolean isFullVersion() {
        return _fullVersion;
    }
}

