/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.layer;

import com.mbartl.viimplementation.layer.ViLayer;
import com.mbartl.viimplementation.util.Line;
import com.mbartl.viimplementation.util.Region;
import com.mbartl.viimplementation.util.ViMode;

public class SelectionManager {
    private ViLayer _layer;
    private Region _selection;
    private int _visualAnchor;

    public SelectionManager(ViLayer layer) {
        this._layer = layer;
        this.setInternalSelection(this._layer.getEditor().getCaretPosition(), 0);
    }

    public Region getSelection() {
        return this._selection;
    }

    public void resetSelection() {
        this.setVisualSelection(this._layer.getEditor().getCaretPosition(), 0);
    }

    public void activateVisualMode(ViMode mode) {
        if (mode == ViMode.VISUAL_MODE) {
            this._visualAnchor = this._layer.getEditor().getCaretPosition();
            this.setVisualSelection(this._visualAnchor, 1);
        } else {
            Line line = this._layer.getDocumentAnalyzer().getLineOfOffset(this._layer.getEditor().getCaretPosition());
            this._visualAnchor = line.getOffset();
            this.setVisualSelection(this._visualAnchor, line.getLength());
        }
    }

    public void setVisualSelection(int start, int length) {
        this.setVisualSelection(new Region(start, length));
    }

    public void setVisualSelection(Region selection) {
        this._selection = Region.normalize(selection);
        this._layer.getEditor().setSelection(this._selection);
    }

    public void setInternalSelection(int start, int length) {
        this._selection = new Region(start, length);
    }

    public void setInternalSelection(Region selection) {
        this._selection = selection;
    }

    public void updateVisualSelection(int caretPosition) {
        int length = caretPosition - this._visualAnchor;
        if (this._layer.isInVisualCharacterMode()) {
            if (length >= 0) {
                this.setVisualSelection(this._visualAnchor, length + 1);
            } else {
                this.setVisualSelection(this._visualAnchor + 1, length - 1);
            }
        } else {
            this.setVisualSelection(this.expandSelectionToFullLines(this._visualAnchor + 1, length));
        }
    }

    public void expandCurrentSelectionToFullLines() {
        this.setInternalSelection(this.expandSelectionToFullLines(this._selection));
    }

    public Region expandSelectionToFullLines(int start, int length) {
        return this.expandSelectionToFullLines(new Region(start, length));
    }

    public Region expandSelectionToFullLines(Region selection) {
        Region normSelection = Region.normalize(selection);
        Line startLine = this._layer.getDocumentAnalyzer().getLineOfOffset(normSelection.getOffset());
        Line endLine = this._layer.getDocumentAnalyzer().getLineOfOffset(normSelection.getOffsetEnd() - 1);
        return new Region(startLine.getOffset(), endLine.getOffsetEnd() - startLine.getOffset());
    }

    public void selectAll() {
        this.setInternalSelection(0, this._layer.getDocument().getLength());
    }
}

