/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.layer;

import com.mbartl.viimplementation.command.actions.change.InsertString;
import com.mbartl.viimplementation.command.actions.change.ReplaceSelection;
import com.mbartl.viimplementation.command.actions.motion.CheckValidCursorPosition;
import com.mbartl.viimplementation.command.actions.motion.MoveLeft;
import com.mbartl.viimplementation.command.actions.motion.MoveRight;
import com.mbartl.viimplementation.command.actions.select.SelectCharacters;
import com.mbartl.viimplementation.layer.BufferEvaluator;
import com.mbartl.viimplementation.layer.ViLayer;
import com.mbartl.viimplementation.preferences.ViPreferenceService;
import com.mbartl.viimplementation.util.Macro;
import com.mbartl.viimplementation.util.TextUtils;
import com.mbartl.viimplementation.util.ViKeyEvent;

public class KeyVerifier {
    private static final int ESCAPE = 27;
    private static final int TAB = 9;
    private final ViLayer _layer;

    public KeyVerifier(ViLayer layer) {
        this._layer = layer;
    }

    public boolean verifyKey(ViKeyEvent e) {
        Macro macro = this._layer.getBufferEvaluator().getMacro();
        if (macro != null) {
            macro.add(e);
        }
        if (e.getKeyChar() == '\u001b') {
            if (this._layer.isInCommandMode()) {
                this._layer.getBufferEvaluator().clear();
            } else if (this._layer.isInInsertMode() || this._layer.isInReplaceMode()) {
                this._layer.getBufferEvaluator().executeMultipleInsertModeCommand();
                this._layer.getDocumentAnalyzer().updateAnalyzer(this._layer.getDocument().get());
                new MoveLeft(1, false).execute();
                this._layer.switchToCommandMode();
                new CheckValidCursorPosition().execute();
            } else if (this._layer.isInVisualOrVisualLineMode()) {
                this._layer.switchToCommandMode();
            }
            e.consume();
        } else if (this._layer.isInCommandMode() || this._layer.isInVisualOrVisualLineMode()) {
            this.inCommandMode(e);
        } else if (this._layer.isInInsertMode()) {
            boolean expandtab;
            if (e.getKeyChar() != '\u0000') {
                this._layer.getInsertBuffer().append(e.getKeyChar());
            }
            if ((expandtab = ViPreferenceService.getInstance().getBoolean("expandtab")) && e.getKeyChar() == '\t') {
                int shiftwidth = ViPreferenceService.getInstance().getInt("shiftwidth");
                new InsertString(TextUtils.multiplyString(" ", shiftwidth), 0).execute();
                e.consume();
            }
        } else if (this._layer.isInReplaceMode() && e.getKeyChar() != '\u0000') {
            if (e.getKeyChar() == '\b') {
                this._layer.getBufferEvaluator().appendAndEval("h");
            } else if (e.getKeyChar() == '\u007f') {
                this._layer.getBufferEvaluator().appendAndEval("x");
            } else {
                new SelectCharacters(1).execute();
                new ReplaceSelection(e.getKeyChar()).execute();
                new MoveRight(1, 0).execute();
            }
            this._layer.getInsertBuffer().append(e.getKeyChar());
            e.consume();
        }
        this._layer.setStatusLine();
        return e.isConsumed();
    }

    private void inCommandMode(ViKeyEvent e) {
        BufferEvaluator buffer = this._layer.getBufferEvaluator();
        if (e.getKeyCode() == 40 && e.getModifiers() == 0) {
            buffer.appendAndEval("<CD>");
            e.consume();
            return;
        }
        if (e.getKeyCode() == 38 && e.getModifiers() == 0) {
            buffer.appendAndEval("<CU>");
            e.consume();
            return;
        }
        if (e.getKeyCode() == 37 && e.getModifiers() == 0) {
            buffer.appendAndEval("<CL>");
            e.consume();
            return;
        }
        if (e.getKeyCode() == 39 && e.getModifiers() == 0) {
            buffer.appendAndEval("<CR>");
            e.consume();
            return;
        }
        if (e.getKeyChar() == '\u0000' && e.getKeyCode() == 36) {
            buffer.appendAndEval('0');
            e.consume();
            return;
        }
        if (e.getKeyChar() == '\u0000' && e.getKeyCode() == 35) {
            buffer.appendAndEval('$');
            e.consume();
            return;
        }
        switch (e.getKeyChar()) {
            case '\b': {
                buffer.backspacePressed();
                buffer.eval();
                e.consume();
                break;
            }
            case '\u007f': {
                buffer.deletePressed();
                buffer.eval();
                e.consume();
                break;
            }
            case '\u0000': {
                break;
            }
            default: {
                buffer.appendAndEval(e.getKeyChar());
                e.consume();
            }
        }
    }
}

