/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.layer;

import com.mbartl.viimplementation.command.actions.AddBookmark;
import com.mbartl.viimplementation.command.actions.AddMacro;
import com.mbartl.viimplementation.command.actions.Command;
import com.mbartl.viimplementation.command.actions.ExecuteMacro;
import com.mbartl.viimplementation.command.actions.ExtendSelectionToOffset;
import com.mbartl.viimplementation.command.actions.GroupCommand;
import com.mbartl.viimplementation.command.actions.ReplaceExpressionInSelection;
import com.mbartl.viimplementation.command.actions.SearchDelegate;
import com.mbartl.viimplementation.command.actions.SwitchToInsertModeCommand;
import com.mbartl.viimplementation.command.actions.YankSelection;
import com.mbartl.viimplementation.command.actions.change.ChangeCaseSelection;
import com.mbartl.viimplementation.command.actions.change.IndentSelection;
import com.mbartl.viimplementation.command.actions.change.JoinLine;
import com.mbartl.viimplementation.command.actions.change.NewLineAbove;
import com.mbartl.viimplementation.command.actions.change.NewLineBelow;
import com.mbartl.viimplementation.command.actions.change.PasteAbove;
import com.mbartl.viimplementation.command.actions.change.PasteBelow;
import com.mbartl.viimplementation.command.actions.change.ReplaceSelection;
import com.mbartl.viimplementation.command.actions.change.ReplayInsertCommand;
import com.mbartl.viimplementation.command.actions.change.ShiftSelection;
import com.mbartl.viimplementation.command.actions.delete.DeleteCommandFactory;
import com.mbartl.viimplementation.command.actions.delete.DeleteSelection;
import com.mbartl.viimplementation.command.actions.motion.GotoBookmark;
import com.mbartl.viimplementation.command.actions.motion.GotoLastLine;
import com.mbartl.viimplementation.command.actions.motion.GotoLine;
import com.mbartl.viimplementation.command.actions.motion.MotionCommandFactory;
import com.mbartl.viimplementation.command.actions.motion.MoveCurrentWord;
import com.mbartl.viimplementation.command.actions.motion.MoveRight;
import com.mbartl.viimplementation.command.actions.motion.MoveToCharacter;
import com.mbartl.viimplementation.command.actions.motion.MoveToFirstChar;
import com.mbartl.viimplementation.command.actions.motion.MoveToLineBegin;
import com.mbartl.viimplementation.command.actions.motion.MoveToLineEnd;
import com.mbartl.viimplementation.command.actions.scroll.BottomLine;
import com.mbartl.viimplementation.command.actions.scroll.CenterLine;
import com.mbartl.viimplementation.command.actions.scroll.TopLine;
import com.mbartl.viimplementation.command.actions.select.SelectCharacters;
import com.mbartl.viimplementation.command.actions.select.SelectLines;
import com.mbartl.viimplementation.command.actions.select.SelectToBookmark;
import com.mbartl.viimplementation.command.actions.select.SelectToMatchBrace;
import com.mbartl.viimplementation.command.actions.select.SelectionCommandFactory;
import com.mbartl.viimplementation.interfaces.AbstractDocumentAdapter;
import com.mbartl.viimplementation.interfaces.IEditor;
import com.mbartl.viimplementation.interfaces.IUndoManager;
import com.mbartl.viimplementation.layer.Buffer;
import com.mbartl.viimplementation.layer.SelectionManager;
import com.mbartl.viimplementation.layer.ViLayer;
import com.mbartl.viimplementation.layer.ViLayerManager;
import com.mbartl.viimplementation.parser.CommandProperties;
import com.mbartl.viimplementation.parser.ParsedCommand;
import com.mbartl.viimplementation.parser.Parser;
import com.mbartl.viimplementation.preferences.ViPreferenceService;
import com.mbartl.viimplementation.registers.YankBufferHandler;
import com.mbartl.viimplementation.search.Search;
import com.mbartl.viimplementation.search.SearchFactory;
import com.mbartl.viimplementation.util.History;
import com.mbartl.viimplementation.util.Macro;
import com.mbartl.viimplementation.util.RangeCommandEvaluator;
import com.mbartl.viimplementation.util.Region;
import com.mbartl.viimplementation.util.TextUtils;
import com.mbartl.viimplementation.util.WordSeparatorUtils;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class BufferEvaluator {
    public Buffer _buffer;
    private String _prevCmdString = "";
    private final IEditor _editor;
    private final SelectionManager _selectionManager;
    private final ViLayer _viLayer;
    private final Search _search;
    private SearchDelegate _searchDelegate;
    private final IUndoManager _undoManager;
    private final History _extendedCommandHistory;
    private final History _searchCommandHistory;
    private char _lastMoveToChar = (char)32;
    private int _lastMoveToDirection = MoveToCharacter.FORWARD;
    private String _lastSubstitution = "";
    private String _lastSearch = "";
    private boolean _lastMoveToInclusive = true;
    private Macro _macro = null;
    private ReplaceExpressionInSelection _replaceExpressionInSelection = null;

    public BufferEvaluator(ViLayer viLayer) {
        this._viLayer = viLayer;
        this._editor = viLayer.getEditor();
        this._selectionManager = viLayer.getSelectionManager();
        this._buffer = this._viLayer.getBuffer();
        this._extendedCommandHistory = new History();
        this._searchCommandHistory = new History();
        this._search = SearchFactory.getRegExpSearch();
        this._undoManager = this._viLayer.getUndoManager();
    }

    public void appendAndEval(char command) {
        this.appendAndEval(String.valueOf(command));
    }

    public void appendAndEval(String command) {
        this._buffer.append(command);
        this.eval();
    }

    public void backspacePressed() {
        if (this.isColonOrSearchCommand()) {
            this._buffer.setCommand(this._buffer.getCommand().substring(0, this._buffer.getCommand().length() - 1));
        } else if (this._buffer.getCommand().length() == 0) {
            this._buffer.setCommand("h");
        } else {
            this._buffer.setCommand("");
        }
    }

    public void deletePressed() {
        if (this._buffer.getCommand().length() == 0) {
            this._buffer.setCommand("x");
        } else {
            this._buffer.setCommand("");
        }
    }

    public void clear() {
        this._buffer.setCommand("");
        this._searchDelegate = null;
    }

    /*
     * Unable to fully structure code
     */
    public void eval() {
        block86: {
            block85: {
                pc = Parser.parse(this._buffer.getCommand());
                if (pc == null) {
                    this.clear();
                    return;
                }
                if (pc.getOperation().length() == 0) {
                    return;
                }
                uc = pc.isCounterUsed();
                c = pc.getCounter();
                o = pc.getOperation();
                m = pc.getModifier();
                r = pc.getRegister();
                YankBufferHandler.getInstance().setCurrentKey(r);
                visualSelection = null;
                visualSelection = this._viLayer.isInVisualOrVisualLineMode() != false || this._viLayer.isInVisualLineMode() != false ? this._selectionManager.getSelection() : this._editor.getSelection();
                if (visualSelection.getLength() > 0) {
                    this._selectionManager.setInternalSelection(visualSelection.getOffset(), visualSelection.getLength());
                } else {
                    this._selectionManager.setInternalSelection(this._editor.getCaretPosition(), 0);
                }
                if (this._replaceExpressionInSelection != null && !this._replaceExpressionInSelection.isFinished()) {
                    this._replaceExpressionInSelection.next(o);
                    this.clear();
                    if (this._replaceExpressionInSelection.isFinished()) {
                        this._replaceExpressionInSelection = null;
                        return;
                    }
                    this._viLayer.setStatusLine("Replace Occurence: y/n/a/q");
                }
                if (this._searchDelegate == null) break block85;
                if ((o.startsWith("/") || o.startsWith("?")) && o.endsWith("<CU>")) {
                    this.clear();
                    this._buffer.append(this._searchCommandHistory.up());
                    this._searchDelegate = new SearchDelegate(this._search, 0);
                    return;
                }
                if ((o.startsWith("/") || o.startsWith("?")) && o.endsWith("<CD>")) {
                    this.clear();
                    this._buffer.append(this._searchCommandHistory.down());
                    this._searchDelegate = new SearchDelegate(this._search, 0);
                    return;
                }
                if (!o.equals("/" + String.valueOf('\n'))) ** GOTO lbl45
                if (this._lastSearch.length() > 0) {
                    new MoveRight(1, 0).execute();
                    this._buffer.setCommand("/" + this._lastSearch);
                    o = "/" + this._lastSearch;
                } else {
                    this.clear();
                    return;
lbl45:
                    // 1 sources

                    if (o.equals("?" + String.valueOf('\n'))) {
                        if (this._lastSearch.length() > 0) {
                            this._buffer.setCommand("?" + this._lastSearch);
                            o = "?" + this._lastSearch;
                        } else {
                            this.clear();
                            return;
                        }
                    }
                }
                this._searchDelegate.search(o);
                if (this._searchDelegate != null && this._searchDelegate.getSearchState() == 2) {
                    if (this._buffer.getCommand().length() > 0) {
                        this._searchCommandHistory.add(this._buffer.getCommand().substring(0, this._buffer.getCommand().length() - 1));
                        this._lastSearch = this._buffer.getCommand().substring(1);
                    }
                    this._selectionManager.resetSelection();
                    command = this._searchDelegate.getSaveForRepetition();
                    if (command != null) {
                        this.saveForRepetition(command);
                    }
                    this._searchCommandHistory.resetIndex();
                    this.clear();
                } else if (this._searchDelegate != null && this._searchDelegate.getSearchState() == 1) {
                    this._selectionManager.resetSelection();
                    this.clear();
                }
                break block86;
            }
            if (visualSelection.getLength() <= 0 || !this.evalSelectionCommands(o, c, r)) {
                if (o.equals("ZZ")) {
                    this._editor.save();
                    this._editor.quit(true);
                } else if (o.equals("ZQ")) {
                    this._editor.quit(true);
                } else if (o.equals("gd")) {
                    this._editor.callAction("OPEN_DECLARATION");
                    this.clear();
                } else if (o.equals("==")) {
                    new SelectLines(c + 1, 1, false).execute();
                    new IndentSelection().execute();
                    this.clear();
                } else if (o.startsWith("q")) {
                    if (this._macro != null) {
                        this._macro.finish();
                        new AddMacro(this._macro).execute();
                        this._macro = null;
                        this.clear();
                    } else if (m.length() > 0) {
                        this._macro = new Macro(m);
                        this.clear();
                    }
                } else if (o.startsWith("@") && m.length() > 0) {
                    key = m;
                    this.clear();
                    this._undoManager.beginCompoundChange();
                    new ExecuteMacro(c, key).execute();
                    this._undoManager.endCompoundChange();
                } else if (o.equals("z\n") || o.equals("zt") || o.equals("z+")) {
                    new TopLine().execute();
                    this.clear();
                } else if (o.equals("zz") || o.equals("z.")) {
                    new CenterLine().execute();
                    this.clear();
                } else if (o.equals("zb") || o.equals("z-")) {
                    new BottomLine().execute();
                    this.clear();
                } else if (this.isColonCommandComplete(o)) {
                    this.evalColonCommand(pc);
                } else if (o.startsWith(":") && o.endsWith("<CU>")) {
                    this.clear();
                    this._buffer.append(this._extendedCommandHistory.up());
                } else if (o.startsWith(":") && o.endsWith("<CD>")) {
                    this.clear();
                    this._buffer.append(this._extendedCommandHistory.down());
                } else if (!this.evalMotionCommand(o, c, uc) && !this.evalViModeChangeCommand(o, c, r)) {
                    if (pc.isYankCommand()) {
                        this.evalYankCommand(o, m, c, r);
                    } else if (pc.isDeleteCommand()) {
                        this.evalDeleteCommand(pc);
                    } else if (!this.evalShiftCommand(o, m, c)) {
                        if (pc.isChangeCaseCommand()) {
                            this.evalChangeCaseCommand(o, m, c);
                        } else if (o.equals(".")) {
                            this.repeatLastCommand(c);
                        } else if (o.equals("/")) {
                            this._searchDelegate = new SearchDelegate(this._search, 0);
                        } else if (o.equals("?")) {
                            this._searchDelegate = new SearchDelegate(this._search, 1);
                        } else if (o.equals("P")) {
                            this.saveForRepetition();
                            new PasteAbove(c, r).execute();
                            this.clear();
                        } else if (o.equals("p")) {
                            this.saveForRepetition();
                            new PasteBelow(c, r).execute();
                            this.clear();
                        } else if (o.startsWith("r") && o.length() > 1) {
                            this.saveForRepetition();
                            new SelectCharacters(c).execute();
                            new ReplaceSelection(m).execute();
                            this.clear();
                        } else if (o.equals("J")) {
                            this.saveForRepetition();
                            new JoinLine(c).execute();
                            this.clear();
                        } else if (o.startsWith("m") && m.length() == 1) {
                            new AddBookmark(m).execute();
                            this.clear();
                        } else if (o.startsWith("'") && m.length() == 1) {
                            new GotoBookmark(m, 0).execute();
                            this.clear();
                        } else if (o.startsWith("`") && m.length() == 1) {
                            new GotoBookmark(m, 1).execute();
                            this.clear();
                        } else if (o.equals("u")) {
                            levels = ViPreferenceService.getInstance().getInt("undolevels");
                            if (levels > 1) {
                                i = 0;
                                while (i < c) {
                                    this._undoManager.undo();
                                    ++i;
                                }
                            } else if (this._undoManager.canUndo()) {
                                this._undoManager.undo();
                            } else {
                                this._undoManager.redo();
                            }
                            this.clear();
                        } else if (o.equals("U")) {
                            i = 0;
                            while (i < c) {
                                this._undoManager.redo();
                                ++i;
                            }
                            this.clear();
                        } else if (o.charAt(o.length() - 1) == '\u001b') {
                            this.clear();
                        }
                    }
                }
            }
        }
    }

    public boolean isColonOrSearchCommand() {
        return this._buffer.getCommand().startsWith(":") || this._buffer.getCommand().startsWith("/") || this._buffer.getCommand().startsWith("?");
    }

    private boolean isColonCommandComplete(String o) {
        return o.startsWith(":") && o.endsWith(String.valueOf('\n'));
    }

    private boolean evalViModeChangeCommand(String o, int c, String r) {
        String saveForRepition = this._buffer.getCommand();
        if (o.equals("i")) {
            this._viLayer.switchToInsertMode();
        } else if (o.equals("a")) {
            new MoveRight(1, 1).execute();
            this._viLayer.switchToInsertMode();
        } else if (o.equals("I")) {
            new MoveToFirstChar().execute();
            this._viLayer.switchToInsertMode();
        } else if (o.equals("A")) {
            new MoveToLineEnd(true).execute();
            this._viLayer.switchToInsertMode();
        } else if (o.equals("s")) {
            this._undoManager.beginCompoundChange();
            new SelectCharacters(c).execute();
            new DeleteSelection(r, false).execute();
            this._viLayer.switchToInsertMode();
        } else if (o.equals("o")) {
            this._undoManager.beginCompoundChange();
            new NewLineBelow(true).execute();
            this._viLayer.switchToInsertMode();
        } else if (o.equals("O")) {
            this._undoManager.beginCompoundChange();
            new NewLineAbove(true).execute();
            this._viLayer.switchToInsertMode();
        } else if (o.equals("v")) {
            this._viLayer.toggleVisualMode();
        } else if (o.equals("V")) {
            this._viLayer.toggleVisualLineMode();
        } else if (o.equals("R")) {
            this._viLayer.switchToReplaceMode();
        } else {
            return false;
        }
        this.saveForRepetition(saveForRepition);
        return true;
    }

    private boolean evalShiftCommand(String o, String m, int c) {
        boolean left = true;
        if (o.startsWith(">")) {
            left = false;
        } else if (!o.startsWith("<")) {
            return false;
        }
        if (m.startsWith("'") && m.length() > 1) {
            new SelectToBookmark(m.charAt(1), 0, false).execute();
        } else if (m.startsWith("`") && m.length() > 1) {
            new SelectToBookmark(m.charAt(1), 1, false).execute();
        } else if (m.startsWith("%")) {
            new SelectToMatchBrace().execute();
        } else if (!(m.equals(">") || m.equals("<") || m.equals("h") || m.equals("l"))) {
            if (m.equals("j")) {
                new SelectLines(c + 1, 1, false).execute();
            } else if (m.equals("k")) {
                new SelectLines(c, 0, false).execute();
            } else if (m.equals("G")) {
                new SelectLines(this._viLayer.getDocumentAnalyzer().getNumberOfLines(), 1, false).execute();
            } else {
                return false;
            }
        }
        this.saveForRepetition();
        new ShiftSelection(c, left).execute();
        this.clear();
        return true;
    }

    private void evalChangeCaseCommand(String o, String m, int c) {
        if (o.equals("~")) {
            new SelectCharacters(c).execute();
            new MoveRight(1, 0).execute();
            this._undoManager.beginCompoundChange();
            new ChangeCaseSelection(2).execute();
            this._undoManager.endCompoundChange();
        } else if (o.equals("guu")) {
            new SelectLines(1, 1, false).execute();
            new ChangeCaseSelection(1).execute();
            new MoveToLineBegin().execute();
        } else if (o.equals("gUU")) {
            new SelectLines(1, 1, false).execute();
            new ChangeCaseSelection(0).execute();
            new MoveToLineBegin().execute();
        } else if (o.startsWith("g") && m.length() > 1) {
            int mode = 1;
            if (o.charAt(1) == 'U') {
                mode = 0;
            } else if (o.charAt(1) == '~') {
                mode = 2;
            }
            String mod = m.substring(1);
            Command select = SelectionCommandFactory.createCommand(mod, c);
            if (select != null) {
                select.execute();
                this._undoManager.beginCompoundChange();
                new ChangeCaseSelection(mode).execute();
                this._undoManager.endCompoundChange();
            }
        } else {
            return;
        }
        this.saveForRepetition();
        this.clear();
    }

    private void evalDeleteCommand(ParsedCommand pc) {
        Command command;
        boolean includeLastDelimiter = pc.getOperation().startsWith("d");
        boolean cursorOnWhiteSpace = false;
        boolean cursorOnWordEnd = false;
        AbstractDocumentAdapter document = this._viLayer.getDocument();
        int pos = this._editor.getCaretPosition();
        if (!this._viLayer.getDocumentAnalyzer().isEmptyDocument() && pos < document.getLength() - 2) {
            char currentChar = document.getText(pos, 1).charAt(0);
            cursorOnWhiteSpace = Character.isWhitespace(currentChar);
            char nextChar = document.getText(pos + 1, 1).charAt(0);
            boolean bl = cursorOnWordEnd = WordSeparatorUtils.isWordCharacter(currentChar) && this._viLayer.getWordSeparatorUtils().isWordEnding(nextChar, true);
        }
        if ((command = DeleteCommandFactory.createCommand(pc, includeLastDelimiter, cursorOnWhiteSpace, cursorOnWordEnd)) != null) {
            command.execute();
        } else if (!pc.getModifier().equals(";") && !pc.getModifier().equals(",")) {
            if ((pc.getOperation().startsWith("c") || pc.getOperation().startsWith("d")) && pc.getModifier().startsWith("/")) {
                ArrayList<Command> commands = new ArrayList<Command>();
                commands.add(new ExtendSelectionToOffset(this._editor.getCaretPosition()));
                commands.add(new DeleteSelection(pc.getRegister(), !pc.isInsertModeCommand()));
                if (pc.getOperation().startsWith("c")) {
                    commands.add(new SwitchToInsertModeCommand());
                }
                this._searchDelegate = new SearchDelegate(this._search, 0, new GroupCommand(commands), pc.getOperation().substring(0, 1));
                this._buffer.setCommand(pc.getModifier());
                this.eval();
                return;
            }
            return;
        }
        this._undoManager.beginCompoundChange();
        new DeleteSelection(pc.getRegister(), !pc.isInsertModeCommand()).execute();
        this.saveForRepetition();
        if (pc.isInsertModeCommand()) {
            this._viLayer.switchToInsertMode();
            if (pc.getOperation().equals("cc") || pc.getOperation().equals("S")) {
                this._editor.callAction("INDENT_LINE");
            }
        } else {
            this._undoManager.endCompoundChange();
        }
        this.clear();
    }

    private boolean evalSelectionCommands(String o, int c, String r) {
        this._prevCmdString = "";
        if (o.equals("x")) {
            int characters = this._selectionManager.getSelection().getLength();
            new DeleteSelection(r, true).execute();
            this.saveForRepetition(String.valueOf(String.valueOf(characters)) + "x");
        } else if (o.equals("X") || o.equals("D")) {
            this._selectionManager.expandCurrentSelectionToFullLines();
            int lines = this._viLayer.getDocumentAnalyzer().getNumberofLines(this._selectionManager.getSelection()) - 1;
            new DeleteSelection(r, true).execute();
            this.saveForRepetition(String.valueOf(String.valueOf(lines)) + "dd");
        } else if (o.equals("d")) {
            Region selection = this._selectionManager.getSelection();
            int characters = selection.getLength();
            new DeleteSelection(r, true).execute();
            this.saveForRepetition(String.valueOf(String.valueOf(characters)) + "x");
        } else if (o.equals("c") || o.equals("s")) {
            Region selection = this._selectionManager.getSelection();
            int characters = selection.getLength();
            new DeleteSelection(r, false).execute();
            this.saveForRepetition(String.valueOf(String.valueOf(characters)) + "cl");
            this._viLayer.switchToCommandMode();
            this._viLayer.switchToInsertMode();
        } else if (o.equals("S")) {
            this._selectionManager.expandCurrentSelectionToFullLines();
            int lines = this._viLayer.getDocumentAnalyzer().getNumberofLines(this._selectionManager.getSelection()) - 1;
            new DeleteSelection(r, true).execute();
            new NewLineAbove(false).execute();
            this.saveForRepetition(String.valueOf(String.valueOf(lines)) + "S");
            this._viLayer.switchToCommandMode();
            this._viLayer.switchToInsertMode();
        } else if (o.equalsIgnoreCase("y")) {
            new YankSelection(r).execute();
        } else if (o.equals("~")) {
            Region selection = this._selectionManager.getSelection();
            int characters = selection.getLength();
            new ChangeCaseSelection(2).execute();
            this.saveForRepetition(String.valueOf(String.valueOf(characters)) + "~");
        } else if (o.equals("<")) {
            int lines = this._viLayer.getDocumentAnalyzer().getNumberofLines(this._selectionManager.getSelection());
            new ShiftSelection(c, true).execute();
            this.saveForRepetition(String.valueOf(String.valueOf(lines)) + "<<");
        } else if (o.equals(">")) {
            int lines = this._viLayer.getDocumentAnalyzer().getNumberofLines(this._selectionManager.getSelection());
            new ShiftSelection(c, false).execute();
            this.saveForRepetition(String.valueOf(String.valueOf(lines)) + ">>");
        } else if (o.equals("u")) {
            Region selection = this._selectionManager.getSelection();
            int characters = selection.getLength();
            new ChangeCaseSelection(1).execute();
            this.saveForRepetition(String.valueOf(String.valueOf(characters)) + "gul");
        } else if (o.equals("U")) {
            Region selection = this._selectionManager.getSelection();
            int characters = selection.getLength();
            new ChangeCaseSelection(0).execute();
            this.saveForRepetition(String.valueOf(String.valueOf(characters)) + "gUl");
        } else if (o.equals("==")) {
            new IndentSelection().execute();
        } else {
            return false;
        }
        this.clear();
        if (this._viLayer.isInVisualOrVisualLineMode()) {
            this._viLayer.switchToCommandMode();
        }
        return true;
    }

    private void evalYankCommand(String o, String m, int c, String r) {
        Command select = SelectionCommandFactory.createCommand(m, c);
        if (select != null) {
            select.execute();
        } else if (m.equals("y") || o.equals("Y")) {
            new SelectLines(c, 1, true).execute();
        } else if (!m.equals(";") && !m.equals(",")) {
            if (o.startsWith("y") && m.startsWith("/")) {
                ArrayList<Command> commands = new ArrayList<Command>();
                commands.add(new ExtendSelectionToOffset(this._editor.getCaretPosition()));
                commands.add(new YankSelection(r));
                this._searchDelegate = new SearchDelegate(this._search, 0, new GroupCommand(commands), o.substring(0, 1));
                this._buffer.setCommand(m);
                this.eval();
                return;
            }
            return;
        }
        new YankSelection(r).execute();
        this.clear();
    }

    private boolean evalMotionCommand(String o, int c, boolean uc) {
        block21: {
            Command command = MotionCommandFactory.createCommand(o, c, uc, this._viLayer.isInVisualOrVisualLineMode());
            if (command != null) {
                command.execute();
                break block21;
            }
            if (o.equals("n")) {
                Region region = this._search.searchNext(this._viLayer.getDocument().get(), this._editor.getCaretPosition());
                if (region != null) {
                    if (this._editor.getCaretPosition() > region.getOffset()) {
                        this._viLayer.setStatusLine("Search hit BOTTOM. Continue at TOP!");
                    }
                    this._editor.setCaretPosition(region.getOffset());
                }
                break block21;
            }
            if (o.equals("N")) {
                Region region = this._search.searchPrevious(this._viLayer.getDocument().get(), this._editor.getCaretPosition());
                if (region != null) {
                    if (this._editor.getCaretPosition() < region.getOffset()) {
                        this._viLayer.setStatusLine("Search hit TOP. Continue at BOTTOM!");
                    }
                    this._editor.setCaretPosition(region.getOffset());
                }
                break block21;
            }
            if (o.equals("*")) {
                new MoveCurrentWord(c, true).execute();
                break block21;
            }
            if (o.equals("#")) {
                new MoveCurrentWord(c, false).execute();
                break block21;
            }
            if (o.startsWith("t") && o.length() > 1) {
                new MoveToCharacter(c, o.charAt(1), false, MoveToCharacter.FORWARD).execute();
                this.setLastMoveToCommand(o.charAt(1), false, MoveToCharacter.FORWARD);
                break block21;
            }
            if (o.startsWith("f") && o.length() > 1) {
                new MoveToCharacter(c, o.charAt(1), true, MoveToCharacter.FORWARD).execute();
                this.setLastMoveToCommand(o.charAt(1), true, MoveToCharacter.FORWARD);
                break block21;
            }
            if (o.startsWith("T") && o.length() > 1) {
                new MoveToCharacter(c, o.charAt(1), false, MoveToCharacter.BACKWARD).execute();
                this.setLastMoveToCommand(o.charAt(1), false, MoveToCharacter.BACKWARD);
                break block21;
            }
            if (o.startsWith("F") && o.length() > 1) {
                new MoveToCharacter(c, o.charAt(1), true, MoveToCharacter.BACKWARD).execute();
                this.setLastMoveToCommand(o.charAt(1), true, MoveToCharacter.BACKWARD);
                break block21;
            }
            if (o.equals(";")) {
                new MoveToCharacter(c, this._lastMoveToChar, this._lastMoveToInclusive, this._lastMoveToDirection).execute();
                break block21;
            }
            if (o.equals(",")) {
                if (this._lastMoveToDirection == MoveToCharacter.FORWARD) {
                    new MoveToCharacter(c, this._lastMoveToChar, this._lastMoveToInclusive, MoveToCharacter.BACKWARD).execute();
                } else {
                    new MoveToCharacter(c, this._lastMoveToChar, this._lastMoveToInclusive, MoveToCharacter.FORWARD).execute();
                }
                break block21;
            }
            return false;
        }
        try {
            if (this._viLayer.isInVisualOrVisualLineMode()) {
                this._selectionManager.updateVisualSelection(this._editor.getCaretPosition());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.clear();
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean evalColonCommand(ParsedCommand pc) {
        o = pc.getOperation().substring(1, pc.getOperation().length() - 1);
        range = pc.getRange();
        if (range != null) {
            RangeCommandEvaluator.evalRegion(range, this._viLayer.getDocumentAnalyzer(), this._selectionManager, this._editor);
            this._extendedCommandHistory.add(":" + range + o);
        } else {
            this._extendedCommandHistory.add(":" + o);
        }
        try {
            line = Integer.parseInt(o);
        }
        catch (NumberFormatException e) {
            line = -1;
        }
        if (o.startsWith("d")) {
            new DeleteSelection(pc.getRegister(), false).execute();
        } else if (o.equals("c")) {
            new DeleteSelection(pc.getRegister(), false).execute();
            new SwitchToInsertModeCommand().execute();
        } else if (o.equals(">")) {
            new ShiftSelection(1, false).execute();
        } else if (o.equals("<")) {
            new ShiftSelection(1, true).execute();
        } else if (o.equals("y")) {
            new YankSelection(pc.getRegister()).execute();
        } else if (o.startsWith("t")) {
            destinationLinePos = RangeCommandEvaluator.convertToLineNumber(o.substring(1), this._viLayer.getDocumentAnalyzer(), this._editor);
            new YankSelection(pc.getRegister()).execute();
            new GotoLine(destinationLinePos, 0, false).execute();
            new PasteBelow(1, pc.getRegister()).execute();
        } else if (o.equals("q")) {
            this._editor.quit(false);
        } else if (o.equals("q!")) {
            this._editor.quit(true);
        } else if (o.equals("u")) {
            this._undoManager.undo();
        } else if (o.equals("w")) {
            this._editor.save();
        } else if (o.equals("wq") || o.equals("x")) {
            this._editor.save();
            this._editor.quit(false);
        } else if (o.equals("wq!")) {
            this._editor.save();
            this._editor.quit(true);
        } else if (o.equals("wa")) {
            ViLayerManager.getInstance().getEditorManager().saveAll();
        } else if (o.equals("e!")) {
            this._editor.revertToSaved();
        } else if (o.startsWith("n")) {
            ViLayerManager.getInstance().getEditorManager().next();
        } else if (o.startsWith("prev") || o.startsWith("N")) {
            ViLayerManager.getInstance().getEditorManager().previous();
        } else if (line != -1) {
            new GotoLine(line - 1, 0, true).execute();
        } else if (o.equals("$")) {
            new GotoLastLine().execute();
        } else if (o.startsWith("set")) {
            this.evalPreferenceSetting(o);
        } else if (o.startsWith("s/")) {
            try {
                this._replaceExpressionInSelection = new ReplaceExpressionInSelection(o);
                this._replaceExpressionInSelection.execute();
                this._prevCmdString = ":" + o + String.valueOf('\r');
                this.saveLastSubstitution(o);
                if (!this._replaceExpressionInSelection.isFinished()) ** GOTO lbl98
                this._replaceExpressionInSelection = null;
            }
            catch (Exception e) {
                this._viLayer.showDialog("Error: Invalid Command", "usage: :[%]s/search/replace[/g]");
                return false;
            }
        } else if (this._lastSubstitution.length() > 0 && o.equals("%s") || o.equals("s")) {
            try {
                new ReplaceExpressionInSelection(String.valueOf(o) + "/" + this._lastSubstitution).execute();
                this._prevCmdString = ":" + o + String.valueOf('\r');
            }
            catch (Exception e) {
                this._viLayer.showDialog("Error: Invalid Command", "usage: :[%]s/search/replace[/g]");
                return false;
            }
        } else {
            this.clear();
            return false;
        }
lbl98:
        // 22 sources

        this._extendedCommandHistory.resetIndex();
        this.clear();
        return true;
    }

    private void evalPreferenceSetting(String command) {
        if (command.equals("set")) {
            this._viLayer.showDialog("Preferences", ViPreferenceService.getInstance().getPreferences().toString());
        }
        try {
            String preference = command.substring(4);
            StringTokenizer st = new StringTokenizer(preference, "=");
            if (st.hasMoreTokens()) {
                String name = st.nextToken();
                String value = null;
                if (st.hasMoreTokens()) {
                    value = st.nextToken();
                }
                ViPreferenceService.getInstance().set(name, value);
            }
        }
        catch (IndexOutOfBoundsException preference) {
            // empty catch block
        }
        if (command.equals("set nohlsearch")) {
            this._editor.resetHighlighting(true);
        } else if (command.startsWith("set undolevels")) {
            int levels = ViPreferenceService.getInstance().getInt("undolevels");
            if (levels == 0) {
                levels = 1;
            }
            this._undoManager.setUndoLevels(levels);
        } else if (command.startsWith("set number")) {
            this._editor.setLineNumbers(true);
        } else if (command.startsWith("set nonumber")) {
            this._editor.setLineNumbers(false);
        }
    }

    private void setLastMoveToCommand(char ch, boolean inclusive, int direction) {
        this._lastMoveToChar = ch;
        this._lastMoveToInclusive = inclusive;
        this._lastMoveToDirection = direction;
    }

    private void saveForRepetition() {
        this._prevCmdString = this._buffer.getCommand();
    }

    private void saveForRepetition(String command) {
        this._prevCmdString = command;
    }

    private void repeatLastCommand(int counter) {
        if (this._prevCmdString.length() == 0) {
            this.clear();
            return;
        }
        int i = 0;
        while (i < counter) {
            String insertBuffer = this._viLayer.getInsertBuffer().toString();
            this._buffer.setCommand("");
            int j = 0;
            while (j < this._prevCmdString.length()) {
                this._buffer.setCommand(String.valueOf(this._buffer.getCommand()) + this._prevCmdString.charAt(j));
                this.eval();
                ++j;
            }
            ParsedCommand prevPc = Parser.parse(this._prevCmdString);
            CommandProperties.setCommandProperties(prevPc);
            if (prevPc.isInsertModeCommand()) {
                new ReplayInsertCommand(insertBuffer, 0).execute();
                this._viLayer.setInsertBuffer(new StringBuffer(insertBuffer));
                this._viLayer.switchToCommandMode();
            }
            if (prevPc.getOperation().equals("R")) {
                new ReplayInsertCommand(insertBuffer, 1).execute();
                this._viLayer.setInsertBuffer(new StringBuffer(insertBuffer));
                this._viLayer.switchToCommandMode();
            }
            ++i;
        }
    }

    private void saveLastSubstitution(String command) {
        int idx = command.indexOf("/");
        if (idx != -1) {
            this._lastSubstitution = command.substring(idx + 1);
        }
    }

    public void executeMultipleInsertModeCommand() {
        ParsedCommand pc = Parser.parse(this._prevCmdString);
        if (pc.getCounter() > 1 && (pc.isSimpleInsertModeCommand() || pc.getOperation().equals("R"))) {
            String multipliedInsertBuffer = TextUtils.multiplyString(this._viLayer.getInsertBuffer().toString(), pc.getCounter() - 1);
            if (pc.isSimpleInsertModeCommand()) {
                new ReplayInsertCommand(multipliedInsertBuffer, 0).execute();
            } else {
                new ReplayInsertCommand(multipliedInsertBuffer, 1).execute();
            }
            this._viLayer.setInsertBuffer(new StringBuffer(String.valueOf(multipliedInsertBuffer) + this._viLayer.getInsertBuffer()));
        }
    }

    public Macro getMacro() {
        return this._macro;
    }
}

