/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.command.actions.select;

import com.mbartl.viimplementation.command.actions.Command;
import com.mbartl.viimplementation.command.actions.select.SelectLines;
import com.mbartl.viimplementation.layer.BookmarkHandler;
import com.mbartl.viimplementation.util.Region;

public class SelectToBookmark
extends Command {
    public static final int LINE = 0;
    public static final int CHARACTER = 1;
    private final int _pos;
    private final int _type;
    private final boolean _includeDelimiter;

    public SelectToBookmark(char mark, int type, boolean includeDelimiter) {
        this._pos = BookmarkHandler.getBookMarkPosition(String.valueOf(mark));
        this._type = type;
        this._includeDelimiter = includeDelimiter;
    }

    public void execute() {
        if (this._pos == -1) {
            return;
        }
        int startPos = this._editor.getCaretPosition();
        if (this._type == 0) {
            int lines;
            int direction;
            int startLine = this._analyzer.getLinePosOfOffset(startPos);
            int endLine = this._analyzer.getLinePosOfOffset(this._pos);
            if (endLine - startLine < 0) {
                direction = 0;
                lines = startLine - endLine;
            } else {
                direction = 1;
                lines = endLine - startLine + 1;
            }
            if (lines == -1) {
                return;
            }
            new SelectLines(lines, direction, this._includeDelimiter).execute();
        } else {
            Region region = new Region(startPos, this._pos - startPos);
            this._selectionManager.setInternalSelection(Region.normalize(region));
        }
    }
}

