/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.command.actions.motion;

import com.mbartl.viimplementation.command.actions.motion.MotionCommand;
import com.mbartl.viimplementation.util.Line;

public class MoveRight
extends MotionCommand {
    public static final int STOP_AT_LASTCHAR = 0;
    public static final int STOP_AFTER_LASTCHAR = 1;
    public static final int JUMP_TO_NEXT_LINE = 2;
    private int _mode;

    public MoveRight(int counter, int mode) {
        super(counter);
        this._mode = mode;
    }

    public void execute() {
        if (this._analyzer.isEmptyDocument()) {
            return;
        }
        int cursorPos = this._editor.getCaretPosition();
        int newPos = Math.min(cursorPos + this._counter, this._document.getLength());
        Line startLine = this._analyzer.getLineOfOffset(cursorPos);
        if (this._mode == 2) {
            int endLinePos = this._analyzer.getLinePosOfOffset(newPos);
            Line endLine = this._analyzer.getLine(endLinePos);
            int delimiterPos = endLine.getOffsetEndWithoutDelimiter();
            int delimiterLength = endLine.getDelimiter().length();
            if (endLinePos != this._analyzer.getNumberOfLines() - 1 && newPos >= delimiterPos && newPos < delimiterPos + delimiterLength) {
                newPos = this._analyzer.getLine(endLinePos + 1).getOffset();
            }
        } else if (this._mode == 0) {
            int end = startLine.getOffsetEndWithoutDelimiter() - 1;
            newPos = Math.min(newPos, end);
        } else {
            int end = startLine.getOffsetEndWithoutDelimiter();
            newPos = Math.min(newPos, end);
        }
        this._editor.setCaretPosition(newPos);
        this._viLayer.getCursorInLinePosition().setCurrentCursorInLinePosition();
    }
}

