/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.command.actions.motion;

import com.mbartl.viimplementation.command.actions.Command;
import com.mbartl.viimplementation.command.actions.MatchBrace;
import com.mbartl.viimplementation.command.actions.motion.GotoBottomLine;
import com.mbartl.viimplementation.command.actions.motion.GotoLastLine;
import com.mbartl.viimplementation.command.actions.motion.GotoLine;
import com.mbartl.viimplementation.command.actions.motion.GotoMiddleLine;
import com.mbartl.viimplementation.command.actions.motion.GotoTopLine;
import com.mbartl.viimplementation.command.actions.motion.MoveDown;
import com.mbartl.viimplementation.command.actions.motion.MoveLeft;
import com.mbartl.viimplementation.command.actions.motion.MoveRight;
import com.mbartl.viimplementation.command.actions.motion.MoveToFirstChar;
import com.mbartl.viimplementation.command.actions.motion.MoveToLineBegin;
import com.mbartl.viimplementation.command.actions.motion.MoveToLineEnd;
import com.mbartl.viimplementation.command.actions.motion.MoveToNextBlankLine;
import com.mbartl.viimplementation.command.actions.motion.MoveToPreviousBlankLine;
import com.mbartl.viimplementation.command.actions.motion.MoveUp;
import com.mbartl.viimplementation.command.actions.motion.MoveWordBack;
import com.mbartl.viimplementation.command.actions.motion.MoveWordEnd;
import com.mbartl.viimplementation.command.actions.motion.MoveWordForward;
import com.mbartl.viimplementation.command.actions.motion.ScrollDown;
import com.mbartl.viimplementation.command.actions.motion.ScrollUp;

public class MotionCommandFactory {
    public static Command createCommand(String operation, int counter, boolean useCounter, boolean inVisualMode) {
        String o = operation;
        int c = counter;
        Command command = null;
        if (o.equals("h")) {
            command = new MoveLeft(c, false);
        } else if (o.equals("<CL>")) {
            command = new MoveLeft(c, true);
        } else if (o.equals("l")) {
            command = inVisualMode ? new MoveRight(c, 1) : new MoveRight(c, 0);
        } else if (o.equals("<CR>") || o.equals(" ")) {
            command = new MoveRight(c, 2);
        } else if (o.equals("j") || o.equals("<CD>")) {
            command = new MoveDown(c);
        } else if (o.equals(String.valueOf('\n'))) {
            command = new MoveDown(c, 2);
        } else if (o.equals("k") || o.equals("<CU>")) {
            command = new MoveUp(c);
        } else if (o.equals("w")) {
            command = new MoveWordForward(c, false);
        } else if (o.equals("W")) {
            command = new MoveWordForward(c, true);
        } else if (o.equals("b")) {
            command = new MoveWordBack(c, false);
        } else if (o.equals("B")) {
            command = new MoveWordBack(c, true);
        } else if (o.equals("e")) {
            command = new MoveWordEnd(c, false);
        } else if (o.equals("gg")) {
            command = new GotoLine(0, 0, true);
        } else if (o.equals("G")) {
            command = useCounter ? new GotoLine(c - 1, 0, true) : new GotoLastLine();
        } else if (o.equals("0")) {
            command = new MoveToLineBegin();
        } else if (o.equals("$")) {
            command = new MoveToLineEnd(inVisualMode);
        } else if (o.equals("^")) {
            command = new MoveToFirstChar();
        } else if (o.equals("<SU>")) {
            command = new ScrollUp(c);
        } else if (o.equals("<SD>")) {
            command = new ScrollDown(c);
        } else if (o.equals("}")) {
            command = new MoveToNextBlankLine(c);
        } else if (o.equals("{")) {
            command = new MoveToPreviousBlankLine(c);
        } else if (o.equals("%")) {
            command = new MatchBrace();
        } else if (o.equals("E")) {
            command = new MoveWordEnd(c, true);
        } else if (o.equals("H")) {
            command = new GotoTopLine(c);
        } else if (o.equals("L")) {
            command = new GotoBottomLine(c);
        } else if (o.equals("M")) {
            command = new GotoMiddleLine(c);
        } else if (o.equals("+")) {
            command = new MoveDown(c, 2);
        } else if (o.equals("-")) {
            command = new MoveUp(c, 2);
        } else if (o.equals("_")) {
            command = new MoveDown(c - 1, 2);
        }
        return command;
    }
}

