/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.command.actions.motion;

import com.mbartl.viimplementation.command.actions.motion.MotionCommand;
import com.mbartl.viimplementation.command.actions.motion.MoveToFirstChar;
import com.mbartl.viimplementation.layer.BookmarkHandler;
import com.mbartl.viimplementation.util.BookMark;
import com.mbartl.viimplementation.util.Line;

public class GotoLine
extends MotionCommand {
    public static final int LINEBEGIN = 0;
    public static final int NORMAL = 1;
    public static final int FIRSTCHAR = 2;
    private int _mode;
    private boolean _saveJump;

    public GotoLine(int linenr, int mode, boolean saveJump) {
        super(linenr);
        this._mode = mode;
        this._saveJump = saveJump;
    }

    public void execute() {
        if (this._analyzer.isEmptyDocument()) {
            return;
        }
        if (this._saveJump) {
            BookMark bookMark = new BookMark("'", this._editor.getCaretPosition());
            BookmarkHandler.set(bookMark);
        }
        int linenr = Math.max(0, this._counter);
        linenr = Math.min(linenr, this._analyzer.getNumberOfLines() - 1);
        Line line = this._analyzer.getLine(linenr);
        int newPos = line.getOffset();
        if (this._mode == 1) {
            int cursorInLinePosition = this._viLayer.getCursorInLinePosition().getCursorInLinePosition();
            int maxLineOffset = Math.max(0, line.getLengthWithoutDelimiter() - 1);
            newPos += Math.min(cursorInLinePosition, maxLineOffset);
        }
        this._editor.setCaretPosition(newPos);
        if (this._mode == 2) {
            new MoveToFirstChar().execute();
            this._viLayer.getCursorInLinePosition().setCurrentCursorInLinePosition();
        }
    }
}

