/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.command.actions.delete;

import com.mbartl.viimplementation.command.actions.Command;
import com.mbartl.viimplementation.command.actions.YankSelection;
import com.mbartl.viimplementation.command.actions.motion.CheckValidCursorPosition;
import com.mbartl.viimplementation.util.Region;

public class DeleteSelection
extends Command {
    private final String _register;
    private final boolean _checkValidCursorPos;

    public DeleteSelection(String register, boolean checkValidCursorPos) {
        this._register = register;
        this._checkValidCursorPos = checkValidCursorPos;
    }

    public void execute() {
        Region selection = this._selectionManager.getSelection();
        if (selection.getLength() == 0) {
            return;
        }
        new YankSelection(this._register).execute();
        boolean deletePreviousDelimiter = this.isRegionAtDocumentEnd(selection);
        int start = Math.max(selection.getOffset(), 0);
        int end = selection.getLength();
        if (deletePreviousDelimiter) {
            int previousLinePos = this._analyzer.getLinePosOfOffset(selection.getOffset()) - 1;
            int delimiterLength = this._analyzer.getLine(previousLinePos).getDelimiter().length();
            start -= delimiterLength;
            end += delimiterLength;
        }
        this._document.replace(start, end, "");
        this._selectionManager.resetSelection();
        this._editor.setCaretPosition(start);
        if (this._checkValidCursorPos) {
            new CheckValidCursorPosition().execute();
        }
    }

    public boolean isRegionAtDocumentEnd(Region selection) {
        int i = 2;
        while (i < this._analyzer.getNumberOfLines()) {
            if (selection.getOffset() == this._analyzer.getLine(i).getOffset() && selection.getOffsetEnd() == this._document.getLength()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

