/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse;

import com.mbartl.viimplementation.interfaces.ICaret;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Caret;

public class ViCaret
implements ICaret {
    private final StyledText _textWidget;
    private final Caret _caret;
    private final Point _originalSize;
    private static final int CARET_THIN = 1;

    public ViCaret(StyledText textWidget) {
        this._caret = textWidget.getCaret();
        this._originalSize = this._caret.getSize();
        this._caret.setImage(null);
        this._textWidget = textWidget;
    }

    private void setCaretWidth(int width) {
        if (!this._caret.isDisposed()) {
            this._caret.setSize(width, this._caret.getSize().y);
        }
    }

    public void setCaretThin() {
        this.setCaretWidth(1);
    }

    public void setCaretThick() {
        if (!this._caret.isDisposed()) {
            GC gc = new GC((Drawable)this._textWidget);
            this.setCaretWidth(gc.getFontMetrics().getAverageCharWidth());
            gc.dispose();
        }
    }

    public void restoreOriginalCaret() {
        if (!this._caret.isDisposed()) {
            this._caret.setSize(this._originalSize);
        }
    }
}

