/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat;

import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import com.sysdeo.eclipse.tomcat.TomcatPluginResources;
import com.sysdeo.eclipse.tomcat.TomcatProject;
import com.sysdeo.eclipse.tomcat.editors.TomcatDirectoryFieldEditor;
import com.sysdeo.eclipse.tomcat.editors.TomcatFileFieldEditor;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TomcatPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
TomcatPluginResources {
    private BooleanFieldEditor securityEditor;
    private static final int FIELD_WIDTH = 50;
    private RadioGroupFieldEditor version;
    private DirectoryFieldEditor home;
    private TomcatDirectoryFieldEditor contextsDir;
    private TomcatFileFieldEditor configFile;
    private RadioGroupFieldEditor configMode;
    private ModifyListener fModifyListener;
    private String selectedVersion;
    private String oldVersion;

    public TomcatPreferencePage() {
        this.setPreferenceStore(TomcatLauncherPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        final Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.oldVersion = TomcatLauncherPlugin.getDefault().getTomcatVersion();
        this.version = new RadioGroupFieldEditor("tomcatVersion", TomcatPluginResources.PREF_PAGE_CHOOSEVERSION_LABEL, 1, (String[][])new String[][]{{TomcatPluginResources.PREF_PAGE_VERSION3_LABEL, "tomcatV3"}, {TomcatPluginResources.PREF_PAGE_VERSION4_LABEL, "tomcatV4"}, {TomcatPluginResources.PREF_PAGE_VERSION4_1_LABEL, "tomcatV41"}, {TomcatPluginResources.PREF_PAGE_VERSION5_LABEL, "tomcatV5"}}, composite, true);
        Group homeGroup = new Group(composite, 0);
        this.home = new DirectoryFieldEditor("tomcatDir", TomcatPluginResources.PREF_PAGE_HOME_LABEL, (Composite)homeGroup);
        new Label(composite, 0);
        Group modeGroup = new Group(composite, 0);
        modeGroup.setLayout((Layout)new GridLayout(1, false));
        Composite configGroup = new Composite((Composite)modeGroup, 0);
        this.configMode = new RadioGroupFieldEditor("configMode", TomcatPluginResources.PREF_PAGE_CHOOSECONFMODE_LABEL, 1, (String[][])new String[][]{{TomcatPluginResources.PREF_PAGE_SERVERXML_LABEL, "serverFile"}, {TomcatPluginResources.PREF_PAGE_CONTEXTFILES_LABEL, "contextFiles"}}, configGroup, false);
        new Label(composite, 0);
        final Composite configLocationGroup = new Composite((Composite)modeGroup, 0);
        this.configFile = new TomcatFileFieldEditor("tomcatConfigFile", TomcatPluginResources.PREF_PAGE_CONFIGFILE_LABEL, configLocationGroup);
        this.contextsDir = new TomcatDirectoryFieldEditor("contextsDir", TomcatPluginResources.PREF_PAGE_CONTEXTSDIR_LABEL, configLocationGroup);
        this.home.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_value")) {
                    TomcatPreferencePage.this.computeConfigFile();
                    TomcatPreferencePage.this.computeContextsDir();
                }
            }
        });
        new Label(composite, 0);
        this.initLayoutAndData((Composite)homeGroup, 3);
        this.initLayoutAndData(configLocationGroup, 3);
        this.initField((FieldEditor)this.version);
        this.version.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_value")) {
                    String value = (String)event.getNewValue();
                    TomcatPreferencePage.this.versionChanged(composite, value);
                }
            }
        });
        this.initField((FieldEditor)this.home);
        this.initField((FieldEditor)this.configMode);
        this.modeChanged(configLocationGroup, this.getPreferenceStore().getString("configMode"));
        this.configMode.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_value")) {
                    String value = (String)event.getNewValue();
                    TomcatPreferencePage.this.modeChanged(configLocationGroup, value);
                }
            }
        });
        this.initField((FieldEditor)this.configFile);
        if (this.configFile.getStringValue().length() == 0) {
            this.computeConfigFile();
        }
        this.initField((FieldEditor)this.contextsDir);
        if (this.contextsDir.getStringValue().length() == 0) {
            this.computeContextsDir();
        }
        return parent;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.version.store();
        this.home.store();
        this.configFile.store();
        this.configMode.store();
        this.contextsDir.store();
        TomcatLauncherPlugin.getDefault().initTomcatClasspathVariable();
        TomcatLauncherPlugin.getDefault().savePluginPreferences();
        if (!this.oldVersion.equals(TomcatLauncherPlugin.getDefault().getTomcatVersion())) {
            this.updateTomcatProjectsBuildPath();
        }
        return true;
    }

    private void updateTomcatProjectsBuildPath() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        try {
            int i = 0;
            while (i < projects.length) {
                if (projects[i].hasNature("com.sysdeo.eclipse.tomcat.tomcatnature")) {
                    TomcatProject.create(projects[i]).addTomcatJarToProjectClasspath();
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void initField(FieldEditor field) {
        field.setPreferenceStore(this.getPreferenceStore());
        field.setPreferencePage((PreferencePage)this);
        field.load();
    }

    private void computeConfigFile() {
        this.configFile.setStringValue(String.valueOf(this.home.getStringValue()) + File.separator + "conf" + File.separator + "server.xml");
    }

    private void computeContextsDir() {
        if (this.selectedVersion == null) {
            this.selectedVersion = TomcatLauncherPlugin.getDefault().getPreferenceStore().getString("tomcatVersion");
        }
        if (this.selectedVersion.equals("tomcatV5")) {
            this.contextsDir.setStringValue(String.valueOf(this.home.getStringValue()) + File.separator + "conf" + File.separator + "Catalina" + File.separator + "localhost");
        } else {
            this.contextsDir.setStringValue(String.valueOf(this.home.getStringValue()) + File.separator + "webapps");
        }
    }

    private void modeChanged(Composite configLocationGroup, String value) {
        if (value.equals("serverFile")) {
            this.contextsDir.setEnabled(false, configLocationGroup);
            this.configFile.setEnabled(true, configLocationGroup);
        } else {
            this.contextsDir.setEnabled(true, configLocationGroup);
            this.configFile.setEnabled(false, configLocationGroup);
        }
        this.configFile.valueChanged();
        this.contextsDir.valueChanged();
    }

    private void versionChanged(Composite composite, String value) {
        this.selectedVersion = value;
        this.computeContextsDir();
    }

    private void initLayoutAndData(Composite aGroup, int spanH, int spanV, int numColumns) {
        GridLayout gl = new GridLayout(numColumns, false);
        aGroup.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        gd.horizontalSpan = spanH;
        gd.verticalSpan = spanV;
        aGroup.setLayoutData((Object)gd);
    }

    private void initLayoutAndData(Composite aGroup, int numColumns) {
        GridLayout gl = new GridLayout(numColumns, false);
        aGroup.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 400;
        aGroup.setLayoutData((Object)gd);
    }
}

