/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat;

import com.sysdeo.eclipse.tomcat.Tomcat3Bootstrap;
import com.sysdeo.eclipse.tomcat.Tomcat41Bootstrap;
import com.sysdeo.eclipse.tomcat.Tomcat4Bootstrap;
import com.sysdeo.eclipse.tomcat.Tomcat5Bootstrap;
import com.sysdeo.eclipse.tomcat.TomcatBootstrap;
import com.sysdeo.eclipse.tomcat.TomcatProjectChangeListener;
import com.sysdeo.eclipse.tomcat.editors.ProjectListElement;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TomcatLauncherPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.sysdeo.eclipse.tomcat";
    public static final String NATURE_ID = "com.sysdeo.eclipse.tomcat.tomcatnature";
    static final String TOMCAT_PREF_HOME_KEY = "tomcatDir";
    static final String TOMCAT_PREF_BASE_KEY = "tomcatBase";
    static final String TOMCAT_PREF_CONFIGFILE_KEY = "tomcatConfigFile";
    static final String TOMCAT_PREF_VERSION_KEY = "tomcatVersion";
    static final String TOMCAT_PREF_JRE_KEY = "tomcatJRE";
    static final String TOMCAT_PREF_JVM_PARAMETERS_KEY = "jvmParameters";
    static final String TOMCAT_PREF_JVM_CLASSPATH_KEY = "jvmClasspath";
    static final String TOMCAT_PREF_JVM_BOOTCLASSPATH_KEY = "jvmBootClasspath";
    static final String TOMCAT_PREF_PROJECTSINCP_KEY = "projectsInCp";
    static final String TOMCAT_PREF_PROJECTSINSOURCEPATH_KEY = "projectsInSourcePath";
    static final String TOMCAT_PREF_COMPUTESOURCEPATH_KEY = "computeSourcePath";
    static final String TOMCAT_PREF_DEBUGMODE_KEY = "tomcatDebugMode";
    static final String TOMCAT_PREF_TARGETPERSPECTIVE = "targetPerspective";
    static final String TOMCAT_PREF_SECURITYMANAGER = "enabledSecurityManager";
    static final String TOMCAT_PREF_MANAGER_URL = "managerUrl";
    static final String TOMCAT_PREF_MANAGER_USER = "managerUser";
    static final String TOMCAT_PREF_MANAGER_PASSWORD = "managerPassword";
    static final String TOMCAT_VERSION3 = "tomcatV3";
    static final String TOMCAT_VERSION4 = "tomcatV4";
    static final String TOMCAT_VERSION41 = "tomcatV41";
    static final String TOMCAT_VERSION5 = "tomcatV5";
    static final String TOMCAT_PREF_CONFMODE_KEY = "configMode";
    static final String SERVERXML_MODE = "serverFile";
    static final String CONTEXTFILES_MODE = "contextFiles";
    static final String TOMCAT_PREF_CONTEXTSDIR_KEY = "contextsDir";
    private static final String TOMCAT_HOME_CLASSPATH_VARIABLE = "TOMCAT_HOME";
    private static TomcatLauncherPlugin plugin;
    private ResourceBundle resourceBundle;

    public TomcatLauncherPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = PropertyResourceBundle.getBundle("resources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        TomcatLauncherPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new TomcatProjectChangeListener(), 4);
    }

    private void fixTomcatHomeBug() {
        if (this.getPreferenceStore().getString("fixTomcatHomeBug").equals("")) {
            this.getPreferenceStore().setValue("fixTomcatHomeBug", "fixed");
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] projects = root.getProjects();
            try {
                int i = 0;
                while (i < projects.length) {
                    if (projects[i].hasNature(NATURE_ID)) {
                        ArrayList<IClasspathEntry> cp = new ArrayList<IClasspathEntry>(projects.length - 1);
                        IJavaProject javaProject = JavaCore.create((IProject)projects[i]);
                        IClasspathEntry[] classpath = javaProject.getRawClasspath();
                        cp.addAll(Arrays.asList(classpath));
                        int j = 0;
                        while (j < classpath.length) {
                            if (classpath[j].getEntryKind() == 4 && classpath[j].getPath().equals((Object)TomcatLauncherPlugin.getDefault().getTomcatIPath())) {
                                cp.remove(classpath[j]);
                            }
                            ++j;
                        }
                        javaProject.setRawClasspath(cp.toArray(new IClasspathEntry[cp.size()]), null);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                TomcatLauncherPlugin.log(e);
            }
        }
    }

    public static TomcatLauncherPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static Shell getShell() {
        return TomcatLauncherPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = TomcatLauncherPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            this.resourceBundle = PropertyResourceBundle.getBundle("resources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public String getTomcatDir() {
        IPreferenceStore pref = TomcatLauncherPlugin.getDefault().getPreferenceStore();
        return pref.getString(TOMCAT_PREF_HOME_KEY);
    }

    public String getTomcatBase() {
        IPreferenceStore pref = TomcatLauncherPlugin.getDefault().getPreferenceStore();
        return pref.getString(TOMCAT_PREF_BASE_KEY);
    }

    public String getConfigFile() {
        IPreferenceStore pref = TomcatLauncherPlugin.getDefault().getPreferenceStore();
        return pref.getString(TOMCAT_PREF_CONFIGFILE_KEY);
    }

    public String getConfigMode() {
        IPreferenceStore pref = TomcatLauncherPlugin.getDefault().getPreferenceStore();
        return pref.getString(TOMCAT_PREF_CONFMODE_KEY);
    }

    public String getContextsDir() {
        IPreferenceStore pref = TomcatLauncherPlugin.getDefault().getPreferenceStore();
        return pref.getString(TOMCAT_PREF_CONTEXTSDIR_KEY);
    }

    public String getTomcatVersion() {
        IPreferenceStore pref = TomcatLauncherPlugin.getDefault().getPreferenceStore();
        String result = pref.getString(TOMCAT_PREF_VERSION_KEY);
        if (result.equals("")) {
            result = TOMCAT_VERSION4;
        }
        return result;
    }

    public String getTomcatJRE() {
        IPreferenceStore pref = TomcatLauncherPlugin.getDefault().getPreferenceStore();
        String result = pref.getString(TOMCAT_PREF_JRE_KEY);
        if (result.equals("")) {
            result = JavaRuntime.getDefaultVMInstall().getId();
        }
        return result;
    }

    public boolean isDebugMode() {
        IPreferenceStore pref = TomcatLauncherPlugin.getDefault().getPreferenceStore();
        return !pref.getBoolean(TOMCAT_PREF_DEBUGMODE_KEY);
    }

    public String getTargetPerspective() {
        IPreferenceStore pref = TomcatLauncherPlugin.getDefault().getPreferenceStore();
        return pref.getString(TOMCAT_PREF_TARGETPERSPECTIVE);
    }

    public boolean isSecurityManagerEnabled() {
        IPreferenceStore pref = TomcatLauncherPlugin.getDefault().getPreferenceStore();
        return pref.getBoolean(TOMCAT_PREF_SECURITYMANAGER);
    }

    public String getJvmParamaters() {
        IPreferenceStore pref = TomcatLauncherPlugin.getDefault().getPreferenceStore();
        return pref.getString(TOMCAT_PREF_JVM_PARAMETERS_KEY);
    }

    public String getJvmClasspath() {
        IPreferenceStore pref = TomcatLauncherPlugin.getDefault().getPreferenceStore();
        return pref.getString(TOMCAT_PREF_JVM_CLASSPATH_KEY);
    }

    public String getJvmBootClasspath() {
        IPreferenceStore pref = TomcatLauncherPlugin.getDefault().getPreferenceStore();
        return pref.getString(TOMCAT_PREF_JVM_BOOTCLASSPATH_KEY);
    }

    public TomcatBootstrap getTomcatBootstrap() {
        TomcatBootstrap tomcatBootsrap = null;
        if (this.getTomcatVersion().equals(TOMCAT_VERSION3)) {
            tomcatBootsrap = new Tomcat3Bootstrap();
        }
        if (this.getTomcatVersion().equals(TOMCAT_VERSION4)) {
            tomcatBootsrap = new Tomcat4Bootstrap();
        }
        if (this.getTomcatVersion().equals(TOMCAT_VERSION41)) {
            tomcatBootsrap = new Tomcat41Bootstrap();
        }
        if (this.getTomcatVersion().equals(TOMCAT_VERSION5)) {
            tomcatBootsrap = new Tomcat5Bootstrap();
        }
        return tomcatBootsrap;
    }

    public String getManagerAppUrl() {
        IPreferenceStore pref = TomcatLauncherPlugin.getDefault().getPreferenceStore();
        return pref.getString(TOMCAT_PREF_MANAGER_URL);
    }

    public String getManagerAppUser() {
        IPreferenceStore pref = TomcatLauncherPlugin.getDefault().getPreferenceStore();
        return pref.getString(TOMCAT_PREF_MANAGER_USER);
    }

    public String getManagerAppPassword() {
        IPreferenceStore pref = TomcatLauncherPlugin.getDefault().getPreferenceStore();
        return pref.getString(TOMCAT_PREF_MANAGER_PASSWORD);
    }

    public static void log(String msg) {
        ILog log = TomcatLauncherPlugin.getDefault().getLog();
        Status status = new Status(4, TomcatLauncherPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 4, String.valueOf(msg) + "\n", null);
        log.log((IStatus)status);
    }

    public static void log(Exception ex) {
        ILog log = TomcatLauncherPlugin.getDefault().getLog();
        StringWriter stringWriter = new StringWriter();
        ex.printStackTrace(new PrintWriter(stringWriter));
        String msg = stringWriter.getBuffer().toString();
        Status status = new Status(4, TomcatLauncherPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 4, msg, null);
        log.log((IStatus)status);
    }

    public IPath getTomcatIPath() {
        IPath tomcatPath = this.getTomcatClasspathVariable();
        if (tomcatPath == null) {
            return new Path(TomcatLauncherPlugin.getDefault().getTomcatDir());
        }
        return new Path(TOMCAT_HOME_CLASSPATH_VARIABLE);
    }

    private IPath getTomcatClasspathVariable() {
        IPath tomcatPath = JavaCore.getClasspathVariable((String)TOMCAT_HOME_CLASSPATH_VARIABLE);
        if (tomcatPath == null) {
            this.initTomcatClasspathVariable();
            tomcatPath = JavaCore.getClasspathVariable((String)TOMCAT_HOME_CLASSPATH_VARIABLE);
        }
        return tomcatPath;
    }

    public void initTomcatClasspathVariable() {
        try {
            JavaCore.setClasspathVariable((String)TOMCAT_HOME_CLASSPATH_VARIABLE, (IPath)new Path(TomcatLauncherPlugin.getDefault().getTomcatDir()), null);
        }
        catch (JavaModelException e) {
            TomcatLauncherPlugin.log((Exception)((Object)e));
        }
    }

    public void setProjectsInCP(List projectsInCP) {
        TomcatLauncherPlugin.saveProjectsToPreferenceStore(projectsInCP, TOMCAT_PREF_PROJECTSINCP_KEY);
    }

    public List getProjectsInCP() {
        return TomcatLauncherPlugin.readProjectsFromPreferenceStore(TOMCAT_PREF_PROJECTSINCP_KEY);
    }

    public void setProjectsInSourcePath(List projectsInCP) {
        TomcatLauncherPlugin.saveProjectsToPreferenceStore(projectsInCP, TOMCAT_PREF_PROJECTSINSOURCEPATH_KEY);
    }

    public List getProjectsInSourcePath() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] allProjects = root.getProjects();
        ArrayList tempList = new ArrayList(allProjects.length);
        IPreferenceStore pref = TomcatLauncherPlugin.getDefault().getPreferenceStore();
        boolean automaticallyComputed = pref.getBoolean(TOMCAT_PREF_COMPUTESOURCEPATH_KEY);
        if (automaticallyComputed) {
            return this.computeProjectsInSourcePath();
        }
        return this.readProjectsInSourcePathFromPref();
    }

    public List readProjectsInSourcePathFromPref() {
        IPreferenceStore pref = TomcatLauncherPlugin.getDefault().getPreferenceStore();
        if (!pref.contains(TOMCAT_PREF_PROJECTSINSOURCEPATH_KEY)) {
            pref.setValue(TOMCAT_PREF_COMPUTESOURCEPATH_KEY, true);
            return this.computeProjectsInSourcePath();
        }
        return TomcatLauncherPlugin.readProjectsFromPreferenceStore(TOMCAT_PREF_PROJECTSINSOURCEPATH_KEY);
    }

    private List computeProjectsInSourcePath() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] allProjects = root.getProjects();
        ArrayList<ProjectListElement> tempList = new ArrayList<ProjectListElement>(allProjects.length);
        ArrayList<IProject> alreadyAdded = new ArrayList<IProject>();
        int i = 0;
        while (i < allProjects.length) {
            IProject project = allProjects[i];
            try {
                if (project.isOpen() && project.hasNature(NATURE_ID)) {
                    IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
                    if (!alreadyAdded.contains(project)) {
                        tempList.add(new ProjectListElement(javaProject.getProject()));
                        alreadyAdded.add(project);
                    }
                    String[] reqProjects = javaProject.getRequiredProjectNames();
                    int j = 0;
                    while (j < allProjects.length) {
                        int k = 0;
                        while (k < reqProjects.length) {
                            if (allProjects[j].getName().equals(reqProjects[k]) && allProjects[j].isOpen() && allProjects[j].hasNature("org.eclipse.jdt.core.javanature") && !alreadyAdded.contains(allProjects[j])) {
                                tempList.add(new ProjectListElement(allProjects[j].getNature("org.eclipse.jdt.core.javanature").getProject()));
                                alreadyAdded.add(allProjects[j]);
                            }
                            ++k;
                        }
                        ++j;
                    }
                }
            }
            catch (CoreException e) {
                TomcatLauncherPlugin.log((Exception)((Object)e));
            }
            ++i;
        }
        return tempList;
    }

    static void saveProjectsToPreferenceStore(List projectList, String keyInPreferenceStore) {
        IPreferenceStore pref = TomcatLauncherPlugin.getDefault().getPreferenceStore();
        StringBuffer buf = new StringBuffer();
        Iterator it = projectList.iterator();
        while (it.hasNext()) {
            ProjectListElement each = (ProjectListElement)it.next();
            buf.append(each.getID());
            buf.append(';');
        }
        pref.setValue(keyInPreferenceStore, buf.toString());
    }

    static List readProjectsFromPreferenceStore(String keyInPreferenceStore) {
        IPreferenceStore pref = TomcatLauncherPlugin.getDefault().getPreferenceStore();
        String stringList = pref.getString(keyInPreferenceStore);
        ArrayList<String> projectsIdList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(stringList, ";");
        while (tokenizer.hasMoreElements()) {
            projectsIdList.add(tokenizer.nextToken());
        }
        return ProjectListElement.stringsToProjectsList(projectsIdList);
    }

    public static boolean checkTomcatSettingsAndWarn() {
        if (!TomcatLauncherPlugin.isTomcatConfigured()) {
            String msg = TomcatLauncherPlugin.getResourceString("msg.noconfiguration");
            MessageDialog.openWarning((Shell)TomcatLauncherPlugin.getShell(), (String)"Tomcat", (String)msg);
            return false;
        }
        return true;
    }

    public static boolean isTomcatConfigured() {
        return !TomcatLauncherPlugin.getDefault().getTomcatDir().equals("");
    }

    public void startup() throws CoreException {
        super.startup();
        this.fixTomcatHomeBug();
    }

    protected void initializeDefaultPluginPreferences() {
        this.getPreferenceStore().setDefault(TOMCAT_PREF_CONFMODE_KEY, SERVERXML_MODE);
        super.initializeDefaultPluginPreferences();
    }
}

