/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat;

import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import com.sysdeo.eclipse.tomcat.TomcatPluginResources;
import com.sysdeo.eclipse.tomcat.editors.ClasspathFieldEditor;
import com.sysdeo.eclipse.tomcat.editors.ComboFieldEditor;
import com.sysdeo.eclipse.tomcat.editors.ListFieldEditor;
import java.util.ArrayList;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TomcatJVMPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
TomcatPluginResources {
    private static final int FIELD_WIDTH = 50;
    private ComboFieldEditor jvmChoice;
    private ListFieldEditor jvmParamaters;
    private ClasspathFieldEditor jvmClasspath;
    private ClasspathFieldEditor jvmBootClasspath;
    private BooleanFieldEditor debugModeEditor;

    public TomcatJVMPreferencePage() {
        this.setPreferenceStore(TomcatLauncherPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 512);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite);
        composite.setLayout((Layout)new GridLayout(2, false));
        ArrayList<IVMInstall> allVMs = new ArrayList<IVMInstall>();
        IVMInstallType[] vmTypes = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < vmTypes.length) {
            IVMInstall[] vms = vmTypes[i].getVMInstalls();
            int j = 0;
            while (j < vms.length) {
                allVMs.add(vms[j]);
                ++j;
            }
            ++i;
        }
        String[][] namesAndValues = new String[allVMs.size()][2];
        int i2 = 0;
        while (i2 < allVMs.size()) {
            namesAndValues[i2][0] = ((IVMInstall)allVMs.get(i2)).getName();
            namesAndValues[i2][1] = ((IVMInstall)allVMs.get(i2)).getId();
            ++i2;
        }
        this.jvmChoice = new ComboFieldEditor("tomcatJRE", TomcatPluginResources.PREF_PAGE_JRE_LABEL, namesAndValues, composite);
        this.debugModeEditor = new BooleanFieldEditor("tomcatDebugMode", TomcatPluginResources.PREF_PAGE_DEBUGMODE_LABEL, composite);
        this.initField((FieldEditor)this.debugModeEditor);
        new Label(composite, 0);
        Composite group = new Composite(composite, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        group.setLayout((Layout)new GridLayout(2, false));
        Button btAddLaunch = new Button(group, 8);
        btAddLaunch.setText(TomcatPluginResources.PREF_PAGE_CREATE_LAUNCH_LABEL);
        btAddLaunch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TomcatLauncherPlugin.getDefault().getTomcatBootstrap().addLaunch();
                }
                catch (Exception ex) {
                    TomcatLauncherPlugin.log("Failed to create launch configuration/n");
                    TomcatLauncherPlugin.log(ex);
                }
            }
        });
        Button btLog = new Button(group, 8);
        btLog.setText(TomcatPluginResources.PREF_PAGE_DUMP_CONFIG_LABEL);
        btLog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TomcatLauncherPlugin.getDefault().getTomcatBootstrap().logConfig();
                }
                catch (Exception ex) {
                    TomcatLauncherPlugin.log("Failed to create launch configuration/n");
                    TomcatLauncherPlugin.log(ex);
                }
            }
        });
        this.jvmParamaters = new ListFieldEditor("jvmParameters", TomcatPluginResources.PREF_PAGE_PARAMETERS_LABEL, composite);
        this.jvmClasspath = new ClasspathFieldEditor("jvmClasspath", TomcatPluginResources.PREF_PAGE_CLASSPATH_LABEL, composite);
        this.jvmBootClasspath = new ClasspathFieldEditor("jvmBootClasspath", TomcatPluginResources.PREF_PAGE_BOOTCLASSPATH_LABEL, composite);
        this.initField(this.jvmChoice);
        this.initField((FieldEditor)this.jvmParamaters);
        this.initField((FieldEditor)this.jvmClasspath);
        this.initField((FieldEditor)this.jvmBootClasspath);
        composite.setSize(composite.computeSize(-1, -1));
        return scrolledComposite;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.jvmChoice.store();
        this.jvmBootClasspath.store();
        this.jvmClasspath.store();
        this.jvmParamaters.store();
        this.debugModeEditor.store();
        TomcatLauncherPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void initField(FieldEditor field) {
        field.setPreferenceStore(this.getPreferenceStore());
        field.setPreferencePage((PreferencePage)this);
        field.load();
    }
}

