/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat;

import com.sysdeo.eclipse.tomcat.StringUtil;
import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import com.sysdeo.eclipse.tomcat.TomcatPluginResources;
import com.sysdeo.eclipse.tomcat.TomcatProject;
import com.sysdeo.eclipse.tomcat.VMLauncherUtility;
import com.sysdeo.eclipse.tomcat.WebClassPathEntries;
import com.sysdeo.eclipse.tomcat.editors.ProjectListElement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.sourcelookup.JavaSourceLocator;

public abstract class TomcatBootstrap {
    private static final String WEBAPP_CLASSPATH_FILENAME = ".#webclasspath";
    private static final int RUN = 1;
    private static final int LOG = 2;
    private static final int ADD_LAUNCH = 3;

    public abstract String[] getClasspath();

    public abstract String[] getVmArgs();

    public abstract String[] getPrgArgs(String var1);

    public abstract String getStartCommand();

    public abstract String getStopCommand();

    public abstract String getMainClass();

    public abstract String getLabel();

    public abstract String getContextWorkDir(String var1);

    public abstract IPath getServletJarPath();

    public abstract IPath getJasperJarPath();

    public abstract IPath getJSPJarPath();

    public abstract String getXMLTagAfterContextDefinition();

    public void start() throws CoreException {
        this.runTomcatBootsrap(this.getStartCommand(), true, 1, true);
    }

    public void stop() throws CoreException {
        this.runTomcatBootsrap(this.getStopCommand(), false, 1, false);
    }

    public void restart() throws CoreException {
        this.stop();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.start();
    }

    public void logConfig() throws CoreException {
        this.runTomcatBootsrap(this.getStartCommand(), true, 2, false);
    }

    public void addLaunch() throws CoreException {
        this.runTomcatBootsrap(this.getStartCommand(), true, 3, true);
    }

    private void runTomcatBootsrap(String tomcatBootOption, boolean showInDebugger, int action, boolean saveConfig) throws CoreException {
        String[] prgArgs = this.getPrgArgs(tomcatBootOption);
        IProject[] projects = TomcatLauncherPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            TomcatProject tomcatProject;
            if (projects[i].isOpen() && (tomcatProject = (TomcatProject)projects[i].getNature("com.sysdeo.eclipse.tomcat.tomcatnature")) != null) {
                ArrayList al = new ArrayList();
                ArrayList visitedProjects = new ArrayList();
                IJavaProject javaProject = (IJavaProject)projects[i].getNature("org.eclipse.jdt.core.javanature");
                WebClassPathEntries entries = tomcatProject.getWebClassPathEntries();
                if (entries != null) {
                    this.getClassPathEntries(javaProject, al, entries.getList(), visitedProjects);
                    IFile file = null;
                    file = tomcatProject.getRootDirFolder() == null ? projects[i].getFile((IPath)new Path(WEBAPP_CLASSPATH_FILENAME)) : tomcatProject.getRootDirFolder().getFile((IPath)new Path(WEBAPP_CLASSPATH_FILENAME));
                    File cpFile = file.getLocation().makeAbsolute().toFile();
                    if (cpFile.exists()) {
                        cpFile.delete();
                    }
                    try {
                        if (cpFile.createNewFile()) {
                            PrintWriter pw = new PrintWriter(new FileOutputStream(cpFile));
                            int j = 0;
                            while (j < al.size()) {
                                pw.println(al.get(j));
                                ++j;
                            }
                            pw.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        String[] classpath = new String[]{};
        classpath = this.addPreferenceJvmToClasspath(classpath);
        classpath = this.addPreferenceProjectListToClasspath(classpath);
        classpath = StringUtil.concatUniq(classpath, this.getClasspath());
        String[] vmArgs = this.getVmArgs();
        vmArgs = this.addPreferenceParameters(vmArgs);
        String[] bootClasspath = this.addPreferenceJvmToBootClasspath(new String[0]);
        StringBuffer programArguments = new StringBuffer();
        int i2 = 0;
        while (i2 < prgArgs.length) {
            programArguments.append(" " + prgArgs[i2]);
            ++i2;
        }
        StringBuffer jvmArguments = new StringBuffer();
        int i3 = 0;
        while (i3 < vmArgs.length) {
            jvmArguments.append(" " + vmArgs[i3]);
            ++i3;
        }
        if (action == 1) {
            VMLauncherUtility.runVM(this.getLabel(), this.getMainClass(), classpath, bootClasspath, jvmArguments.toString(), programArguments.toString(), this.getSourceLocator(), this.isDebugMode(), showInDebugger, saveConfig);
        }
        if (action == 2) {
            VMLauncherUtility.log(this.getLabel(), this.getMainClass(), classpath, bootClasspath, jvmArguments.toString(), programArguments.toString(), this.getSourceLocator(), this.isDebugMode(), showInDebugger);
        }
        if (action == 3) {
            VMLauncherUtility.createConfig(this.getLabel(), this.getMainClass(), classpath, bootClasspath, jvmArguments.toString(), programArguments.toString(), this.getSourceLocator(), this.isDebugMode(), showInDebugger, true);
        }
    }

    private void add(ArrayList data, IPath entry) {
        String tmp;
        if (!entry.isAbsolute()) {
            entry = entry.makeAbsolute();
        }
        if (!data.contains(tmp = entry.toFile().toString())) {
            data.add(tmp);
        }
    }

    private void add(ArrayList data, IResource con) {
        if (con == null) {
            return;
        }
        this.add(data, con.getLocation());
    }

    private void getClassPathEntries(IJavaProject prj, ArrayList data, List selectedPaths, ArrayList visitedProjects) {
        IClasspathEntry[] entries = null;
        IPath outputPath = null;
        try {
            outputPath = prj.getOutputLocation();
            if (selectedPaths.contains(outputPath.toFile().toString().replace('\\', '/'))) {
                this.add(data, prj.getProject().getWorkspace().getRoot().findMember(outputPath));
            }
            entries = prj.getRawClasspath();
        }
        catch (JavaModelException e) {
            TomcatLauncherPlugin.log((Exception)((Object)e));
        }
        if (entries == null) {
            return;
        }
        int i = 0;
        while (i < entries.length) {
            block22: {
                IClasspathEntry entry = entries[i];
                IPath path = entry.getPath();
                if (entry.getEntryKind() != 3 || (path = entry.getOutputLocation()) != null) {
                    if (entry.getEntryKind() == 2) {
                        String prjName = entry.getPath().lastSegment();
                        if (!visitedProjects.contains(prjName)) {
                            visitedProjects.add(prjName);
                            this.getClassPathEntries(prj.getJavaModel().getJavaProject(prjName), data, selectedPaths, visitedProjects);
                        }
                    } else if (selectedPaths.contains(path.toFile().toString().replace('\\', '/'))) {
                        IClasspathEntry[] tmpEntry;
                        block21: {
                            tmpEntry = null;
                            if (entry.getEntryKind() == 5) {
                                try {
                                    tmpEntry = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)prj).getClasspathEntries();
                                    break block21;
                                }
                                catch (JavaModelException e1) {
                                    TomcatLauncherPlugin.log((Exception)((Object)e1));
                                    break block22;
                                }
                            }
                            tmpEntry = new IClasspathEntry[]{JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry)};
                        }
                        int j = 0;
                        while (j < tmpEntry.length) {
                            if (entry.getEntryKind() == 1) {
                                IResource res = prj.getProject().getWorkspace().getRoot().findMember(tmpEntry[j].getPath());
                                if (res != null) {
                                    this.add(data, res);
                                } else {
                                    this.add(data, tmpEntry[j].getPath());
                                }
                            } else if (entry.getEntryKind() == 3) {
                                IPath srcPath = entry.getOutputLocation();
                                if (srcPath != null && !srcPath.equals((Object)outputPath)) {
                                    this.add(data, prj.getProject().getWorkspace().getRoot().findMember(srcPath));
                                }
                            } else {
                                this.add(data, tmpEntry[j].getPath());
                            }
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
    }

    private boolean isDebugMode() {
        return TomcatLauncherPlugin.getDefault().isDebugMode();
    }

    private ISourceLocator getSourceLocator() throws CoreException {
        ArrayList<IProjectNature> tempList = new ArrayList<IProjectNature>();
        List projects = TomcatLauncherPlugin.getDefault().getProjectsInSourcePath();
        Iterator iter = projects.iterator();
        while (iter.hasNext()) {
            IProject project = ((ProjectListElement)iter.next()).getProject();
            if (!project.isOpen() || !project.hasNature("org.eclipse.jdt.core.javanature")) continue;
            tempList.add(project.getNature("org.eclipse.jdt.core.javanature"));
        }
        JavaSourceLocator sourceLocator = null;
        if (!tempList.isEmpty()) {
            IJavaProject[] javaProjects = tempList.toArray(new IJavaProject[1]);
            sourceLocator = new JavaSourceLocator(javaProjects, true);
        }
        return sourceLocator;
    }

    protected String getTomcatDir() {
        return TomcatLauncherPlugin.getDefault().getTomcatDir();
    }

    protected String getTomcatBase() {
        return TomcatLauncherPlugin.getDefault().getTomcatBase();
    }

    private String[] addPreferenceProjectListToClasspath(String[] previouscp) {
        List projectsList = TomcatLauncherPlugin.getDefault().getProjectsInCP();
        String[] result = previouscp;
        Iterator it = projectsList.iterator();
        while (it.hasNext()) {
            try {
                ProjectListElement ple = (ProjectListElement)it.next();
                IJavaProject jproject = JavaCore.create((IProject)ple.getProject());
                result = this.addProjectToClasspath(result, jproject);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private String[] addProjectToClasspath(String[] previouscp, IJavaProject project) throws CoreException {
        if (project != null && project.exists() && project.isOpen()) {
            String[] projectcp = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)project);
            return StringUtil.concatUniq(projectcp, previouscp);
        }
        return previouscp;
    }

    private String[] addPreferenceParameters(String[] previous) {
        String[] prefParams = StringUtil.cutString(TomcatLauncherPlugin.getDefault().getJvmParamaters(), TomcatPluginResources.PREF_PAGE_LIST_SEPARATOR);
        return StringUtil.concat(previous, prefParams);
    }

    private String[] addPreferenceJvmToClasspath(String[] previous) {
        String[] prefClasspath = StringUtil.cutString(TomcatLauncherPlugin.getDefault().getJvmClasspath(), TomcatPluginResources.PREF_PAGE_LIST_SEPARATOR);
        return StringUtil.concatUniq(previous, prefClasspath);
    }

    private String[] addPreferenceJvmToBootClasspath(String[] previous) {
        String[] prefBootClasspath = StringUtil.cutString(TomcatLauncherPlugin.getDefault().getJvmBootClasspath(), TomcatPluginResources.PREF_PAGE_LIST_SEPARATOR);
        return StringUtil.concatUniq(previous, prefBootClasspath);
    }
}

