/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.editors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.tigris.subversion.subclipse.graph.cache.Node;
import org.tigris.subversion.subclipse.graph.editors.NodeFigure;
import org.tigris.subversion.subclipse.graph.editors.RevisionEditPart;
import org.tigris.subversion.subclipse.graph.editors.RevisionGraphEditor;
import org.tigris.subversion.subclipse.graph.popup.actions.BranchTagAction;
import org.tigris.subversion.subclipse.graph.popup.actions.CompareRevisionsAction;
import org.tigris.subversion.subclipse.graph.popup.actions.ImageAction;
import org.tigris.subversion.subclipse.graph.popup.actions.RefreshNodeAction;
import org.tigris.subversion.subclipse.graph.popup.actions.RevisionDetailsAction;
import org.tigris.subversion.subclipse.graph.popup.actions.SetCommitPropertiesAction;

public class RevisionGraphMenuProvider
extends ContextMenuProvider {
    private RevisionGraphEditor editor;

    public RevisionGraphMenuProvider(EditPartViewer viewer, RevisionGraphEditor editor) {
        super(viewer);
        this.editor = editor;
    }

    public void buildContextMenu(IMenuManager menu) {
        List selectedRevisions = this.getSelectedRevisions();
        if (selectedRevisions.size() == 1) {
            RevisionEditPart revision = (RevisionEditPart)((Object)selectedRevisions.get(0));
            Node node = (Node)revision.getModel();
            NodeFigure nodeFigure = (NodeFigure)revision.getFigure();
            menu.add((IAction)new RevisionDetailsAction(node, this.editor));
            menu.add((IAction)new SetCommitPropertiesAction(nodeFigure, this.editor));
            menu.add((IAction)new BranchTagAction("Create Branch/Tag from Revision " + node.getRevision() + "...", this.editor, node));
        }
        menu.add((IAction)new RefreshNodeAction(selectedRevisions, this.editor));
        menu.add((IContributionItem)new Separator());
        if (selectedRevisions.size() == 2) {
            RevisionEditPart revision1 = (RevisionEditPart)((Object)selectedRevisions.get(0));
            Node node1 = (Node)revision1.getModel();
            RevisionEditPart revision2 = (RevisionEditPart)((Object)selectedRevisions.get(1));
            Node node2 = (Node)revision2.getModel();
            menu.add((IAction)new CompareRevisionsAction(node1, node2, this.editor));
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)new ImageAction(this.editor));
    }

    private List getSelectedRevisions() {
        ArrayList<EditPart> selectedRevisions = new ArrayList<EditPart>();
        List selectedEditParts = this.getViewer().getSelectedEditParts();
        Iterator iter = selectedEditParts.iterator();
        while (iter.hasNext()) {
            EditPart editPart = (EditPart)iter.next();
            if (!(editPart instanceof RevisionEditPart)) continue;
            selectedRevisions.add(editPart);
        }
        return selectedRevisions;
    }
}

