/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.NotifyInformation;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.RevisionRange;
import org.tigris.subversion.svnclientadapter.SVNNotificationHandler;
import org.tigris.subversion.svnclientadapter.javahl.JhlConverter;
import org.tigris.subversion.svnclientadapter.utils.Messages;

public class JhlNotificationHandler
extends SVNNotificationHandler
implements Notify2 {
    private boolean receivedSomeChange;
    private boolean sentFirstTxdelta;
    private int updates;
    private int adds;
    private int deletes;
    private int conflicts;
    private int merges;
    private int exists;
    private int propConflicts;
    private int treeConflicts;
    private int propMerges;
    private int propUpdates;
    private boolean inExternal;
    private boolean holdStats;
    private String lastUpdate;
    private String lastExternalUpdate;
    private boolean statsCommand = false;
    private static final int COMMIT_ACROSS_WC_COMPLETED = -11;
    private static final int ENDED_ABNORMAL = -1;

    public void onNotify(NotifyInformation info) {
        boolean notify = true;
        switch (info.getAction()) {
            case -1: {
                if (this.command == 3) {
                    this.logError(Messages.bind((String)"notify.commit.abnormal"));
                } else {
                    this.logError(Messages.bind((String)"notify.end.abnormal"));
                }
                if (info.getErrMsg() != null) {
                    this.logError(info.getErrMsg());
                }
                notify = false;
                break;
            }
            case 29: {
                if (info.getMergeRange() != null) {
                    if (info.getMergeRange().getFromRevision().equals((Object)info.getMergeRange().getToRevision())) {
                        this.logMessage("--- Merging (from foreign repository) r" + info.getMergeRange().getFromRevision().toString() + " into " + info.getPath());
                    } else if (info.getMergeRange().getToRevision().equals((Object)Revision.HEAD) || RevisionRange.getRevisionAsLong((Revision)info.getMergeRange().getToRevision()) > RevisionRange.getRevisionAsLong((Revision)info.getMergeRange().getFromRevision())) {
                        this.logMessage("--- Merging (from foreign repository) r" + info.getMergeRange().getFromRevision().toString() + " through r" + info.getMergeRange().getToRevision().toString() + " into " + info.getPath());
                    } else {
                        this.logMessage("--- Reverse-merging (from foreign repository) r" + info.getMergeRange().getFromRevision().toString() + " through r" + info.getMergeRange().getToRevision().toString() + " into " + info.getPath());
                    }
                } else {
                    this.logMessage("--- Merging differences between foreign repository URLs into " + info.getPath());
                }
                notify = false;
                break;
            }
            case 28: {
                if (info.getMergeRange() != null) {
                    if (info.getMergeRange().getFromRevision().equals((Object)info.getMergeRange().getToRevision())) {
                        this.logMessage("--- Merging r" + info.getMergeRange().getFromRevision().toString() + " into " + info.getPath());
                    } else if (info.getMergeRange().getToRevision().equals((Object)Revision.HEAD) || RevisionRange.getRevisionAsLong((Revision)info.getMergeRange().getToRevision()) > RevisionRange.getRevisionAsLong((Revision)info.getMergeRange().getFromRevision())) {
                        this.logMessage("--- Merging r" + info.getMergeRange().getFromRevision().toString() + " through r" + info.getMergeRange().getToRevision().toString() + " into " + info.getPath());
                    } else {
                        this.logMessage("--- Reverse-merging r" + info.getMergeRange().getFromRevision().toString() + " through r" + info.getMergeRange().getToRevision().toString() + " into " + info.getPath());
                    }
                } else {
                    this.logMessage("--- Merging differences between repository URLs into " + info.getPath());
                }
                notify = false;
                break;
            }
            case 7: {
                this.logMessage(Messages.bind((String)"notify.skipped", (String)info.getPath()));
                notify = false;
                break;
            }
            case 23: {
                if (info.getErrMsg() == null) {
                    this.logError(Messages.bind((String)"notify.lock.failed", (String)info.getPath()));
                } else {
                    this.logError(info.getErrMsg());
                }
                notify = false;
                break;
            }
            case 24: {
                if (info.getErrMsg() == null) {
                    this.logError(Messages.bind((String)"notify.unlock.failed", (String)info.getPath()));
                } else {
                    this.logError(info.getErrMsg());
                }
                notify = false;
                break;
            }
            case 21: {
                if (info.getLock() != null && info.getLock().getOwner() != null) {
                    this.logMessage(Messages.bind((String)"notify.lock.other", (String)info.getLock().getPath(), (String)info.getLock().getOwner()));
                } else {
                    this.logMessage(Messages.bind((String)"notify.lock", (String)info.getPath()));
                }
                notify = false;
                break;
            }
            case 22: {
                this.logMessage(Messages.bind((String)"notify.unlock", (String)info.getPath()));
                notify = false;
                break;
            }
            case 8: {
                this.logMessage("D   " + info.getPath());
                this.receivedSomeChange = true;
                ++this.deletes;
                break;
            }
            case 30: {
                this.logMessage("R   " + info.getPath());
                this.receivedSomeChange = true;
                ++this.adds;
                ++this.deletes;
                break;
            }
            case 9: {
                this.logMessage("A   " + info.getPath());
                this.receivedSomeChange = true;
                ++this.adds;
                break;
            }
            case 25: {
                this.logMessage("E   " + info.getPath());
                this.receivedSomeChange = true;
                ++this.exists;
                break;
            }
            case 3: {
                this.logMessage(Messages.bind((String)"notify.restored", (String)info.getPath()));
                break;
            }
            case 4: {
                this.logMessage(Messages.bind((String)"notify.reverted", (String)info.getPath()));
                break;
            }
            case 5: {
                this.logError(Messages.bind((String)"notify.revert.failed", (String)info.getPath()));
                notify = false;
                break;
            }
            case 6: {
                this.logMessage(Messages.bind((String)"notify.resolved", (String)info.getPath()));
                break;
            }
            case 0: {
                this.logMessage("A         " + info.getPath());
                break;
            }
            case 2: {
                this.logMessage("D         " + info.getPath());
                this.receivedSomeChange = true;
                break;
            }
            case 38: {
                this.logError("  C " + info.getPath());
                this.receivedSomeChange = true;
                ++this.treeConflicts;
                break;
            }
            case 10: {
                boolean error = false;
                if (info.getKind() == 2 && (info.getPropState() == 0 || info.getPropState() == 1 || info.getPropState() == 2)) break;
                this.receivedSomeChange = true;
                char[] statecharBuf = new char[]{' ', ' '};
                if (info.getKind() == 1) {
                    if (info.getContentState() == 7) {
                        statecharBuf[0] = 67;
                        ++this.conflicts;
                        error = true;
                    } else if (info.getContentState() == 6) {
                        statecharBuf[0] = 71;
                        ++this.merges;
                        error = true;
                    } else if (info.getContentState() == 5) {
                        statecharBuf[0] = 85;
                        ++this.updates;
                    } else if (info.getContentState() == 2 && this.command == 27 && info.getPropState() < 4) break;
                }
                if (info.getPropState() == 7) {
                    statecharBuf[1] = 67;
                    ++this.propConflicts;
                    error = true;
                } else if (info.getPropState() == 6) {
                    statecharBuf[1] = 71;
                    ++this.propMerges;
                    error = true;
                } else if (info.getPropState() == 5) {
                    statecharBuf[1] = 85;
                    ++this.propUpdates;
                }
                if (this.command == 27 && info.getContentState() == 1 && info.getPropState() == 1) break;
                if (error) {
                    this.logError("" + statecharBuf[0] + statecharBuf[1] + "  " + info.getPath());
                    break;
                }
                this.logMessage("" + statecharBuf[0] + statecharBuf[1] + "  " + info.getPath());
                break;
            }
            case 12: {
                this.logMessage(Messages.bind((String)"notify.update.external", (String)info.getPath()));
                this.inExternal = true;
                break;
            }
            case 11: {
                notify = false;
                if (info.getRevision() >= 0L) {
                    this.logRevision(info.getRevision(), info.getPath());
                    if (this.command == 8) {
                        this.logCompleted(Messages.bind((String)"notify.export", (String)Long.toString(info.getRevision())));
                        break;
                    }
                    if (this.command == 2) {
                        this.logCompleted(Messages.bind((String)"notify.checkout", (String)Long.toString(info.getRevision())));
                        break;
                    }
                    if (this.receivedSomeChange) {
                        if (this.holdStats) {
                            if (this.inExternal) {
                                this.lastExternalUpdate = Messages.bind((String)"notify.update", (String)Long.toString(info.getRevision()));
                                break;
                            }
                            this.lastUpdate = Messages.bind((String)"notify.update", (String)Long.toString(info.getRevision()));
                            break;
                        }
                        this.logCompleted(Messages.bind((String)"notify.update", (String)Long.toString(info.getRevision())));
                        break;
                    }
                    this.logCompleted(Messages.bind((String)"notify.at", (String)Long.toString(info.getRevision())));
                    break;
                }
                if (this.command == 8) {
                    this.logCompleted(Messages.bind((String)"notify.export.complete"));
                    break;
                }
                if (this.command == 2) {
                    this.logCompleted(Messages.bind((String)"notify.checkout.complete"));
                    break;
                }
                this.logCompleted(Messages.bind((String)"notify.update.complete"));
                break;
            }
            case 14: {
                if (!this.skipCommand()) {
                    this.logMessage(Messages.bind((String)"notify.status.external", (String)info.getPath()));
                }
                notify = false;
                break;
            }
            case 13: {
                notify = false;
                if (info.getRevision() < 0L) break;
                this.logRevision(info.getRevision(), info.getPath());
                if (this.skipCommand()) break;
                this.logMessage(Messages.bind((String)"notify.status.revision", (String)Long.toString(info.getRevision())));
                break;
            }
            case 15: {
                this.logMessage(Messages.bind((String)"notify.commit.modified", (String)info.getPath()));
                break;
            }
            case 16: {
                this.logMessage(Messages.bind((String)"notify.commit.add", (String)info.getPath()));
                break;
            }
            case 17: {
                this.logMessage(Messages.bind((String)"notify.commit.delete", (String)info.getPath()));
                break;
            }
            case 18: {
                this.logMessage(Messages.bind((String)"notify.commit.replace", (String)info.getPath()));
                break;
            }
            case 19: {
                notify = false;
                if (this.sentFirstTxdelta) break;
                this.logMessage(Messages.bind((String)"notify.commit.transmit"));
                this.sentFirstTxdelta = true;
                break;
            }
            case -11: {
                notify = false;
                this.logCompleted(Messages.bind((String)"notify.commit", (String)Long.toString(info.getRevision())));
                break;
            }
            case 31: {
                this.logMessage(Messages.bind((String)"notify.property.set", (String)info.getPath()));
                break;
            }
            case 32: {
                this.logMessage(Messages.bind((String)"notify.property.set", (String)info.getPath()));
                break;
            }
            case 33: {
                this.logMessage(Messages.bind((String)"notify.property.deleted", (String)info.getPath()));
                break;
            }
            case 34: {
                notify = false;
                this.logMessage(Messages.bind((String)"notify.property.deleted.nonexistent"));
                break;
            }
            case 35: {
                notify = false;
                this.logMessage(Messages.bind((String)"notify.revision.property.set"));
                break;
            }
            case 36: {
                notify = false;
                this.logMessage(Messages.bind((String)"notify.revision.property.deleted"));
                break;
            }
            case 37: {
                break;
            }
            case 20: {
                break;
            }
            default: {
                this.logMessage("Unknown action received: " + info.getAction());
            }
        }
        if (notify) {
            this.notifyListenersOfChange(info.getPath(), JhlConverter.convertNodeKind(info.getKind()));
        }
    }

    public void setCommand(int command) {
        this.receivedSomeChange = false;
        this.sentFirstTxdelta = false;
        if (command == 4 || command == 27 || command == 26) {
            this.clearStats();
            this.statsCommand = true;
        }
        super.setCommand(command);
    }

    public void logCompleted(String message) {
        super.logCompleted(message);
        if (this.inExternal) {
            this.inExternal = false;
        } else {
            this.logStats();
        }
    }

    private void clearStats() {
        this.adds = 0;
        this.updates = 0;
        this.deletes = 0;
        this.conflicts = 0;
        this.merges = 0;
        this.exists = 0;
        this.propConflicts = 0;
        this.treeConflicts = 0;
        this.propMerges = 0;
        this.propUpdates = 0;
        this.inExternal = false;
        this.holdStats = false;
        this.lastUpdate = null;
        this.lastExternalUpdate = null;
    }

    private void logStats() {
        if (this.holdStats) {
            return;
        }
        if (this.statsCommand) {
            if (this.fileStats()) {
                this.logMessage(Messages.bind((String)"notify.stats.file.head"));
                if (this.merges > 0) {
                    this.logMessage(Messages.bind((String)"notify.stats.merge", (String)Integer.toString(this.merges)));
                }
                if (this.deletes > 0) {
                    this.logMessage(Messages.bind((String)"notify.stats.delete", (String)Integer.toString(this.deletes)));
                }
                if (this.adds > 0) {
                    this.logMessage(Messages.bind((String)"notify.stats.add", (String)Integer.toString(this.adds)));
                }
                if (this.updates > 0) {
                    this.logMessage(Messages.bind((String)"notify.stats.update", (String)Integer.toString(this.updates)));
                }
                if (this.exists > 0) {
                    this.logMessage(Messages.bind((String)"notify.stats.exists", (String)Integer.toString(this.exists)));
                }
            }
            if (this.propStats()) {
                this.logMessage(Messages.bind((String)"notify.stats.prop.head"));
                if (this.propMerges > 0) {
                    this.logMessage(Messages.bind((String)"notify.stats.merge", (String)Integer.toString(this.propMerges)));
                }
                if (this.propUpdates > 0) {
                    this.logMessage(Messages.bind((String)"notify.stats.update", (String)Integer.toString(this.propUpdates)));
                }
            }
            if (this.conflictStats()) {
                this.logMessage(Messages.bind((String)"notify.stats.conflict.head"));
                if (this.conflicts > 0) {
                    this.logMessage(Messages.bind((String)"notify.stats.conflict", (String)Integer.toString(this.conflicts)));
                }
                if (this.propConflicts > 0) {
                    this.logMessage(Messages.bind((String)"notify.stats.prop.conflicts", (String)Integer.toString(this.propConflicts)));
                }
                if (this.treeConflicts > 0) {
                    this.logMessage(Messages.bind((String)"notify.stats.tree.conflicts", (String)Integer.toString(this.treeConflicts)));
                }
            }
            this.statsCommand = false;
            this.clearStats();
        }
    }

    private boolean fileStats() {
        return this.updates > 0 || this.adds > 0 || this.deletes > 0 || this.merges > 0 || this.exists > 0;
    }

    private boolean conflictStats() {
        return this.treeConflicts > 0 || this.propConflicts > 0 || this.conflicts > 0;
    }

    private boolean propStats() {
        return this.propUpdates > 0 || this.propMerges > 0;
    }

    public void holdStats() {
        this.holdStats = true;
    }

    public void releaseStats() {
        this.holdStats = false;
        if (this.command == 4) {
            if (this.lastExternalUpdate != null) {
                this.logCompleted(this.lastExternalUpdate);
            }
            if (this.lastUpdate != null) {
                this.logCompleted(this.lastUpdate);
            }
        }
        this.logStats();
    }
}

