/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.sharing;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.comments.CommitCommentArea;
import org.tigris.subversion.subclipse.ui.settings.CommentProperties;
import org.tigris.subversion.subclipse.ui.wizards.SVNWizardPage;
import org.tigris.subversion.subclipse.ui.wizards.sharing.ISVNRepositoryLocationProvider;

public class SharingWizardFinishPage
extends SVNWizardPage {
    private ISVNRepositoryLocationProvider repositoryLocationProvider;
    private CommitCommentArea commitCommentArea;
    private CommentProperties commentProperties;

    public SharingWizardFinishPage(String pageName, String title, ImageDescriptor titleImage, ISVNRepositoryLocationProvider repositoryLocationProvider) {
        super(pageName, title, titleImage);
        this.repositoryLocationProvider = repositoryLocationProvider;
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.sharing_finish_page_context");
        Label label = new Label(composite, 16448);
        label.setText(Policy.bind("SharingWizardFinishPage.message"));
        GridData data = new GridData();
        data.widthHint = 350;
        label.setLayoutData((Object)data);
        IProject project = this.repositoryLocationProvider.getProject();
        try {
            this.commentProperties = CommentProperties.getCommentProperties((IResource)project);
        }
        catch (SVNException sVNException) {}
        this.commitCommentArea = new CommitCommentArea(null, null, this.commentProperties);
        this.commitCommentArea.setProposedComment(Policy.bind("SharingWizard.initialImport"));
        if (this.commentProperties != null && this.commentProperties.getMinimumLogMessageSize() != 0) {
            ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SharingWizardFinishPage.this.setPageComplete(SharingWizardFinishPage.this.commitCommentArea.getCommentLength() >= SharingWizardFinishPage.this.commentProperties.getMinimumLogMessageSize());
                }
            };
            this.commitCommentArea.setModifyListener(modifyListener);
        }
        this.commitCommentArea.createArea(composite);
        this.setControl((Control)composite);
    }

    public String getComment() {
        return this.commitCommentArea.getComment();
    }
}

